/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menu.slots.trader.InteractionSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3917;

public class TraderMenu
extends Menu {
    public final ITraderSource traderSource;
    public final class_1657 player;
    public static final int SLOT_OFFSET = 15;
    InteractionSlot interactionSlot;
    class_1263 coins = new class_1277(5);
    List<class_1735> coinSlots = new ArrayList<class_1735>();

    public InteractionSlot getInteractionSlot() {
        return this.interactionSlot;
    }

    public class_1263 getCoinInventory() {
        return this.coins;
    }

    public List<class_1735> getCoinSlots() {
        return this.coinSlots;
    }

    public TraderMenu(int windowID, class_1661 inventory, long traderID) {
        this(ModMenus.TRADER, windowID, inventory, () -> TraderSaveData.GetTrader(inventory.field_7546.method_37908().field_9236, traderID));
    }

    protected TraderMenu(class_3917<?> type, int windowID, class_1661 inventory, Supplier<ITraderSource> traderSource) {
        this(type, windowID, inventory, ITraderSource.getSafeSource(traderSource));
    }

    protected TraderMenu(class_3917<?> type, int windowID, class_1661 inventory, ITraderSource traderSource) {
        super(type, windowID);
        this.player = inventory.field_7546;
        this.traderSource = traderSource;
        this.init((class_1263)inventory);
        for (TraderData trader : this.traderSource.getTraders()) {
            if (trader == null) continue;
            trader.userOpen(this.player);
        }
    }

    public TradeContext getContext(TraderData trader) {
        return TradeContext.create(trader, this.player).withCoinSlots(this.coins).withInteractionSlot(this.interactionSlot).build();
    }

    protected void init(class_1263 inventory) {
        int x;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.method_7621(new class_1735(inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.method_7621(new class_1735(inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coins.method_5439(); ++x) {
            this.coinSlots.add(this.method_7621(new CoinSlot(this.coins, x, 23 + (x + 4) * 18, 122)));
        }
        ArrayList<InteractionSlotData> slotData = new ArrayList<InteractionSlotData>();
        for (TraderData trader : this.traderSource.getTraders()) {
            trader.addInteractionSlots(slotData);
        }
        this.interactionSlot = new InteractionSlot(slotData, 23, 122);
        this.method_7621(this.interactionSlot);
    }

    public boolean method_7597(class_1657 player) {
        return this.traderSource != null && this.traderSource.getTraders().size() > 0;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.method_7607(player, this.coins);
        this.method_7607(player, this.interactionSlot.field_7871);
        if (this.traderSource != null) {
            for (TraderData trader : this.traderSource.getTraders()) {
                if (trader == null) continue;
                trader.userClose(this.player);
            }
        }
    }

    public void ExecuteTrade(int traderIndex, int tradeIndex) {
        if (this.traderSource == null) {
            this.closeMenu(this.player);
            return;
        }
        List<TraderData> traderList = this.traderSource.getTraders();
        if (traderIndex >= 0 && traderIndex < traderList.size()) {
            TraderData trader = this.traderSource.getTraders().get(traderIndex);
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader at index " + traderIndex + " is null.");
                return;
            }
            TradeContext.TradeResult result = trader.ExecuteTrade(this.getContext(trader), tradeIndex);
            if (result.hasMessage()) {
                LightmansCurrency.LogDebug(result.failMessage.getString());
            }
        } else {
            LightmansCurrency.LogWarning("Trader " + traderIndex + " is not a valid trader index.");
        }
    }

    public boolean isSingleTrader() {
        if (this.traderSource == null) {
            this.closeMenu(this.player);
            return false;
        }
        return this.traderSource.isSingleTrader() && this.traderSource.getTraders().size() == 1;
    }

    public TraderData getSingleTrader() {
        if (this.isSingleTrader()) {
            return this.traderSource.getSingleTrader();
        }
        return null;
    }

    public class_1799 method_7601(class_1657 playerEntity, int index) {
        class_1799 clickedStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            clickedStack = slotStack.method_7972();
            if (index < 36 ? !this.method_7616(slotStack, 36, this.field_7761.size(), false) : index < this.field_7761.size() && !this.method_7616(slotStack, 0, 36, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return clickedStack;
    }

    public void CollectCoinStorage() {
        if (this.isSingleTrader()) {
            LightmansCurrency.LogDebug("Attempting to collect coins from trader.");
            TraderData trader = this.getSingleTrader();
            if (trader != null && trader.hasPermission(this.player, "collectCoins")) {
                CoinValue payment = trader.getInternalStoredMoney();
                if (this.getContext(trader).givePayment(payment)) {
                    trader.clearStoredMoney();
                }
            } else {
                Permissions.PermissionWarning(this.player, "collect stored coins", "collectCoins");
            }
        }
    }

    public static class TraderMenuAllNetwork
    extends TraderMenu {
        public TraderMenuAllNetwork(int windowID, class_1661 inventory) {
            super(ModMenus.TRADER_NETWORK_ALL, windowID, inventory, ITraderSource.UniversalTraderSource(inventory.field_7546.method_37908().field_9236));
        }
    }

    public static class TraderMenuBlockSource
    extends TraderMenu {
        public TraderMenuBlockSource(int windowID, class_1661 inventory, class_2338 blockPosition) {
            super(ModMenus.TRADER_BLOCK, windowID, inventory, () -> {
                class_2586 be = inventory.field_7546.method_37908().method_8321(blockPosition);
                if (be instanceof ITraderSource) {
                    return (ITraderSource)be;
                }
                return null;
            });
        }
    }
}

