/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.InfoTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.TradeSelectTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.network.server.messages.traderinterface.CMessageInterfaceInteraction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class TraderInterfaceMenu
extends Menu {
    private final TraderInterfaceBlockEntity traderInterface;
    public final class_1657 player;
    public static final int SLOT_OFFSET = 15;
    private boolean canEditTabs = true;
    Map<Integer, TraderInterfaceTab> availableTabs = new HashMap<Integer, TraderInterfaceTab>();
    int currentTab = 0;

    public final TraderInterfaceBlockEntity getTraderInterface() {
        return this.traderInterface;
    }

    public Map<Integer, TraderInterfaceTab> getAllTabs() {
        return this.availableTabs;
    }

    public void setTab(int key, TraderInterfaceTab tab) {
        if (this.canEditTabs && tab != null) {
            this.availableTabs.put(key, tab);
        } else if (tab == null) {
            LightmansCurrency.LogError("Attempted to set a null storage tab in slot " + key);
        } else {
            LightmansCurrency.LogError("Attempted to define the tab in " + key + " but the tabs have been locked.");
        }
    }

    public int getCurrentTabIndex() {
        return this.currentTab;
    }

    public TraderInterfaceTab getCurrentTab() {
        return this.availableTabs.get(this.currentTab);
    }

    public boolean isClient() {
        return this.player.method_37908().field_9236;
    }

    public TraderInterfaceMenu(int windowID, class_1661 inventory, class_2338 blockPos) {
        super(ModMenus.TRADER_INTERFACE, windowID);
        this.player = inventory.field_7546;
        class_2586 blockEntity = this.player.method_37908().method_8321(blockPos);
        this.traderInterface = blockEntity instanceof TraderInterfaceBlockEntity ? (TraderInterfaceBlockEntity)blockEntity : null;
        this.setTab(0, new InfoTab(this));
        this.setTab(2, new TraderSelectTab(this));
        this.setTab(3, new TradeSelectTab(this));
        this.setTab(100, new OwnershipTab(this));
        if (this.traderInterface != null) {
            this.traderInterface.initMenuTabs(this);
        }
        this.canEditTabs = false;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, 23 + x * 18, 154 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 23 + x * 18, 212));
        }
        this.availableTabs.forEach((key, tab) -> tab.addStorageMenuSlots(x$0 -> this.method_7621((class_1735)x$0)));
        try {
            this.getCurrentTab().onTabOpen();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.traderInterface != null && !this.traderInterface.method_11015() && this.traderInterface.canAccess(player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.availableTabs.forEach((key, tab) -> tab.onMenuClose());
    }

    public TradeContext getTradeContext() {
        return this.traderInterface.getTradeContext();
    }

    public class_1799 method_7601(class_1657 playerEntity, int index) {
        class_1799 clickedStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            clickedStack = slotStack.method_7972();
            if (index < 36 ? !this.getCurrentTab().quickMoveStack(slotStack) && !this.method_7616(slotStack, 36, this.field_7761.size(), false) : index < this.field_7761.size() && !this.method_7616(slotStack, 0, 36, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return clickedStack;
    }

    public void changeTab(int key, class_2487 extraData) {
        if (this.currentTab == key) {
            return;
        }
        if (this.availableTabs.containsKey(key)) {
            if (this.availableTabs.get(key).canOpen(this.player)) {
                this.getCurrentTab().onTabClose();
                this.currentTab = key;
                this.getCurrentTab().onTabOpen();
                this.getCurrentTab().receiveMessage(extraData);
            }
        } else {
            LightmansCurrency.LogWarning("Trader Storage Menu doesn't have a tab defined for " + key);
        }
    }

    public void changeMode(TraderInterfaceBlockEntity.ActiveMode newMode) {
        this.traderInterface.setMode(newMode);
        if (this.isClient()) {
            class_2487 message = new class_2487();
            message.method_10569("ModeChange", newMode.index);
            this.sendMessage(message);
        }
    }

    public void setOnlineMode(boolean newMode) {
        this.traderInterface.setOnlineMode(newMode);
        if (this.isClient()) {
            class_2487 message = new class_2487();
            message.method_10556("OnlineModeChange", newMode);
            this.sendMessage(message);
        }
    }

    public class_2487 createTabChangeMessage(int newTab, @Nullable class_2487 extraData) {
        class_2487 message = extraData == null ? new class_2487() : extraData;
        message.method_10569("ChangeTab", newTab);
        return message;
    }

    public void sendMessage(class_2487 message) {
        if (this.isClient()) {
            new CMessageInterfaceInteraction(message).sendToServer();
        }
    }

    public void receiveMessage(class_2487 message) {
        if (message.method_10573("ChangeTab", 3)) {
            this.changeTab(message.method_10550("ChangeTab"), message);
        }
        if (message.method_10545("ModeChange")) {
            this.changeMode(TraderInterfaceBlockEntity.ActiveMode.fromIndex(message.method_10550("ModeChange")));
        }
        if (message.method_10545("OnlineModeChange")) {
            this.setOnlineMode(message.method_10577("OnlineModeChange"));
        }
        try {
            this.getCurrentTab().receiveMessage(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface IClientMessage {
        public void selfMessage(class_2487 var1);
    }
}

