/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TicketMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menu.slots.ticket.TicketMasterSlot;
import io.github.lightman314.lightmanscurrency.common.menu.slots.ticket.TicketMaterialSlot;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class TicketMachineMenu
extends Menu {
    private final class_1263 output = new class_1277(1);
    private final TicketMachineBlockEntity ticketMachine;

    public TicketMachineMenu(int windowId, class_1661 inventory, class_2338 blockPos) {
        super(ModMenus.TICKET_MACHINE, windowId);
        class_2586 blockEntity = inventory.field_7546.method_37908().method_8321(blockPos);
        if (!(blockEntity instanceof TicketMachineBlockEntity)) {
            this.ticketMachine = null;
            return;
        }
        this.ticketMachine = (TicketMachineBlockEntity)blockEntity;
        this.method_7621(new TicketMasterSlot(this.ticketMachine.getStorage(), 0, 20, 21));
        this.method_7621(new TicketMaterialSlot(this.ticketMachine.getStorage(), 1, 56, 21));
        this.method_7621(new OutputSlot(this.output, 0, 116, 21));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, 8 + x * 18, 56 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 8 + x * 18, 114));
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.ticketMachine != null && !this.ticketMachine.method_11015();
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        this.method_7607(playerIn, this.output);
    }

    public class_1799 method_7601(class_1657 playerEntity, int index) {
        class_1799 clickedStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            clickedStack = slotStack.method_7972();
            int totalSize = this.ticketMachine.getStorage().method_5439() + this.output.method_5439();
            if (index < totalSize ? !this.method_7616(slotStack, totalSize, this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.ticketMachine.getStorage().method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return clickedStack;
    }

    public boolean validInputs() {
        return !this.ticketMachine.getStorage().method_5438(1).method_7960();
    }

    public boolean roomForOutput() {
        class_1799 outputStack = this.output.method_5438(0);
        if (outputStack.method_7960()) {
            return true;
        }
        if (this.hasMasterTicket() && outputStack.method_7909() == ModItems.TICKET) {
            UUID ticketID = this.getTicketID();
            UUID outputTicketID = TicketItem.GetTicketID(outputStack);
            return outputTicketID != null && ticketID.equals(outputTicketID);
        }
        return false;
    }

    public boolean hasMasterTicket() {
        class_1799 masterTicket = this.ticketMachine.getStorage().method_5438(0);
        return !masterTicket.method_7960() && TicketItem.isMasterTicket(masterTicket);
    }

    public void craftTickets(boolean fullStack) {
        if (!this.validInputs()) {
            LightmansCurrency.LogWarning("Inputs for the Ticket Machine are not valid. Cannot craft tickets.");
            return;
        }
        if (!this.roomForOutput()) {
            LightmansCurrency.LogWarning("No room for Ticket Machine outputs. Cannot craft tickets.");
            return;
        }
        if (this.hasMasterTicket()) {
            class_1799 outputStack;
            int count = 1;
            if (fullStack) {
                count = this.ticketMachine.getStorage().method_5438(1).method_7947();
            }
            if ((outputStack = this.output.method_5438(0)).method_7960()) {
                class_1799 newTicket = TicketItem.CreateTicket(this.getTicketID(), count);
                this.output.method_5447(0, newTicket);
            } else {
                count = Math.min(count, outputStack.method_7914() - outputStack.method_7947());
                outputStack.method_7939(outputStack.method_7947() + count);
            }
            this.ticketMachine.getStorage().method_5434(1, count);
        } else {
            class_1799 newTicket = TicketItem.CreateMasterTicket(UUID.randomUUID());
            this.output.method_5447(0, newTicket);
            this.ticketMachine.getStorage().method_5434(1, 1);
        }
    }

    public UUID getTicketID() {
        class_1799 masterTicket = this.ticketMachine.getStorage().method_5438(0);
        if (TicketItem.isMasterTicket(masterTicket)) {
            return TicketItem.GetTicketID(masterTicket);
        }
        return null;
    }
}

