/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.client.messages.slot_machine.SMessageSlotMachine;
import io.github.lightman314.lightmanscurrency.network.server.messages.slot_machine.CMessageSlotMachine;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SlotMachineMenu
extends Menu {
    private final long traderID;
    public final class_1657 player;
    private final class_1263 coins;
    List<class_1735> coinSlots = new ArrayList<class_1735>();
    private final List<RewardCache> rewards = new ArrayList<RewardCache>();

    public boolean isClient() {
        return this.player.method_37908().field_9236;
    }

    public final SlotMachineTraderData getTrader() {
        TraderData traderData = TraderSaveData.GetTrader(this.isClient(), this.traderID);
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader;
        }
        return null;
    }

    public final boolean hasPendingReward() {
        return this.rewards.size() > 0;
    }

    public final RewardCache getNextReward() {
        if (this.rewards.size() == 0) {
            return null;
        }
        return this.rewards.get(0);
    }

    public final RewardCache getAndRemoveNextReward() {
        if (this.rewards.size() == 0) {
            return null;
        }
        return this.rewards.remove(0);
    }

    public SlotMachineMenu(int windowID, class_1661 inventory, long traderID) {
        super(ModMenus.SLOT_MACHINE, windowID);
        int x;
        this.player = inventory.field_7546;
        this.traderID = traderID;
        this.coins = new class_1277(5);
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.method_7621(new class_1735((class_1263)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 140 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 8 + x * 18, 198));
        }
        for (x = 0; x < this.coins.method_5439(); ++x) {
            this.coinSlots.add(this.method_7621(new CoinSlot(this.coins, x, 8 + (x + 4) * 18, 108)));
        }
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            trader.userOpen(this.player);
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 clickedStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            clickedStack = slotStack.method_7972();
            if (index < 36 ? !this.method_7616(slotStack, 36, this.field_7761.size(), false) : index < this.field_7761.size() && !this.method_7616(slotStack, 0, 36, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return clickedStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.getTrader() != null;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        for (RewardCache reward : this.rewards) {
            reward.giveToPlayer();
        }
        this.rewards.clear();
        this.method_7607(player, this.coins);
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            trader.userClose(this.player);
        }
    }

    public final void clearContainer(class_1263 container) {
        this.method_7607(this.player, container);
    }

    public final TradeContext getContext() {
        return this.getContext(null);
    }

    public final TradeContext getContext(RewardCache rewardHolder) {
        TradeContext.Builder builder = TradeContext.create((TraderData)this.getTrader(), this.player).withCoinSlots(this.coins);
        if (rewardHolder != null) {
            builder.withInventory(rewardHolder.itemHolder);
            builder.withStoredCoins(rewardHolder.money);
        }
        return builder.build();
    }

    public void CollectCoinStorage() {
        if (this.getTrader() != null) {
            SlotMachineTraderData trader = this.getTrader();
            if (trader.hasPermission(this.player, "collectCoins")) {
                CoinValue storedMoney = trader.getInternalStoredMoney();
                if (storedMoney.getRawValue() > 0L) {
                    TradeContext tempContext = this.getContext();
                    if (!tempContext.hasPaymentMethod()) {
                        return;
                    }
                    tempContext.givePayment(storedMoney);
                    trader.clearStoredMoney();
                }
            } else {
                Permissions.PermissionWarning(this.player, "collect stored coins", "collectCoins");
            }
        }
    }

    private void ExecuteTrades(int count) {
        LightmansCurrency.LogDebug("Attempting to execute " + count + " trade(s)");
        if (this.rewards.size() > 0) {
            LightmansCurrency.LogWarning("Attempted to execute trades while previous trades are still pending.");
            return;
        }
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            boolean flag = true;
            for (int i = 0; flag && i < count; ++i) {
                RewardCache holder = new RewardCache();
                TradeContext.TradeResult result = trader.ExecuteTrade(this.getContext(holder), 0);
                if (result.isSuccess()) {
                    if (holder.itemHolder.method_5442() && holder.money.getRawValue() <= 0L) {
                        LightmansCurrency.LogError("Successful Slot Machine Trade executed, but no items or money were received!");
                        continue;
                    }
                    this.rewards.add(holder);
                    LightmansCurrency.LogDebug("Successful Slot Machine Trade executed.");
                    continue;
                }
                LightmansCurrency.LogWarning("Failed to execute the trade on attempt #" + (i + 1) + ".\nReason: " + result.failMessage.getString());
                flag = false;
            }
            if (this.rewards.size() > 0) {
                class_2487 rewardData = new class_2487();
                class_2499 resultList = new class_2499();
                for (RewardCache result : this.rewards) {
                    resultList.add((Object)result.save());
                }
                rewardData.method_10566("Rewards", (class_2520)resultList);
                this.SendMessageToClient(LazyPacketData.builder().setCompound("SyncRewards", rewardData));
                LightmansCurrency.LogDebug("Trades complete, syncing rewards with the client!");
            }
        } else {
            LightmansCurrency.LogWarning("No trader found on the Slot Machine Menu");
        }
    }

    public boolean GiveNextReward() {
        RewardCache nextReward = this.getAndRemoveNextReward();
        if (nextReward != null) {
            nextReward.giveToPlayer();
            return true;
        }
        return false;
    }

    public void SendMessageToClient(LazyPacketData.Builder builder) {
        if (this.isClient()) {
            return;
        }
        new SMessageSlotMachine(builder.build()).sendTo(this.player);
    }

    public void SendMessageToServer(LazyPacketData.Builder builder) {
        if (!this.isClient()) {
            return;
        }
        new CMessageSlotMachine(builder.build()).sendToServer();
    }

    public void HandleMessage(LazyPacketData message) {
        if (message.contains("ExecuteTrade")) {
            if (this.rewards.size() > 0) {
                return;
            }
            this.ExecuteTrades(message.getInt("ExecuteTrade"));
        }
        if (message.contains("GiveNextReward")) {
            this.GiveNextReward();
        }
        if (message.contains("AnimationsCompleted")) {
            while (this.GiveNextReward()) {
            }
        }
        if (message.contains("SyncRewards") && this.isClient()) {
            this.rewards.clear();
            class_2487 rewardData = message.getCompound("SyncRewards");
            class_2499 rewardList = rewardData.method_10554("Rewards", 10);
            for (int i = 0; i < rewardList.size(); ++i) {
                this.rewards.add(this.loadReward(rewardList.method_10602(i)));
            }
        }
    }

    public final RewardCache loadReward(class_2487 tag) {
        CoinValue value = new CoinValue(new CoinValue.CoinValuePair[0]);
        value.load(tag, "Money");
        return new RewardCache((class_1263)InventoryUtil.loadAllItems("Items", tag, 4), value);
    }

    public final class RewardCache {
        public final class_1263 itemHolder;
        public CoinValue money = new CoinValue(new CoinValue.CoinValuePair[0]);

        public RewardCache() {
            this.itemHolder = new class_1277(4);
        }

        public RewardCache(class_1263 itemHolder, CoinValue money) {
            this.itemHolder = itemHolder;
            this.money = money;
        }

        public void giveToPlayer() {
            SlotMachineMenu.this.clearContainer(this.itemHolder);
            this.itemHolder.method_5448();
            MoneyUtil.ProcessChange(null, SlotMachineMenu.this.player, this.money);
            this.money = new CoinValue(new CoinValue.CoinValuePair[0]);
        }

        public List<class_1799> getDisplayItems() {
            if (this.money.getRawValue() > 0L) {
                return MoneyUtil.getCoinsOfValue(this.money.getRawValue());
            }
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (int i = 0; i < this.itemHolder.method_5439(); ++i) {
                class_1799 item = this.itemHolder.method_5438(i);
                if (item.method_7960()) continue;
                items.add(item.method_7972());
            }
            return items;
        }

        public class_2487 save() {
            class_2487 tag = new class_2487();
            InventoryUtil.saveAllItems("Items", tag, this.itemHolder);
            this.money.save(tag, "Money");
            return tag;
        }
    }
}

