/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.enchantments.CoinMagnetEnchantment;
import io.github.lightman314.lightmanscurrency.common.menu.factory.WalletMenuFactory;
import io.github.lightman314.lightmanscurrency.common.menu.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientWallet;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class WalletItem
extends class_1792 {
    private static final class_3414 emptyOpenSound = class_3417.field_14581;
    private final class_2960 MODEL_TEXTURE;
    private final int level;
    private final int storageSize;

    public WalletItem(int level, int storageSize, String modelName, class_1792.class_1793 properties) {
        super(properties.method_7889(1));
        this.level = level;
        this.storageSize = storageSize;
        WalletMenuBase.updateMaxWalletSlots(this.storageSize);
        this.MODEL_TEXTURE = new class_2960("lightmanscurrency", "textures/entity/" + modelName + ".png");
    }

    public static boolean isWallet(class_1799 item) {
        return WalletItem.isWallet(item.method_7909());
    }

    public static boolean isWallet(class_1792 item) {
        return item instanceof WalletItem;
    }

    public static boolean CanExchange(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletExchangeLevel.get() || wallet.level >= (Integer)LCConfig.SERVER.walletPickupLevel.get();
    }

    public static boolean CanPickup(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletPickupLevel.get();
    }

    public static boolean HasBankAccess(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletBankLevel.get();
    }

    public static int InventorySize(WalletItem wallet) {
        if (wallet == null) {
            return 0;
        }
        return wallet.storageSize;
    }

    public static int GetMagnetLevel(class_1799 stack) {
        class_2487 tag;
        WalletItem wallet;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof WalletItem && WalletItem.CanPickup(wallet = (WalletItem)class_17922) && (tag = stack.method_7969()) != null && tag.method_10573("CoinMagnet", 3)) {
            return tag.method_10550("CoinMagnet");
        }
        return 0;
    }

    public static void SetMagnetLevel(class_1799 stack, int level) {
        if (stack.method_7909() instanceof WalletItem) {
            class_2487 tag = stack.method_7948();
            tag.method_10569("CoinMagnet", level);
        }
    }

    public static int InventorySize(class_1799 wallet) {
        class_1792 class_17922 = wallet.method_7909();
        if (class_17922 instanceof WalletItem) {
            WalletItem w = (WalletItem)class_17922;
            return WalletItem.InventorySize(w);
        }
        return 0;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flagIn) {
        CoinValue contents;
        int magnetLevel = WalletItem.GetMagnetLevel(stack);
        if (magnetLevel > 0) {
            tooltip.add((class_2561)EasyText.translatable("enchantment.lightmanscurrency.coin_magnet", new Object[0]).method_27692(class_124.field_1080).method_10852((class_2561)class_5244.method_48320()).method_10852((class_2561)EasyText.translatable("enchantment.level." + magnetLevel, new Object[0])));
        }
        super.method_7851(stack, level, tooltip, flagIn);
        if (WalletItem.CanPickup(this)) {
            tooltip.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.wallet.pickup", new Object[0]).method_27692(class_124.field_1054));
            if (magnetLevel < 3) {
                tooltip.add((class_2561)EasyText.translatable("enchantment.lightmanscurrency.coin_magnet.crafting", new Object[0]).method_27692(class_124.field_1080));
            }
        }
        if (WalletItem.CanExchange(this)) {
            if (WalletItem.CanPickup(this)) {
                class_5250 onOffText = WalletItem.getAutoConvert(stack) ? EasyText.translatable("tooltip.lightmanscurrency.wallet.autoConvert.on", new Object[0]).method_27692(class_124.field_1060) : EasyText.translatable("tooltip.lightmanscurrency.wallet.autoConvert.off", new Object[0]).method_27692(class_124.field_1061);
                tooltip.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.wallet.autoConvert", onOffText).method_27692(class_124.field_1054));
            } else {
                tooltip.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.wallet.manualConvert", new Object[0]).method_27692(class_124.field_1054));
            }
        }
        if (WalletItem.HasBankAccess(this)) {
            tooltip.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.wallet.bankaccount", new Object[0]).method_27692(class_124.field_1054));
        }
        if (magnetLevel > 0) {
            tooltip.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.wallet.pickup.magnet", CoinMagnetEnchantment.getCollectionRangeDisplay(magnetLevel)).method_27692(class_124.field_1054));
        }
        if ((contents = new CoinValue(WalletItem.getWalletInventory(stack))).getRawValue() > 0L) {
            tooltip.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.wallet.storedmoney", EasyText.literal(contents.getString()).method_27692(class_124.field_1077)).method_27692(class_124.field_1054));
        }
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || WalletItem.GetMagnetLevel(stack) > 0;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 wallet = player.method_5998(hand);
        if (!world.field_9236) {
            int walletSlot = WalletItem.GetWalletSlot((class_1263)player.method_31548(), wallet);
            if (walletSlot >= 0) {
                if (player.method_5715()) {
                    AtomicBoolean equippedWallet = new AtomicBoolean(false);
                    WalletHandler walletHandler = WalletHandler.getWallet(player);
                    if (walletHandler.getWallet().method_7960()) {
                        walletHandler.setWallet(wallet);
                        player.method_6122(hand, class_1799.field_8037);
                        new SMessageUpdateClientWallet(player.method_5667(), walletHandler).sendToAll();
                        walletHandler.clean();
                        equippedWallet.set(true);
                    }
                    if (equippedWallet.get()) {
                        walletSlot = -1;
                    }
                }
                player.method_17355((class_3908)new WalletMenuFactory(walletSlot));
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.method_37908().method_8396(player, player.method_24515(), emptyOpenSound, class_3419.field_15248, 0.75f, 1.25f + player.method_37908().field_9229.method_43057() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.method_37908().method_8396(player, player.method_24515(), ModSounds.COINS_CLINKING, class_3419.field_15248, 0.4f, 1.0f);
            }
        }
        return class_1271.method_22427((Object)wallet);
    }

    public static boolean isEmpty(class_1799 wallet) {
        class_2371<class_1799> inventory = WalletItem.getWalletInventory(wallet);
        for (class_1799 stack : inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private static int GetWalletSlot(class_1263 inventory, class_1799 wallet) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static class_1799 PickupCoin(class_1799 wallet, class_1799 coins) {
        class_1799 returnValue = coins.method_7972();
        class_2371<class_1799> inventory = WalletItem.getWalletInventory(wallet);
        for (int i = 0; i < inventory.size() && !returnValue.method_7960(); ++i) {
            class_1799 thisStack = (class_1799)inventory.get(i);
            if (thisStack.method_7960()) {
                inventory.set(i, (Object)returnValue.method_7972());
                returnValue = class_1799.field_8037;
                continue;
            }
            if (thisStack.method_7909() != returnValue.method_7909()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.method_7947(), 0, thisStack.method_7914() - thisStack.method_7947());
            thisStack.method_7939(thisStack.method_7947() + amountToAdd);
            returnValue.method_7939(returnValue.method_7947() - amountToAdd);
        }
        inventory = WalletItem.getAutoConvert(wallet) ? WalletItem.ConvertCoins(inventory) : MoneyUtil.SortCoins(inventory);
        WalletItem.putWalletInventory(wallet, inventory);
        return returnValue;
    }

    private static class_2371<class_1799> ConvertCoins(class_2371<class_1799> inventory) {
        inventory = MoneyUtil.ConvertAllCoinsUp(inventory);
        return MoneyUtil.SortCoins(inventory);
    }

    public static void putWalletInventory(class_1799 wallet, class_2371<class_1799> inventory) {
        if (!(wallet.method_7909() instanceof WalletItem)) {
            return;
        }
        class_2487 compound = wallet.method_7948();
        class_2499 invList = new class_2499();
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 thisStack = (class_1799)inventory.get(i);
            if (thisStack.method_7960()) continue;
            class_2487 thisItemCompound = thisStack.method_7953(new class_2487());
            thisItemCompound.method_10567("Slot", (byte)i);
            invList.add((Object)thisItemCompound);
        }
        compound.method_10566("Items", (class_2520)invList);
        wallet.method_7980(compound);
    }

    public static class_2371<class_1799> getWalletInventory(class_1799 wallet) {
        class_2487 compound = wallet.method_7948();
        if (!(wallet.method_7909() instanceof WalletItem)) {
            return class_2371.method_10213((int)6, (Object)class_1799.field_8037);
        }
        class_2371 value = class_2371.method_10213((int)WalletItem.InventorySize((WalletItem)wallet.method_7909()), (Object)class_1799.field_8037);
        if (!compound.method_10545("Items")) {
            return value;
        }
        class_2499 invList = compound.method_10554("Items", 10);
        for (int i = 0; i < invList.size(); ++i) {
            class_2487 thisCompound = invList.method_10602(i);
            class_1799 thisStack = class_1799.method_7915((class_2487)thisCompound);
            int j = thisCompound.method_10571("Slot") & 0xFF;
            if (j >= value.size()) continue;
            value.set(j, (Object)thisStack);
        }
        return value;
    }

    public static boolean getAutoConvert(class_1799 wallet) {
        if (!(wallet.method_7909() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.method_7909()) || !WalletItem.CanPickup((WalletItem)wallet.method_7909())) {
            return false;
        }
        class_2487 tag = wallet.method_7948();
        if (!tag.method_10545("AutoConvert")) {
            tag.method_10556("AutoConvert", true);
            return true;
        }
        return tag.method_10577("AutoConvert");
    }

    public static void toggleAutoConvert(class_1799 wallet) {
        if (!(wallet.method_7909() instanceof WalletItem)) {
            return;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.method_7909())) {
            return;
        }
        class_2487 tag = wallet.method_7948();
        boolean oldValue = WalletItem.getAutoConvert(wallet);
        tag.method_10556("AutoConvert", !oldValue);
    }

    public static void QuickCollect(class_1657 player, class_1263 container, boolean allowHidden) {
        class_1799 wallet = WalletHandler.getWallet(player).getWallet();
        if (WalletItem.isWallet(wallet)) {
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 stack = container.method_5438(i);
                if (!MoneyUtil.isCoin(stack, allowHidden)) continue;
                stack = WalletItem.PickupCoin(wallet, stack);
                container.method_5447(i, stack);
            }
        }
    }

    public static void CopyWalletContents(class_1799 walletIn, class_1799 walletOut) {
        if (!(walletIn.method_7909() instanceof WalletItem) || !(walletOut.method_7909() instanceof WalletItem)) {
            LightmansCurrency.LogError("WalletItem.CopyWalletContents() -> One or both of the wallet stacks are not WalletItems.");
            return;
        }
        walletOut.method_7980(walletIn.method_7969());
    }

    public class_2960 getModelTexture() {
        return this.MODEL_TEXTURE;
    }
}

