/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class UpgradeItem
extends class_1792
implements UpgradeType.IUpgradeItem {
    protected final UpgradeType upgradeType;
    private boolean addTooltips = true;
    Function<UpgradeType.UpgradeData, List<class_2561>> customTooltips = null;

    public UpgradeItem(UpgradeType upgradeType, class_1792.class_1793 properties) {
        super(properties);
        this.upgradeType = upgradeType;
    }

    public final boolean addsTooltips() {
        return this.addTooltips;
    }

    protected final void ignoreTooltips() {
        this.addTooltips = false;
    }

    protected final void setCustomTooltips(Function<UpgradeType.UpgradeData, List<class_2561>> customTooltips) {
        this.customTooltips = customTooltips;
    }

    @Override
    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    @Override
    public UpgradeType.UpgradeData getDefaultUpgradeData() {
        UpgradeType.UpgradeData data = this.upgradeType.getDefaultData();
        this.fillUpgradeData(data);
        return data;
    }

    protected abstract void fillUpgradeData(UpgradeType.UpgradeData var1);

    public static UpgradeType.UpgradeData getUpgradeData(class_1799 stack) {
        if (stack.method_7909() instanceof UpgradeItem) {
            class_2487 tag;
            UpgradeType.UpgradeData data = ((UpgradeItem)stack.method_7909()).getDefaultUpgradeData();
            if (stack.method_7985() && (tag = stack.method_7969()).method_10573("UpgradeData", 10)) {
                data.read(tag.method_10562("UpgradeData"));
            }
            return data;
        }
        return null;
    }

    public static void setUpgradeData(class_1799 stack, UpgradeType.UpgradeData data) {
        if (stack.method_7909() instanceof UpgradeItem) {
            UpgradeType source = ((UpgradeItem)stack.method_7909()).upgradeType;
            class_2487 tag = stack.method_7948();
            tag.method_10566("UpgradeData", (class_2520)data.writeToNBT(source));
        } else {
            class_2487 tag = stack.method_7948();
            tag.method_10566("UpgradeData", (class_2520)data.writeToNBT());
        }
    }

    public static List<class_2561> getUpgradeTooltip(class_1799 stack) {
        return UpgradeItem.getUpgradeTooltip(stack, false);
    }

    public static List<class_2561> getUpgradeTooltip(class_1799 stack, boolean forceCollection) {
        if (stack.method_7909() instanceof UpgradeItem) {
            UpgradeItem item = (UpgradeItem)stack.method_7909();
            if (!item.addTooltips && !forceCollection) {
                return Lists.newArrayList();
            }
            UpgradeType type = item.getUpgradeType();
            UpgradeType.UpgradeData data = UpgradeItem.getUpgradeData(stack);
            if (item.customTooltips != null) {
                return (List)item.customTooltips.apply((Object)data);
            }
            return type.getTooltip(data);
        }
        return Lists.newArrayList();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flagIn) {
        List<class_2561> upgradeTooltips = UpgradeItem.getUpgradeTooltip(stack);
        if (upgradeTooltips != null) {
            upgradeTooltips.forEach(upgradeTooltip -> tooltip.add((class_2561)upgradeTooltip));
        }
        super.method_7851(stack, level, tooltip, flagIn);
    }

    public static class Simple
    extends UpgradeItem {
        public Simple(UpgradeType upgradeType, class_1792.class_1793 properties) {
            super(upgradeType, properties);
        }

        @Override
        protected void fillUpgradeData(UpgradeType.UpgradeData data) {
        }
    }
}

