/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class WalletMagnetUpgradeRecipe
extends class_1852 {
    public static final class_2960 TAG_UPGRADE_ITEM = new class_2960("lightmanscurrency", "coin_magnet_upgrade_item");

    public WalletMagnetUpgradeRecipe(class_2960 id, class_7710 category) {
        super(id, category);
    }

    public boolean matches(class_8566 inventory, class_1937 world) {
        Optional<class_1799> optional = this.findWallet(inventory);
        if (optional.isEmpty()) {
            return false;
        }
        class_1799 walletStack = optional.get();
        int currentLevel = WalletItem.GetMagnetLevel(walletStack);
        int pearlCount = this.upgradeItemCount(inventory);
        return pearlCount > 0 && currentLevel + pearlCount <= 3;
    }

    public class_1799 craft(class_8566 inventory, class_5455 registryManager) {
        Optional<class_1799> optional = this.findWallet(inventory);
        if (optional.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 walletCopy = optional.get().method_7972();
        walletCopy.method_7939(1);
        int oldLevel = WalletItem.GetMagnetLevel(walletCopy);
        int pearlCount = this.upgradeItemCount(inventory);
        WalletItem.SetMagnetLevel(walletCopy, oldLevel + pearlCount);
        return walletCopy;
    }

    private Optional<class_1799> findWallet(class_8566 inventory) {
        Optional<class_1799> result = Optional.empty();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof WalletItem)) continue;
            WalletItem wallet = (WalletItem)class_17922;
            if (WalletItem.CanPickup(wallet)) {
                if (result.isPresent()) {
                    return Optional.empty();
                }
                result = Optional.of(stack);
                continue;
            }
            return Optional.empty();
        }
        return result;
    }

    private int upgradeItemCount(class_8566 inventory) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (InventoryUtil.ItemHasTag(stack, TAG_UPGRADE_ITEM)) {
                ++count;
                continue;
            }
            if (stack.method_7960() || WalletItem.isWallet(stack)) continue;
            return 0;
        }
        return count;
    }

    public boolean method_8113(int width, int height) {
        return width * height > 2;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.WALLET_MAGNET_UPGRADE;
    }
}

