/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class CoinMintRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final MintType type;
    private final int duration;
    private final class_1856 ingredient;
    public final int ingredientCount;
    private final class_1799 result;

    public static MintType readType(JsonElement json) {
        try {
            return CoinMintRecipe.readType(json.getAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return MintType.OTHER;
        }
    }

    public static MintType readType(String typeName) {
        for (MintType type : MintType.values()) {
            if (!type.name().equals(typeName)) continue;
            return type;
        }
        return MintType.OTHER;
    }

    public CoinMintRecipe(class_2960 id, MintType type, int duration, class_1856 ingredient, int ingredientCount, class_1799 result) {
        this.id = id;
        this.type = type;
        this.duration = duration;
        this.ingredient = ingredient;
        this.ingredientCount = Math.max(ingredientCount, 1);
        this.result = result;
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public class_2371<class_1856> method_8117() {
        return class_2371.method_10213((int)1, (Object)this.ingredient);
    }

    public MintType getMintType() {
        return this.type;
    }

    public boolean allowed() {
        return LCConfig.SERVER.allowCoinMintRecipe(this);
    }

    public boolean shouldShowInREI() {
        return !this.ingredient.method_8103() && this.result.method_7909() != class_1802.field_8162;
    }

    public boolean isValid() {
        return !this.ingredient.method_8103() && this.result.method_7909() != class_1802.field_8162 && this.allowed();
    }

    public boolean method_8115(class_1263 inventory, class_1937 level) {
        if (!this.isValid()) {
            return false;
        }
        class_1799 firstStack = inventory.method_5438(0);
        return this.ingredient.method_8093(firstStack);
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 manager) {
        return this.method_8110(manager);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 getOutputItem() {
        return this.result.method_7972();
    }

    public class_1799 method_8110(class_5455 manager) {
        if (this.isValid()) {
            return this.result.method_7972();
        }
        return class_1799.field_8037;
    }

    public int getInternalDuration() {
        return this.duration;
    }

    public int getDuration() {
        return this.duration > 0 ? this.duration : (Integer)LCConfig.SERVER.coinMintDefaultDuration.get();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.COIN_MINT_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.COIN_MINT_TYPE;
    }

    public static enum MintType {
        MINT,
        MELT,
        OTHER;

    }

    public static class Serializer
    implements class_1865<CoinMintRecipe> {
        public CoinMintRecipe read(class_2960 id, JsonObject json) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)json.get("ingredient"));
            int ingredientCount = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            if (result.method_7960()) {
                throw new JsonSyntaxException("Result is empty.");
            }
            MintType type = MintType.OTHER;
            if (json.has("mintType")) {
                type = CoinMintRecipe.readType(class_3518.method_15253((JsonObject)json, (String)"mintType", (String)"OTHER"));
            }
            int duration = class_3518.method_15282((JsonObject)json, (String)"duration", (int)0);
            return new CoinMintRecipe(id, type, duration, ingredient, ingredientCount, result);
        }

        public CoinMintRecipe read(class_2960 id, class_2540 buffer) {
            MintType type = CoinMintRecipe.readType(buffer.method_19772());
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            int ingredientCount = buffer.readInt();
            class_1799 result = buffer.method_10819();
            int duration = buffer.readInt();
            return new CoinMintRecipe(id, type, duration, ingredient, ingredientCount, result);
        }

        public void write(class_2540 buffer, CoinMintRecipe recipe) {
            buffer.method_10814(recipe.getMintType().name());
            recipe.getIngredient().method_8088(buffer);
            buffer.writeInt(recipe.ingredientCount);
            buffer.method_10793(recipe.getOutputItem());
            buffer.writeInt(recipe.getInternalDuration());
        }
    }
}

