/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.Reference;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModProfessions;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1830;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7045;
import net.minecraft.class_7923;

public class VillagerTradeManager {
    private static final float ENCHANTMENT_PRICE_MODIFIER = 0.25f;

    public static List<class_3853.class_1652> getGenericWandererTrades() {
        return ImmutableList.of((Object)new LazyTrade((class_1935)ModItems.COIN_GOLD, 1, ModBlocks.MACHINE_ATM), (Object)new LazyTrade((class_1935)ModItems.COIN_IRON, 5, ModBlocks.CASH_REGISTER), (Object)new LazyTrade((class_1935)ModItems.COIN_IRON, 5, ModBlocks.TERMINAL));
    }

    public static List<class_3853.class_1652> getRareWandererTrades() {
        return ImmutableList.of((Object)new LazyTrade((class_1935)ModItems.COIN_GOLD, 2, (class_1935)ModItems.COIN_IRON, 4, ModBlocks.DISPLAY_CASE), (Object)new LazyTrade((class_1935)ModItems.COIN_GOLD, 4, ModBlocks.ARMOR_DISPLAY));
    }

    public static Map<Integer, List<class_3853.class_1652>> getBankerTrades() {
        return ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new LazyTrade(2, (class_1935)ModItems.COIN_IRON, 5, ModBlocks.MACHINE_MINT), (Object)new LazyTrade(2, (class_1935)ModItems.COIN_GOLD, 1, ModBlocks.MACHINE_ATM), (Object)new LazyTrade(1, (class_1935)ModItems.COIN_IRON, 5, ModBlocks.CASH_REGISTER), (Object)new LazyTrade(1, (class_1935)ModItems.COIN_IRON, 4, (class_1935)ModItems.COIN_COPPER, 8, (class_1935)ModItems.TRADING_CORE)), (Object)2, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1935[]{(class_1935)ModBlocks.SHELF.get(Reference.WoodType.OAK), (class_1935)ModBlocks.SHELF.get(Reference.WoodType.BIRCH), (class_1935)ModBlocks.SHELF.get(Reference.WoodType.SPRUCE), (class_1935)ModBlocks.SHELF.get(Reference.WoodType.JUNGLE)}, 12, 5, 0.05f), (Object)new RandomItemForItemTrade(new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1935[]{(class_1935)ModBlocks.SHELF.get(Reference.WoodType.ACACIA), (class_1935)ModBlocks.SHELF.get(Reference.WoodType.DARK_OAK), (class_1935)ModBlocks.SHELF.get(Reference.WoodType.CRIMSON), (class_1935)ModBlocks.SHELF.get(Reference.WoodType.WARPED)}, 12, 5, 0.05f), (Object)new LazyTrade(5, (class_1935)ModItems.COIN_IRON, 10, ModBlocks.DISPLAY_CASE)), (Object)3, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new class_1799((class_1935)ModItems.COIN_IRON, 15), new class_1935[]{(class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.OAK), (class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.BIRCH), (class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.SPRUCE), (class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.JUNGLE)}, 12, 10, 0.05f), (Object)new RandomItemForItemTrade(new class_1799((class_1935)ModItems.COIN_IRON, 15), new class_1935[]{(class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.ACACIA), (class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.DARK_OAK), (class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.CRIMSON), (class_1935)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.WARPED)}, 12, 10, 0.05f), (Object)new LazyTrade(10, (class_1935)ModItems.COIN_IRON, 20, ModBlocks.ARMOR_DISPLAY), (Object)new LazyTrade(10, (class_1935)ModItems.COIN_IRON, 15, ModBlocks.ITEM_NETWORK_TRADER_1), (Object)new LazyTrade(10, (class_1935)ModItems.COIN_IRON, 10, ModBlocks.TERMINAL)), (Object)4, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new class_1799((class_1935)ModItems.COIN_IRON, 25), new ArrayList(ModBlocks.VENDING_MACHINE.getAll()), 12, 15, 0.05f), (Object)new LazyTrade(15, (class_1935)ModItems.COIN_IRON, 30, ModBlocks.ITEM_NETWORK_TRADER_2), (Object)new LazyTrade(20, (class_1935)ModItems.COIN_IRON, 30, ModBlocks.FREEZER), (Object)new LazyTrade(20, (class_1935)ModItems.COIN_DIAMOND, 15, class_1772.method_7808((class_1889)new class_1889((class_1887)ModEnchantments.MONEY_MENDING, 1)))), (Object)5, (Object)ImmutableList.of((Object)new RandomItemForItemTrade(new class_1799((class_1935)ModItems.COIN_IRON, 25), new ArrayList(ModBlocks.VENDING_MACHINE_LARGE.getAll()), 12, 30, 0.05f), (Object)new LazyTrade(30, (class_1935)ModItems.COIN_GOLD, 6, ModBlocks.ITEM_NETWORK_TRADER_3), (Object)new LazyTrade(30, (class_1935)ModItems.COIN_GOLD, 10, ModBlocks.ITEM_NETWORK_TRADER_4), (Object)new LazyTrade(30, (class_1935)ModItems.COIN_DIAMOND, 10, class_1772.method_7808((class_1889)new class_1889((class_1887)ModEnchantments.MONEY_MENDING, 1)))));
    }

    public static Map<Integer, List<class_3853.class_1652>> getCashierTrades() {
        return ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 4), new class_1799((class_1935)ModItems.COIN_COPPER, 5), new class_1799((class_1935)class_1802.field_8229, 6), 16, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 7), new class_1799((class_1935)class_1802.field_8666), 16, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 4), new class_1799((class_1935)class_1802.field_8868), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 8), new class_1799((class_1935)class_1802.field_8107, 16), 12, 1, 0.05f), (Object)new EnchantedBookForCoinsTrade(1), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 2), new class_1799((class_1935)class_2246.field_10504), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD), new class_1799((class_1935)ModItems.COIN_IRON, 5), new class_1799((class_1935)class_1802.field_8895), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON), new class_1799((class_1935)class_1802.field_8725), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1799((class_1935)class_1802.field_8396), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)class_1802.field_8660), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)ModItems.COIN_IRON, 3), new class_1799((class_1935)class_1802.field_8743), 12, 1, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 2), new class_1799((class_1935)class_1802.field_8523), 12, 1, 0.05f), (Object[])new class_3853.class_1652[]{new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1799((class_1935)class_1802.field_8475), 12, 1, 0.05f), new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 3, (class_1935)class_1802.field_8371, 12, 1, 0.05f, 0.25), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON), new class_1799((class_1935)class_1802.field_8062), 12, 1, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON), new class_1799((class_1935)class_1802.field_8776), 12, 1, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON), new class_1799((class_1935)class_1802.field_8387), 12, 1, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON), new class_1799((class_1935)class_1802.field_8431), 12, 1, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_1802.field_8308), 12, 1, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_1802.field_8621, 10), 16, 1, 0.05f)}), (Object)2, (Object)ImmutableList.of((Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)class_1802.field_8741, 4), 12, 5, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1799((class_1935)class_1802.field_8279, 4), 16, 5, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 3), new class_1799((class_1935)class_1802.field_8429, 15), 16, 10, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_17350), 12, 5, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10446), 16, 5, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 4), new class_1799((class_1935)class_1802.field_8102), 12, 5, 0.05f), (Object)new EnchantedBookForCoinsTrade(5), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_16541), 12, 5, 0.05f), (Object)new ItemsForMapTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 3), (class_6862<class_3195>)class_7045.field_37043, "filled_map.monument", class_20.class_21.field_98, 12, 5), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_1802.field_8759), 12, 5, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 4), new class_1799((class_1935)class_2246.field_16332), 12, 5, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 9), new class_1799((class_1935)ModItems.COIN_COPPER, 5), new class_1799((class_1935)class_1802.field_8218), 12, 5, 0.05f), (Object[])new class_3853.class_1652[]{new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1799((class_1935)ModItems.COIN_COPPER, 3), new class_1799((class_1935)class_1802.field_8313), 12, 5, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 3), new class_1799((class_1935)class_1802.field_8389, 6), 16, 5, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 3), new class_1799((class_1935)class_1802.field_8544, 8), 16, 5, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10552, 4), 16, 5, 0.05f)}), (Object)3, (Object)ImmutableList.of((Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)class_1802.field_8423, 18), 18, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 2, (class_1935)class_1802.field_8378, 3, 10, 0.05f, 0.25), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 7), new class_1799((class_1935)class_1802.field_8399), 12, 10, 0.05f), (Object)new EnchantedBookForCoinsTrade(10), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 3), new class_1799((class_1935)class_2246.field_10033, 4), 12, 10, 0.05f), (Object)new ItemsForMapTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 4), (class_6862<class_3195>)class_7045.field_37042, "filled_map.mansion", class_20.class_21.field_88, 12, 10), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD), new class_1799((class_1935)class_2246.field_10171), 12, 10, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 7), new class_1799((class_1935)ModItems.COIN_COPPER, 4), new class_1799((class_1935)class_1802.field_8283), 12, 10, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 10), new class_1799((class_1935)ModItems.COIN_COPPER, 5), new class_1799((class_1935)class_1802.field_8873), 12, 10, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 6), new class_1799((class_1935)class_1802.field_8255), 12, 10, 0.05f), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 5, (class_1935)class_1802.field_8475, 3, 12, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 4, (class_1935)class_1802.field_8699, 3, 12, 0.05f, 0.25), (Object[])new class_3853.class_1652[]{new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 6, (class_1935)class_1802.field_8403, 3, 12, 0.05f, 0.25), new LazyTrade(new class_1799((class_1935)ModItems.COIN_DIAMOND, 2), new class_1799((class_1935)ModItems.COIN_IRON, 1), new class_1799((class_1935)class_1802.field_8527), 3, 10, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10093, 4), 16, 10, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10346, 4), 16, 10, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10289, 4), 16, 10, 0.05f)}), (Object)4, (Object)ImmutableList.of((Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 2), new class_1799((class_1935)class_2246.field_10183), 12, 15, 0.05f), (Object)new SuspiciousStewForItemTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), class_1294.field_5925, 100, 15), (Object)new SuspiciousStewForItemTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), class_1294.field_5913, 160, 15), (Object)new SuspiciousStewForItemTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), class_1294.field_5911, 100, 15), (Object)new SuspiciousStewForItemTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), class_1294.field_5919, 120, 15), (Object)new SuspiciousStewForItemTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), class_1294.field_5899, 100, 15), (Object)new SuspiciousStewForItemTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), class_1294.field_5922, 7, 15), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 5, (class_1935)class_1802.field_8102, 3, 15, 0.05f, 0.25), (Object)new EnchantedBookForCoinsTrade(15), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 5), new class_1799((class_1935)class_1802.field_8557), 12, 15, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 2), new class_1799((class_1935)class_1802.field_8251), 12, 15, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD), new class_1799((class_1935)class_1802.field_8143), 12, 15, 0.05f), (Object[])new class_3853.class_1652[]{new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD), new class_1799((class_1935)class_1802.field_8634), 12, 15, 0.05f), new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 7, (class_1935)class_1802.field_8348, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 5, (class_1935)class_1802.field_8285, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 4, (class_1935)class_1802.field_8556, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 3, (class_1935)class_1802.field_8556, 3, 15, 0.05f, 0.25), new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 2, (class_1935)class_1802.field_8250, 3, 15, 0.05f, 0.25), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10415, 1), 16, 15, 0.05f)}), (Object)5, (Object)ImmutableList.of((Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 15), new class_1799((class_1935)class_1802.field_8071), 12, 30, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 2), new class_1799((class_1935)class_1802.field_8597), 12, 30, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 5), new class_1799((class_1935)class_1802.field_8892), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_IRON, 10, (class_1935)class_1802.field_8399, 3, 15, 0.05f, 0.25), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)class_1802.field_8448), 12, 30, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)class_1802.field_18674), 12, 30, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_EMERALD, 1), new class_1799((class_1935)class_2246.field_9974, 12), 12, 30, 0.05f), (Object)new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 5), new class_1799((class_1935)class_1802.field_8287), 12, 30, 0.05f), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 8, (class_1935)class_1802.field_8058, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 6, (class_1935)class_1802.field_8805, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 4, (class_1935)class_1802.field_8802, 3, 30, 0.05f, 0.25), (Object)new EnchantedItemForCoinsTrade((class_1935)ModItems.COIN_DIAMOND, 4, (class_1935)class_1802.field_8377, 3, 30, 0.05f, 0.25), (Object[])new class_3853.class_1652[]{new LazyTrade(new class_1799((class_1935)ModItems.COIN_GOLD, 1), new class_1799((class_1935)class_1802.field_8175), 12, 30, 0.05f), new LazyTrade(new class_1799((class_1935)ModItems.COIN_IRON, 2), new class_1799((class_1935)class_2246.field_10153), 12, 30, 0.05f)}));
    }

    public static void registerVillagerTrades() {
        TradeOfferHelper.registerWanderingTraderOffers((int)1, VillagerTradeManager::modifyGenericWandererTrades);
        TradeOfferHelper.registerWanderingTraderOffers((int)2, VillagerTradeManager::modifyRareWandererTrades);
        for (int i = 1; i <= 5; ++i) {
            int level = i;
            TradeOfferHelper.registerVillagerOffers((class_3852)ModProfessions.BANKER, (int)i, l -> VillagerTradeManager.addBankerTrades(level, l));
            TradeOfferHelper.registerVillagerOffers((class_3852)ModProfessions.CASHIER, (int)i, l -> VillagerTradeManager.addCashierTrades(level, l));
        }
    }

    private static void modifyGenericWandererTrades(List<class_3853.class_1652> existingOffers) {
        if (((Boolean)LCConfig.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            existingOffers.addAll(VillagerTradeManager.getGenericWandererTrades());
        }
    }

    private static void modifyRareWandererTrades(List<class_3853.class_1652> existingOffers) {
        if (((Boolean)LCConfig.COMMON.addCustomWanderingTrades.get()).booleanValue()) {
            existingOffers.addAll(VillagerTradeManager.getRareWandererTrades());
        }
    }

    private static void addBankerTrades(int level, List<class_3853.class_1652> existingOffers) {
        existingOffers.addAll((Collection<class_3853.class_1652>)VillagerTradeManager.getBankerTrades().get(level));
    }

    private static void addCashierTrades(int level, List<class_3853.class_1652> existingOffers) {
        existingOffers.addAll((Collection<class_3853.class_1652>)VillagerTradeManager.getCashierTrades().get(level));
    }

    public static class LazyTrade
    implements class_3853.class_1652 {
        private static final int MAX_COUNT = 12;
        private static final float PRICE_MULT = 0.05f;
        private final int xp;
        private final int maxCount;
        private final float priceMult;
        private final class_1799 priceItem1;
        private final class_1799 priceItem2;
        private final class_1799 sellItem;

        public LazyTrade(class_1935 priceItem, int priceCount, class_1935 forsaleItem) {
            this(1, priceItem, priceCount, forsaleItem);
        }

        public LazyTrade(class_1935 priceItem, int priceCount, class_1935 forsaleItem, int forsaleCount) {
            this(1, priceItem, priceCount, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, class_1935 priceItem, int priceCount, class_1935 forsaleItem) {
            this(xpValue, priceItem, priceCount, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, class_1935 priceItem, int priceCount, class_1935 forsaleItem, int forsaleCount) {
            this(new class_1799(priceItem, priceCount), class_1799.field_8037, new class_1799(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public LazyTrade(class_1935 priceItem1, int priceCount1, class_1935 priceItem2, int priceCount2, class_1935 forsaleItem) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem);
        }

        public LazyTrade(class_1935 priceItem1, int priceCount1, class_1935 priceItem2, int priceCount2, class_1935 forsaleItem, int forsaleCount) {
            this(1, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, forsaleCount);
        }

        public LazyTrade(int xpValue, class_1935 priceItem1, int priceCount1, class_1935 priceItem2, int priceCount2, class_1935 forsaleItem) {
            this(xpValue, priceItem1, priceCount1, priceItem2, priceCount2, forsaleItem, 1);
        }

        public LazyTrade(int xpValue, class_1935 priceItem1, int priceCount1, class_1935 priceItem2, int priceCount2, class_1935 forsaleItem, int forsaleCount) {
            this(new class_1799(priceItem1, priceCount1), new class_1799(priceItem2, priceCount2), new class_1799(forsaleItem, forsaleCount), 12, xpValue, 0.05f);
        }

        public LazyTrade(int xpValue, class_1935 priceItem1, int priceCount1, class_1799 forSaleItem) {
            this(new class_1799(priceItem1, priceCount1), class_1799.field_8037, forSaleItem, 12, xpValue, 0.05f);
        }

        public LazyTrade(int xpValue, class_1935 priceItem1, int priceCount1, class_1935 priceItem2, int priceCount2, class_1799 forSaleItem) {
            this(new class_1799(priceItem1, priceCount1), new class_1799(priceItem2, priceCount2), forSaleItem, 12, xpValue, 0.05f);
        }

        public LazyTrade(class_1799 priceItem, class_1799 sellItem, int maxCount, int xp, float priceMult) {
            this(priceItem, class_1799.field_8037, sellItem, maxCount, xp, priceMult);
        }

        public LazyTrade(class_1799 priceItem1, class_1799 priceItem2, class_1799 sellItem, int maxCount, int xp, float priceMult) {
            this.priceItem1 = priceItem1;
            this.priceItem2 = priceItem2;
            this.sellItem = sellItem;
            this.xp = xp;
            this.maxCount = maxCount;
            this.priceMult = priceMult;
        }

        public class_1914 method_7246(class_1297 entity, class_5819 random) {
            return new class_1914(this.priceItem1, this.priceItem2, this.sellItem, this.maxCount, this.xp, this.priceMult);
        }
    }

    public static class RandomItemForItemTrade
    implements class_3853.class_1652 {
        private final class_1799 price1;
        private final class_1799 price2;
        private final List<? extends class_1935> sellItemOptions;
        private final int maxTrades;
        private final int xpValue;
        private final float priceMult;

        public RandomItemForItemTrade(class_1799 price, class_1935[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, class_1799.field_8037, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemForItemTrade(class_1799 price1, class_1799 price2, class_1935[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price1, price2, Lists.newArrayList((Object[])sellItemOptions), maxTrades, xpValue, priceMult);
        }

        public RandomItemForItemTrade(class_1799 price, List<? extends class_1935> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this(price, class_1799.field_8037, sellItemOptions, maxTrades, xpValue, priceMult);
        }

        public RandomItemForItemTrade(class_1799 price1, class_1799 price2, List<? extends class_1935> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
            this.price1 = price1;
            this.price2 = price2;
            this.sellItemOptions = sellItemOptions;
            this.maxTrades = maxTrades;
            this.xpValue = xpValue;
            this.priceMult = priceMult;
        }

        public class_1914 method_7246(class_1297 trader, class_5819 rand) {
            int index = rand.method_43048(this.sellItemOptions.size());
            class_1799 sellItem = new class_1799(this.sellItemOptions.get(index));
            return new class_1914(this.price1, this.price2, sellItem, this.maxTrades, this.xpValue, this.priceMult);
        }
    }

    private static class EnchantedBookForCoinsTrade
    implements class_3853.class_1652 {
        private static final class_1792 baseCoin = ModItems.COIN_GOLD;
        private static final int baseCoinAmount = 5;
        private final int xpValue;

        public EnchantedBookForCoinsTrade(int xpValue) {
            this.xpValue = xpValue;
        }

        public class_1914 method_7246(class_1297 trader, class_5819 rand) {
            List<class_1887> list = class_7923.field_41176.method_10220().filter(class_1887::method_25949).toList();
            class_1887 enchantment = list.get(rand.method_43048(list.size()));
            int level = 1;
            if (enchantment.method_8183() > 0) {
                level = rand.method_43048(enchantment.method_8183()) + 1;
            } else {
                LightmansCurrency.LogError("Enchantment of type '" + class_7923.field_41176.method_10221((Object)enchantment) + "' has a max enchantment level of " + enchantment.method_8183() + ". Unable to properly randomize the enchantment level for a villager trade. Will default to a level 1 enchantment.");
            }
            class_1799 itemstack = class_1772.method_7808((class_1889)new class_1889(enchantment, level));
            long coinValue = MoneyUtil.getValue(baseCoin);
            long baseValue = coinValue * 5L;
            int valueRandom = rand.method_43048(5 + level * 10);
            long value = baseValue + coinValue * (long)(level + valueRandom);
            if (enchantment.method_8193()) {
                value *= 2L;
            }
            List<class_1799> coins = MoneyUtil.getCoinsOfValue(value);
            class_1799 price1 = class_1799.field_8037;
            class_1799 price2 = class_1799.field_8037;
            if (!coins.isEmpty()) {
                price1 = coins.get(0);
            }
            if (coins.size() > 1) {
                price2 = coins.get(1);
            }
            LightmansCurrency.LogDebug("EnchantedBookForCoinsTrade.getOffer() -> \nbaseValue=" + baseValue + "\ncoinValue=" + coinValue + "\nlevel=" + level + "\nvalueRandom=" + valueRandom + "\nvalue=" + value + "\nprice1=" + price1.method_7947() + "x" + class_7923.field_41178.method_10221((Object)price1.method_7909()) + "\nprice2=" + price2.method_7947() + "x" + class_7923.field_41178.method_10221((Object)price2.method_7909()));
            return new class_1914(price1, price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }

    private static class EnchantedItemForCoinsTrade
    implements class_3853.class_1652 {
        private final class_1792 baseCoin;
        private final int baseCoinCount;
        private final class_1792 sellItem;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;
        private final double basePriceModifier;

        private EnchantedItemForCoinsTrade(class_1935 baseCoin, int baseCoinCount, class_1935 sellItem, int maxUses, int xpValue, float priceMultiplier, double basePriceModifier) {
            this.baseCoin = baseCoin.method_8389();
            this.baseCoinCount = baseCoinCount;
            this.sellItem = sellItem.method_8389();
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
            this.basePriceModifier = basePriceModifier;
        }

        public class_1914 method_7246(class_1297 trader, class_5819 rand) {
            int i = 5 + rand.method_43048(15);
            class_1799 itemstack = class_1890.method_8233((class_5819)rand, (class_1799)new class_1799((class_1935)this.sellItem), (int)i, (boolean)false);
            long coinValue = MoneyUtil.getValue(this.baseCoin);
            long baseValue = coinValue * (long)this.baseCoinCount;
            long priceValue = baseValue + (long)((double)(coinValue * (long)i) * this.basePriceModifier);
            class_1799 price1 = class_1799.field_8037;
            class_1799 price2 = class_1799.field_8037;
            List<class_1799> priceStacks = MoneyUtil.getCoinsOfValue(priceValue);
            if (!priceStacks.isEmpty()) {
                price1 = priceStacks.get(0);
            }
            if (priceStacks.size() > 1) {
                price2 = priceStacks.get(1);
            }
            LightmansCurrency.LogDebug("EnchantedItemForCoinsTrade.getOffer() -> \ni=" + i + "\ncoinValue=" + coinValue + "\nbaseValue=" + baseValue + "\npriceValue=" + priceValue + "\nprice1=" + price1.method_7947() + "x" + class_7923.field_41178.method_10221((Object)price1.method_7909()) + "\nprice2=" + price2.method_7947() + "x" + class_7923.field_41178.method_10221((Object)price2.method_7909()));
            return new class_1914(price1, price2, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    private static class ItemsForMapTrade
    implements class_3853.class_1652 {
        private final class_1799 price1;
        private final class_1799 price2;
        private final class_6862<class_3195> destination;
        private final String displayName;
        private final class_20.class_21 mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public ItemsForMapTrade(class_1799 price, class_6862<class_3195> destination, String displayName, class_20.class_21 mapDecorationType, int maxUses, int xpValue) {
            this(price, class_1799.field_8037, destination, displayName, mapDecorationType, maxUses, xpValue);
        }

        public ItemsForMapTrade(class_1799 price1, class_1799 price2, class_6862<class_3195> destination, String displayName, class_20.class_21 mapDecorationType, int maxUses, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.destination = destination;
            this.displayName = displayName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        public class_1914 method_7246(class_1297 trader, class_5819 rand) {
            class_1937 class_19372 = trader.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return null;
            }
            class_3218 serverworld = (class_3218)class_19372;
            class_2338 blockPos = serverworld.method_8487(this.destination, trader.method_24515(), 100, true);
            if (blockPos != null) {
                class_1799 itemstack = class_1806.method_8005((class_1937)serverworld, (int)blockPos.method_10263(), (int)blockPos.method_10260(), (byte)2, (boolean)true, (boolean)true);
                class_1806.method_8002((class_3218)serverworld, (class_1799)itemstack);
                class_22.method_110((class_1799)itemstack, (class_2338)blockPos, (String)"+", (class_20.class_21)this.mapDecorationType);
                itemstack.method_7977((class_2561)class_2561.method_43471((String)this.displayName));
                return new class_1914(this.price1, this.price2, itemstack, this.maxUses, this.xpValue, 0.05f);
            }
            return null;
        }
    }

    private static class SuspiciousStewForItemTrade
    implements class_3853.class_1652 {
        private final class_1799 price1;
        private final class_1799 price2;
        private final class_1291 effect;
        private final int duration;
        private final int xpValue;

        private SuspiciousStewForItemTrade(class_1799 price, class_1291 effect, int duration, int xpValue) {
            this(price, class_1799.field_8037, effect, duration, xpValue);
        }

        private SuspiciousStewForItemTrade(class_1799 price1, class_1799 price2, class_1291 effect, int duration, int xpValue) {
            this.price1 = price1;
            this.price2 = price2;
            this.effect = effect;
            this.duration = duration;
            this.xpValue = xpValue;
        }

        public class_1914 method_7246(class_1297 trader, class_5819 rand) {
            class_1799 itemstack = new class_1799((class_1935)class_1802.field_8766, 1);
            class_1830.method_8021((class_1799)itemstack, (class_1291)this.effect, (int)this.duration);
            return new class_1914(this.price1, this.price2, itemstack, 12, this.xpValue, 0.05f);
        }
    }
}

