/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class TraderArgument
implements ArgumentType<TraderData> {
    private static final SimpleCommandExceptionType ERROR_NOT_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"command.argument.trader.notfound"));
    private final boolean acceptPersistentIDs;

    private TraderArgument(boolean acceptPersistentIDs) {
        this.acceptPersistentIDs = acceptPersistentIDs;
    }

    public static TraderArgument trader() {
        return new TraderArgument(false);
    }

    public static TraderArgument traderWithPersistent() {
        return new TraderArgument(true);
    }

    public static TraderData getTrader(CommandContext<class_2168> commandContext, String name) {
        return (TraderData)commandContext.getArgument(name, TraderData.class);
    }

    public TraderData parse(StringReader reader) throws CommandSyntaxException {
        String traderID = reader.readUnquotedString();
        if (TraderArgument.isNumerical(traderID)) {
            try {
                TraderData t;
                long id = Long.parseLong(traderID);
                if (id >= 0L && (t = TraderSaveData.GetTrader(false, id)) != null) {
                    return t;
                }
            }
            catch (Throwable id) {
                // empty catch block
            }
        }
        if (this.acceptPersistentIDs) {
            List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
            for (TraderData t : allTraders) {
                if (!t.isPersistent() || !t.getPersistentID().equals(traderID)) continue;
                return t;
            }
        }
        throw ERROR_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
    }

    private static boolean isNumerical(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
        for (TraderData t : allTraders) {
            suggestionsBuilder.suggest(String.valueOf(t.getID()));
            if (!this.acceptPersistentIDs || !t.isPersistent()) continue;
            suggestionsBuilder.suggest(t.getPersistentID());
        }
        return suggestionsBuilder.buildFuture();
    }

    public static class Info
    implements class_2314<TraderArgument, Template> {
        public void writePacket(Template template, class_2540 buffer) {
            buffer.writeBoolean(template.acceptPersistentIDs);
        }

        public Template fromPacket(class_2540 buffer) {
            return new Template(buffer.readBoolean());
        }

        public void writeJson(Template template, JsonObject json) {
            json.addProperty("acceptPersistentIDs", Boolean.valueOf(template.acceptPersistentIDs));
        }

        public Template getArgumentTypeProperties(TraderArgument argument) {
            return new Template(argument.acceptPersistentIDs);
        }

        public final class Template
        implements class_2314.class_7217<TraderArgument> {
            final boolean acceptPersistentIDs;

            Template(boolean checkPersistentIDs) {
                this.acceptPersistentIDs = checkPersistentIDs;
            }

            public TraderArgument createType(class_7157 p_235378_) {
                return new TraderArgument(this.acceptPersistentIDs);
            }

            public class_2314<TraderArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

