/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TraderArgument;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.network.client.messages.admin.SMessageSyncAdminList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandLCAdmin {
    private static List<UUID> adminPlayers = new ArrayList<UUID>();
    private static final SimpleCommandExceptionType ERROR_BLOCK_NOT_FOUND = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"command.trader.block.notfound"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lcadmin").requires(commandSource -> commandSource.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"toggleadmin").requires(commandSource -> commandSource.method_9228() instanceof class_3222)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"traderdata").then(class_2170.method_9247((String)"list").executes(CommandLCAdmin::listTraderData))).then(class_2170.method_9247((String)"search").then(class_2170.method_9244((String)"searchText", (ArgumentType)class_2178.method_9281()).executes(CommandLCAdmin::searchTraderData)))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::deleteTraderData)))).then(class_2170.method_9247((String)"debug").then(class_2170.method_9244((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::debugTraderData)))).then(class_2170.method_9247((String)"addToWhitelist").then(class_2170.method_9244((String)"traderID", (ArgumentType)TraderArgument.traderWithPersistent()).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(CommandLCAdmin::addToTraderWhitelist)))))).then(class_2170.method_9247((String)"prepareForStructure").then(class_2170.method_9244((String)"traderPos", (ArgumentType)class_2262.method_9698()).executes(CommandLCAdmin::setCustomTrader)));
        dispatcher.register(lcAdminCommand);
    }

    static int toggleAdmin(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        class_3222 sourcePlayer = source.method_9207();
        CommandLCAdmin.ToggleAdminPlayer(sourcePlayer);
        class_5250 enabledDisabled = CommandLCAdmin.isAdminPlayer((class_1657)sourcePlayer) ? class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.toggleadmin.enabled").method_27692(class_124.field_1060) : class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.toggleadmin.disabled").method_27692(class_124.field_1061);
        source.method_9226(() -> CommandLCAdmin.lambda$toggleAdmin$2((class_2561)enabledDisabled), true);
        return 1;
    }

    static int setCustomTrader(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        class_2338 pos = class_2262.method_9696(commandContext, (String)"traderPos");
        class_3218 level = source.method_9225();
        class_2680 state = level.method_8320(pos);
        class_2586 be = state.method_26204() instanceof ITraderBlock ? ((ITraderBlock)state.method_26204()).getBlockEntity(state, (class_1936)level, pos) : level.method_8321(pos);
        if (be instanceof TraderBlockEntity) {
            TraderBlockEntity trader = (TraderBlockEntity)be;
            trader.saveCurrentTraderAsCustomTrader();
            source.method_9226(() -> class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.setCustomTrader.success"), true);
            return 1;
        }
        throw ERROR_BLOCK_NOT_FOUND.create();
    }

    static int listTraderData(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
        if (allTraders.size() > 0) {
            source.method_9226(() -> class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                TraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    source.method_9226(class_2561::method_43473, true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.method_9226(() -> class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.universaldata.list.none"), true);
        }
        return 1;
    }

    static int searchTraderData(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        String searchText = class_2196.method_9339(commandContext, (String)"searchText").getString();
        List<TraderData> results = TraderSaveData.GetAllTraders(false).stream().filter(trader -> TraderSearchFilter.CheckFilters(trader, searchText)).toList();
        if (results.size() > 0) {
            source.method_9226(() -> class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.universaldata.list.title"), true);
            for (int i = 0; i < results.size(); ++i) {
                TraderData thisTrader = results.get(i);
                if (i > 0) {
                    source.method_9226(class_2561::method_43473, true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            source.method_9226(() -> class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.universaldata.list.search.none"), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(TraderData thisTrader, class_2168 source) {
        String traderID = String.valueOf(thisTrader.getID());
        source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.traderid", (Object[])new Object[]{class_2561.method_43470((String)traderID).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, traderID)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.universaldata.list.traderid.copytooltip"))))}), false);
        if (thisTrader.isPersistent()) {
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.persistentid", (Object[])new Object[]{thisTrader.getPersistentID()}), false);
        }
        source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.type", (Object[])new Object[]{thisTrader.type}), false);
        if (thisTrader instanceof AuctionHouseTrader) {
            return;
        }
        if (thisTrader.getOwner().hasTeam()) {
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.owner.team", (Object[])new Object[]{thisTrader.getOwner().getTeam().getName(), thisTrader.getOwner().getTeam().getID()}), false);
        } else if (thisTrader.getOwner().hasPlayer()) {
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.owner", (Object[])new Object[]{thisTrader.getOwner().getPlayer().getName(false), thisTrader.getOwner().getPlayer().id.toString()}), false);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.owner.custom", (Object[])new Object[]{thisTrader.getOwner().getOwnerName(false)}), false);
        }
        if (!thisTrader.isPersistent()) {
            String dimension = thisTrader.getLevel().method_29177().toString();
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.dimension", (Object[])new Object[]{dimension}), false);
            class_2338 pos = thisTrader.getPos();
            String position = pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
            String teleportPosition = pos.method_10263() + " " + (pos.method_10264() + 1) + " " + pos.method_10260();
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.position", (Object[])new Object[]{class_2561.method_43470((String)position).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/execute in " + dimension + " run tp @s " + teleportPosition)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.universaldata.list.position.teleporttooltip"))))}), true);
        }
        if (thisTrader.hasCustomName()) {
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.list.name", (Object[])new Object[]{thisTrader.getName()}), true);
        }
    }

    static int deleteTraderData(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TraderSaveData.DeleteTrader(trader.getID());
        source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.universaldata.delete.success", (Object[])new Object[]{trader.getName()}), true);
        return 1;
    }

    static int debugTraderData(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        source.method_9226(() -> class_2561.method_43470((String)trader.save().method_10714()), false);
        return 1;
    }

    static int addToTraderWhitelist(CommandContext<class_2168> commandContext) throws CommandSyntaxException {
        class_2168 source = (class_2168)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TradeRule rule = TradeRule.getRule(PlayerWhitelist.TYPE, trader.getRules());
        if (rule instanceof PlayerWhitelist) {
            PlayerWhitelist whitelist = (PlayerWhitelist)rule;
            Collection players = class_2186.method_9312(commandContext, (String)"player");
            int count = 0;
            for (class_3222 player : players) {
                if (!whitelist.addToWhitelist((class_1657)player)) continue;
                ++count;
            }
            int c = count;
            source.method_9226(() -> class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.traderdata.add_whitelist.success", (Object[])new Object[]{c, trader.getName()}), true);
            if (count > 0) {
                trader.markRulesDirty();
            }
            return count;
        }
        source.method_9213((class_2561)class_2561.method_43471((String)"command.lightmanscurrency.lcadmin.traderdata.add_whitelist.missingrule"));
        return 0;
    }

    public static boolean isAdminPlayer(class_1657 player) {
        return adminPlayers.contains(player.method_5667()) && player.method_5687(2);
    }

    private static void ToggleAdminPlayer(class_3222 player) {
        UUID playerID = player.method_5667();
        if (adminPlayers.contains(playerID)) {
            adminPlayers.remove(playerID);
        } else {
            adminPlayers.add(playerID);
        }
        new SMessageSyncAdminList(adminPlayers).sendToAll();
    }

    public static void SendAdminList(PacketSender channel) {
        new SMessageSyncAdminList(adminPlayers).sendTo(channel);
    }

    public static void loadAdminPlayers(List<UUID> serverAdminList) {
        adminPlayers = serverAdminList;
    }

    private static /* synthetic */ class_2561 lambda$toggleAdmin$2(class_2561 enabledDisabled) {
        return class_2561.method_43469((String)"command.lightmanscurrency.lcadmin.toggleadmin", (Object[])new Object[]{enabledDisabled});
    }
}

