/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.item;

import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.item.ItemInterfaceHandler;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menu.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.network.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1278;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

public class ItemTraderInterfaceBlockEntity
extends TraderInterfaceBlockEntity
implements TraderItemStorage.ITraderInputOutputFilter {
    private final TraderItemStorage itemBuffer = new TraderItemStorage(this);
    ItemInterfaceHandler itemHandler = this.addHandler(new ItemInterfaceHandler(this));

    public TraderItemStorage getItemBuffer() {
        return this.itemBuffer;
    }

    public ItemInterfaceHandler getItemHandler() {
        return this.itemHandler;
    }

    public ItemTraderInterfaceBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ITEM_TRADER_INTERFACE, pos, state);
    }

    @Override
    public TradeContext.Builder buildTradeContext(TradeContext.Builder baseContext) {
        return baseContext.withItemStorage(this.itemBuffer);
    }

    @Override
    public boolean allowInput(class_1799 item) {
        if (this.getInteractionType().trades) {
            TradeData t = this.getReferencedTrade();
            if (t instanceof ItemTradeData) {
                ItemTradeData trade = (ItemTradeData)t;
                if (trade.isBarter()) {
                    for (int i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getBarterItem(i))) continue;
                        return true;
                    }
                } else if (trade.isPurchase()) {
                    for (int i = 0; i < 2; ++i) {
                        if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        TraderData trader = this.getTrader();
        if (trader instanceof ItemTraderData) {
            for (ItemTradeData trade : ((ItemTraderData)trader).getTradeData()) {
                if (!trade.isSale() && !trade.isBarter()) continue;
                for (int i = 0; i < 2; ++i) {
                    if (!InventoryUtil.ItemMatches(item, trade.getSellItem(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean allowOutput(class_1799 item) {
        return !this.allowInput(item);
    }

    @Override
    public boolean isItemRelevant(class_1799 item) {
        if (this.getInteractionType().trades) {
            TradeData t = this.getReferencedTrade();
            if (t instanceof ItemTradeData) {
                ItemTradeData trade = (ItemTradeData)t;
                return trade.allowItemInStorage(item);
            }
        } else {
            TraderData trader = this.getTrader();
            if (trader instanceof ItemTraderData) {
                for (ItemTradeData trade : ((ItemTraderData)trader).getTradeData()) {
                    if (!trade.allowItemInStorage(item)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgradeInventory().method_5439(); ++i) {
            UpgradeItem upgradeItem;
            class_1799 stack = this.getUpgradeInventory().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)class_17922) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += upgradeItem.getDefaultUpgradeData().getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    protected ItemTradeData deserializeTrade(class_2487 compound) {
        return ItemTradeData.loadData(compound, false);
    }

    @Override
    protected void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveItemBuffer(compound);
    }

    protected final class_2487 saveItemBuffer(class_2487 compound) {
        this.itemBuffer.save(compound, "Storage");
        return compound;
    }

    public void setItemBufferDirty() {
        this.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveItemBuffer(new class_2487()));
        }
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("Storage")) {
            this.itemBuffer.load(compound, "Storage");
        }
    }

    @Override
    public boolean validTraderType(TraderData trader) {
        return trader instanceof ItemTraderData;
    }

    protected final ItemTraderData getItemTrader() {
        TraderData trader = this.getTrader();
        if (trader instanceof ItemTraderData) {
            return (ItemTraderData)trader;
        }
        return null;
    }

    @Override
    protected void drainTick() {
        ItemTraderData trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner.getPlayerForContext(), "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = trader.getTrade(i);
                if (!trade.isValid()) continue;
                ArrayList<class_1799> drainItems = new ArrayList<class_1799>();
                if (trade.isPurchase()) {
                    drainItems.add(trade.getSellItem(0));
                    drainItems.add(trade.getSellItem(1));
                }
                if (trade.isBarter()) {
                    drainItems.add(trade.getBarterItem(0));
                    drainItems.add(trade.getBarterItem(1));
                }
                for (class_1799 drainItem : drainItems) {
                    int drainableAmount;
                    if (drainItem.method_7960() || (drainableAmount = trader.getStorage().getItemCount(drainItem)) <= 0) continue;
                    class_1799 movingStack = drainItem.method_7972();
                    movingStack.method_7939(Math.min(movingStack.method_7914(), drainableAmount));
                    class_1799 removed = trader.getStorage().removeItem(movingStack);
                    this.itemBuffer.tryAddItem(removed);
                    if (!removed.method_7960()) {
                        trader.getStorage().forceAddItem(removed);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void restockTick() {
        ItemTraderData trader = this.getItemTrader();
        if (trader != null && trader.hasPermission(this.owner.getPlayerForContext(), "interactionLink")) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                ItemTradeData trade = trader.getTrade(i);
                if (!trade.isValid() || !trade.isBarter() && !trade.isSale()) continue;
                for (int s = 0; s < 2; ++s) {
                    int stockableAmount;
                    class_1799 stockItem = trade.getSellItem(s);
                    if (stockItem.method_7960() || (stockableAmount = this.itemBuffer.getItemCount(stockItem)) <= 0) continue;
                    class_1799 movingStack = stockItem.method_7972();
                    movingStack.method_7939(Math.min(movingStack.method_7914(), stockableAmount));
                    class_1799 removedItem = this.itemBuffer.removeItem(movingStack);
                    if (removedItem.method_7947() == movingStack.method_7947()) {
                        trader.getStorage().tryAddItem(movingStack);
                        if (!movingStack.method_7960()) {
                            this.itemBuffer.forceAddItem(movingStack);
                        }
                    } else {
                        this.itemBuffer.forceAddItem(removedItem);
                    }
                    this.setItemBufferDirty();
                    trader.markStorageDirty();
                }
            }
        }
    }

    @Override
    protected void tradeTick() {
        ItemTradeData trade;
        TradeData t = this.getTrueTrade();
        if (t instanceof ItemTradeData && (trade = (ItemTradeData)t).isValid()) {
            if (trade.isSale()) {
                if (this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isPurchase()) {
                if (this.itemBuffer.hasItems(trade.getSellItem(0), trade.getSellItem(1))) {
                    this.interactWithTrader();
                    this.setItemBufferDirty();
                }
            } else if (trade.isBarter() && this.itemBuffer.hasItems(trade.getBarterItem(0), trade.getBarterItem(1)) && this.itemBuffer.canFitItems(trade.getSellItem(0), trade.getSellItem(1))) {
                this.interactWithTrader();
                this.setItemBufferDirty();
            }
        }
    }

    @Override
    protected void hopperTick() {
        AtomicBoolean markBufferDirty = new AtomicBoolean(false);
        for (class_2350 relativeSide : class_2350.values()) {
            class_2338 queryPos;
            class_2586 be;
            if (!this.itemHandler.getInputSides().get(relativeSide) && !this.itemHandler.getOutputSides().get(relativeSide)) continue;
            class_2350 actualSide = relativeSide;
            class_2248 class_22482 = this.method_11010().method_26204();
            if (class_22482 instanceof IRotatableBlock) {
                IRotatableBlock b = (IRotatableBlock)class_22482;
                actualSide = IRotatableBlock.getActualSide(b.getFacing(this.method_11010()), relativeSide);
            }
            if (!((be = this.field_11863.method_8321(queryPos = this.field_11867.method_10093(actualSide))) instanceof class_1278)) continue;
            class_1278 sidedInventory = (class_1278)be;
            if (this.itemHandler.getInputSides().get(relativeSide)) {
                boolean query = true;
                int[] slots = sidedInventory.method_5494(actualSide.method_10153());
                for (int x = 0; query && x < slots.length; ++x) {
                    int slot = slots[x];
                    class_1799 stack = sidedInventory.method_5438(slot);
                    int fittableAmount = this.itemBuffer.getFittableAmount(stack);
                    if (fittableAmount <= 0 || !sidedInventory.method_5493(slot, stack, actualSide.method_10153())) continue;
                    query = false;
                    class_1799 result = sidedInventory.method_5434(slot, fittableAmount);
                    this.itemBuffer.forceAddItem(result);
                    markBufferDirty.set(true);
                }
            }
            if (!this.itemHandler.getOutputSides().get(relativeSide)) continue;
            List<class_1799> buffer = this.itemBuffer.getContents();
            boolean query = true;
            for (int i = 0; query && i < buffer.size(); ++i) {
                class_1799 stack = buffer.get(i).method_7972();
                if (!this.allowOutput(stack)) continue;
                int[] slots = sidedInventory.method_5494(actualSide.method_10153());
                for (int x = 0; query && x < slots.length; ++x) {
                    int placeAmount;
                    int slot = slots[x];
                    class_1799 existingStack = sidedInventory.method_5438(slot);
                    if ((!InventoryUtil.ItemMatches(stack, existingStack) || existingStack.method_7947() >= existingStack.method_7914()) && (!existingStack.method_7960() || !sidedInventory.method_5492(slot, stack.method_7972(), actualSide.method_10153()))) continue;
                    query = false;
                    markBufferDirty.set(true);
                    if (existingStack.method_7960()) {
                        placeAmount = Math.min(stack.method_7947(), stack.method_7914());
                        class_1799 placeStack = stack.method_7972();
                        placeStack.method_7939(placeAmount);
                        sidedInventory.method_5447(slot, placeStack);
                        sidedInventory.method_5431();
                        this.itemBuffer.removeItem(placeStack.method_7972());
                        continue;
                    }
                    placeAmount = Math.min(existingStack.method_7914() - existingStack.method_7947(), stack.method_7947());
                    existingStack.method_7933(placeAmount);
                    class_1799 removeStack = existingStack.method_7972();
                    removeStack.method_7939(placeAmount);
                    this.itemBuffer.removeItem(removeStack);
                }
            }
        }
        if (markBufferDirty.get()) {
            this.setItemBufferDirty();
        }
    }

    @Override
    public void initMenuTabs(TraderInterfaceMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
    }

    @Override
    public boolean allowAdditionalUpgrade(UpgradeType type) {
        return type == UpgradeType.ITEM_CAPACITY;
    }

    @Override
    public void getAdditionalContents(List<class_1799> contents) {
        contents.addAll(this.itemBuffer.getSplitContents());
    }

    @Override
    public class_5250 getName() {
        return class_2561.method_43471((String)"block.lightmanscurrency.item_trader_interface");
    }
}

