/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blockentity.interfaces.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.network.util.BlockEntityUtil;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public abstract class TraderBlockEntity<D extends TraderData>
extends TickableBlockEntity
implements IOwnableBlockEntity,
SidedStorageBlockEntity {
    private long traderID = -1L;
    private class_2487 customTrader = null;
    private boolean ignoreCustomTrader = false;
    private boolean legitimateBreak = false;

    public long getTraderID() {
        return this.traderID;
    }

    @Deprecated
    public void setTraderID(long traderID) {
        this.traderID = traderID;
    }

    public void flagAsLegitBreak() {
        this.legitimateBreak = true;
    }

    public boolean legitimateBreak() {
        return this.legitimateBreak;
    }

    public final boolean isClient() {
        return this.field_11863 != null && this.field_11863.field_9236;
    }

    public TraderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private D buildTrader(class_1657 owner, class_1799 placementStack) {
        D newTrader;
        if (this.customTrader != null && (newTrader = this.fullyBuildCustomTrader()) != null) {
            return newTrader;
        }
        newTrader = this.buildNewTrader();
        ((TraderData)newTrader).getOwner().SetOwner(PlayerReference.of(owner));
        if (placementStack.method_7938()) {
            ((TraderData)newTrader).setCustomName(null, placementStack.method_7964().getString());
        }
        return newTrader;
    }

    protected final D initCustomTrader() {
        try {
            return (D)TraderData.Deserialize(false, this.customTrader);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error while attempting to load the custom trader!", t);
            return null;
        }
    }

    protected final D fullyBuildCustomTrader() {
        try {
            D newTrader = this.initCustomTrader();
            this.moveCustomTrader(newTrader);
            return newTrader;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error while attempting to load the custom trader!", t);
            return null;
        }
    }

    protected final void moveCustomTrader(D customTrader) {
        if (customTrader != null) {
            ((TraderData)customTrader).move(this.field_11863, this.field_11867);
        }
    }

    protected abstract D buildNewTrader();

    public final void saveCurrentTraderAsCustomTrader() {
        D trader = this.getTraderData();
        if (trader != null) {
            this.customTrader = ((TraderData)trader).save();
            this.ignoreCustomTrader = true;
            this.method_5431();
        }
    }

    public void initialize(class_1657 owner, class_1799 placementStack) {
        if (this.getTraderData() != null) {
            return;
        }
        D newTrader = this.buildTrader(owner, placementStack);
        this.traderID = TraderSaveData.RegisterTrader(newTrader, owner);
        this.method_5431();
    }

    private TraderData getRawTraderData() {
        return TraderSaveData.GetTrader(this.isClient(), this.traderID);
    }

    public D getTraderData() {
        TraderData rawData = this.getRawTraderData();
        try {
            return (D)rawData;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10544("TraderID", this.traderID);
        if (this.customTrader != null) {
            compound.method_10566("CustomTrader", (class_2520)this.customTrader);
        }
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10573("TraderID", 4)) {
            this.traderID = compound.method_10537("TraderID");
        }
        if (compound.method_10545("CustomTrader")) {
            this.customTrader = compound.method_10562("CustomTrader");
        }
    }

    @Override
    public void serverTick() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.customTrader != null && !this.ignoreCustomTrader) {
            D customTrader = this.initCustomTrader();
            if (customTrader == null) {
                LightmansCurrency.LogWarning("The trader block at " + this.field_11867.method_23854() + " could not properly load it's custom trader.");
                this.customTrader = null;
                this.method_5431();
                return;
            }
            if (((TraderData)customTrader).getLevel() == this.field_11863.method_27983() && this.field_11867.equals((Object)((TraderData)customTrader).getPos())) {
                this.ignoreCustomTrader = true;
            } else {
                this.moveCustomTrader(customTrader);
                this.traderID = TraderSaveData.RegisterTrader(customTrader, null);
                this.customTrader = null;
                this.ignoreCustomTrader = true;
                this.method_5431();
                LightmansCurrency.LogInfo("Successfully loaded custom trader at " + this.field_11867.method_23854());
            }
        }
    }

    public final void method_5431() {
        super.method_5431();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this);
        }
    }

    @Override
    public void onLoad() {
        if (this.field_11863.field_9236) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public boolean canBreak(class_1657 player) {
        D trader = this.getTraderData();
        if (trader != null) {
            return ((TraderData)trader).hasPermission(player, "breakTrader");
        }
        return true;
    }

    public void deleteTrader() {
        if (this.getTraderData() != null) {
            TraderSaveData.DeleteTrader(this.traderID);
        }
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        D trader = this.getTraderData();
        if (trader != null) {
            return ((TraderData)trader).getItemStorage(this.getRelativeSide(side));
        }
        return null;
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        D trader = this.getTraderData();
        if (trader != null) {
            return ((TraderData)trader).getFluidStorage(this.getRelativeSide(side));
        }
        return null;
    }

    public final class_2350 getRelativeSide(class_2350 side) {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof IRotatableBlock) {
            IRotatableBlock block = (IRotatableBlock)class_22482;
            return IRotatableBlock.getRelativeSide(block.getFacing(this.method_11010()), side);
        }
        return side;
    }
}

