/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PaygateBlockEntity
extends TraderBlockEntity<PaygateTraderData> {
    private int timer = 0;

    public PaygateBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntities.PAYGATE, pos, state);
    }

    protected PaygateBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveTimer(compound);
    }

    public final void saveTimer(class_2487 compound) {
        compound.method_10569("Timer", Math.max(this.timer, 0));
    }

    @Override
    public void method_11014(class_2487 compound) {
        if (compound.method_10573("Timer", 3)) {
            this.timer = Math.max(compound.method_10550("Timer"), 0);
        }
        super.method_11014(compound);
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public void activate(int duration) {
        this.timer = duration;
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        }
        this.method_5431();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.timer > 0) {
            --this.timer;
            this.method_5431();
            if (this.timer <= 0 && this.field_11863 != null) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public void onLoad() {
        PaygateTraderData data = (PaygateTraderData)this.getTraderData();
        if (data != null) {
            data.setCachedBE(this);
        }
    }

    public int getValidTicketTrade(class_1657 player, class_1799 heldItem) {
        UUID ticketID;
        PaygateTraderData trader = (PaygateTraderData)this.getTraderData();
        if (heldItem.method_7909() == ModItems.TICKET && (ticketID = TicketItem.GetTicketID(heldItem)) != null) {
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                PaygateTradeData trade = trader.getTrade(i);
                if (!trade.isTicketTrade() || !trade.getTicketID().equals(ticketID) || trader.runPreTradeEvent(PlayerReference.of(player), trade).isCanceled()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected PaygateTraderData buildNewTrader() {
        return new PaygateTraderData(this.field_11863, this.field_11867);
    }
}

