/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ArmorDisplayTraderBlockEntity
extends ItemTraderBlockEntity {
    public static final int TRADE_COUNT = 4;
    private static final int TICK_DELAY = 20;
    UUID armorStandID = null;
    int updateTimer = 0;
    private boolean loaded = false;

    public void flagAsLoaded() {
        this.loaded = true;
    }

    public ArmorDisplayTraderBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ARMOR_TRADER, pos, state, 4);
    }

    @Override
    public ItemTraderData buildNewTrader() {
        return new ItemTraderDataArmor(this.field_11863, this.field_11867);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (!this.loaded) {
            return;
        }
        if (this.updateTimer <= 0) {
            this.updateTimer = 20;
            this.validateArmorStand();
            this.updateArmorStandArmor();
        } else {
            --this.updateTimer;
        }
    }

    public void validateArmorStand() {
        if (this.isClient()) {
            return;
        }
        class_1531 armorStand = this.getArmorStand();
        if (armorStand == null || armorStand.method_31481()) {
            this.spawnArmorStand();
        } else {
            this.validateArmorStandValues();
        }
    }

    private void spawnArmorStand() {
        if (this.field_11863 == null || this.isClient()) {
            return;
        }
        class_1531 armorStand = new class_1531(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260() + 0.5);
        armorStand.method_5808((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260() + 0.5, this.getStandRotation(), 0.0f);
        armorStand.method_5684(true);
        armorStand.method_5875(true);
        armorStand.method_5803(true);
        class_2487 compound = armorStand.method_5647(new class_2487());
        compound.method_10556("Marker", true);
        compound.method_10556("NoBasePlate", true);
        armorStand.method_5651(compound);
        this.field_11863.method_8649((class_1297)armorStand);
        this.armorStandID = armorStand.method_5667();
        this.method_5431();
    }

    protected void updateArmorStandArmor() {
        ItemTraderData trader;
        class_1531 armorStand = this.getArmorStand();
        if (armorStand != null && (trader = (ItemTraderData)this.getTraderData()) != null) {
            List<ItemTradeData> trades = trader.getTradeData();
            for (int i = 0; i < 4 && i < trades.size(); ++i) {
                ItemTradeData thisTrade = trades.get(i);
                ItemTradeRestriction r = thisTrade.getRestriction();
                class_1304 slot = null;
                if (r instanceof EquipmentRestriction) {
                    EquipmentRestriction er = (EquipmentRestriction)r;
                    slot = er.getEquipmentSlot();
                }
                if (slot == null) continue;
                if (thisTrade.hasStock(trader) || trader.isCreative()) {
                    armorStand.method_5673(slot, thisTrade.getSellItem(0));
                    continue;
                }
                armorStand.method_5673(slot, class_1799.field_8037);
            }
        }
    }

    protected void validateArmorStandValues() {
        class_1531 armorStand = this.getArmorStand();
        if (armorStand == null) {
            return;
        }
        armorStand.method_5808((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264(), (double)((float)this.field_11867.method_10260() + 0.5f), this.getStandRotation(), 0.0f);
        if (!armorStand.method_5655()) {
            armorStand.method_5684(true);
        }
        if (armorStand.method_5767()) {
            armorStand.method_5648(false);
        }
        if (!armorStand.method_5740()) {
            armorStand.method_5875(true);
        }
        if (!armorStand.method_5701()) {
            armorStand.method_5803(true);
        }
        if (!armorStand.method_6912() || !armorStand.method_6901()) {
            class_2487 compound = armorStand.method_5647(new class_2487());
            if (!armorStand.method_6912()) {
                compound.method_10556("Marker", true);
            }
            if (!armorStand.method_6901()) {
                compound.method_10556("NoBasePlate", true);
            }
            armorStand.method_5651(compound);
        }
    }

    @Override
    public void method_11007(class_2487 compound) {
        this.writeArmorStandData(compound);
        super.method_11007(compound);
    }

    protected void writeArmorStandData(class_2487 compound) {
        if (this.armorStandID != null) {
            compound.method_25927("ArmorStand", this.armorStandID);
        }
    }

    @Override
    public void method_11014(class_2487 compound) {
        this.loaded = true;
        if (compound.method_10545("ArmorStand")) {
            this.armorStandID = compound.method_25926("ArmorStand");
        }
        super.method_11014(compound);
    }

    protected class_1531 getArmorStand() {
        class_3218 level;
        class_1297 entity;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218 && (entity = (level = (class_3218)class_19372).method_14190(this.armorStandID)) instanceof class_1531) {
            class_1531 as = (class_1531)entity;
            return as;
        }
        return null;
    }

    public void destroyArmorStand() {
        class_1531 armorStand = this.getArmorStand();
        if (armorStand != null) {
            armorStand.method_5768();
        }
    }

    protected float getStandRotation() {
        class_2350 facing = class_2350.field_11043;
        if (this.method_11010().method_26204() instanceof IRotatableBlock) {
            facing = ((IRotatableBlock)this.method_11010().method_26204()).getFacing(this.method_11010());
        }
        if (facing == class_2350.field_11035) {
            return 180.0f;
        }
        if (facing == class_2350.field_11043) {
            return 0.0f;
        }
        if (facing == class_2350.field_11039) {
            return -90.0f;
        }
        if (facing == class_2350.field_11034) {
            return 90.0f;
        }
        return 0.0f;
    }
}

