/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.common.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.network.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class CoinMintBlockEntity
extends TickableBlockEntity
implements class_1278 {
    class_1277 storage = new class_1277(2);
    private CoinMintRecipe lastRelevantRecipe = null;
    private int mintTime = 0;

    public class_1277 getStorage() {
        return this.storage;
    }

    public int getMintTime() {
        return this.mintTime;
    }

    public float getMintProgress() {
        return (float)this.mintTime / (float)this.getExpectedMintTime();
    }

    public int getExpectedMintTime() {
        if (this.lastRelevantRecipe != null) {
            return this.lastRelevantRecipe.getDuration();
        }
        return -1;
    }

    private List<CoinMintRecipe> getCoinMintRecipes() {
        if (this.field_11863 != null) {
            return CoinMintBlockEntity.getCoinMintRecipes(this.field_11863);
        }
        return new ArrayList<CoinMintRecipe>();
    }

    public static List<CoinMintRecipe> getCoinMintRecipes(class_1937 level) {
        return RecipeValidator.getValidMintRecipes(level);
    }

    public CoinMintBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntities.COIN_MINT, pos, state);
    }

    protected CoinMintBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.storage.method_5489(this::onInventoryChanged);
    }

    public void method_11007(class_2487 compound) {
        InventoryUtil.saveAllItems("Storage", compound, (class_1263)this.storage);
        compound.method_10569("MintTime", this.mintTime);
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("Storage")) {
            this.storage = InventoryUtil.loadAllItems("Storage", compound, 2);
            this.storage.method_5489(this::onInventoryChanged);
        }
        if (compound.method_10545("MintTime")) {
            this.mintTime = compound.method_10550("MintTime");
        }
    }

    @Override
    public void onLoad() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
        this.lastRelevantRecipe = this.getRelevantRecipe();
    }

    private void onInventoryChanged(class_1263 inventory) {
        if (inventory != this.storage) {
            return;
        }
        this.method_5431();
        this.checkRecipes();
    }

    public void checkRecipes() {
        CoinMintRecipe newRecipe = this.getRelevantRecipe();
        if (this.lastRelevantRecipe != newRecipe) {
            this.lastRelevantRecipe = newRecipe;
            this.mintTime = 0;
            this.markMintTimeDirty();
        }
    }

    @Override
    public void serverTick() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.lastRelevantRecipe != null && this.storage.method_5438(0).method_7947() >= this.lastRelevantRecipe.ingredientCount && this.hasOutputSpace()) {
            ++this.mintTime;
            if (this.mintTime >= this.lastRelevantRecipe.getDuration()) {
                this.mintTime = 0;
                this.mintCoin();
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14833, class_3419.field_15245, 0.5f, 1.0f);
            }
            this.markMintTimeDirty();
        } else if (this.mintTime > 0) {
            this.mintTime = 0;
            this.markMintTimeDirty();
        }
    }

    private void markMintTimeDirty() {
        this.method_5431();
        class_2487 updateTag = new class_2487();
        updateTag.method_10569("MintTime", this.mintTime);
        BlockEntityUtil.sendUpdatePacket(this, updateTag);
    }

    public void dumpContents(class_1937 world, class_2338 pos) {
        InventoryUtil.dumpContents(world, pos, (class_1263)this.storage);
    }

    public boolean validMintInput(class_1799 item) {
        class_1277 tempInv = new class_1277(2);
        tempInv.method_5447(0, item);
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.method_8115((class_1263)tempInv, this.field_11863)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutputSpace() {
        if (this.lastRelevantRecipe == null || this.field_11863 == null) {
            return false;
        }
        class_1799 mintOutput = this.lastRelevantRecipe.method_8110(this.field_11863.method_30349());
        class_1799 currentOutputSlot = this.getStorage().method_5438(1);
        if (currentOutputSlot.method_7960()) {
            return true;
        }
        if (!InventoryUtil.ItemMatches(currentOutputSlot, mintOutput)) {
            return false;
        }
        return currentOutputSlot.method_7914() - currentOutputSlot.method_7947() >= this.lastRelevantRecipe.getOutputItem().method_7947();
    }

    @Nullable
    public CoinMintRecipe getRelevantRecipe() {
        if (this.getStorage().method_5438(0).method_7960()) {
            return null;
        }
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.method_8115((class_1263)this.storage, this.field_11863)) continue;
            return recipe;
        }
        return null;
    }

    public void mintCoin() {
        this.lastRelevantRecipe = this.getRelevantRecipe();
        if (this.lastRelevantRecipe == null || this.field_11863 == null) {
            return;
        }
        class_1799 mintOutput = this.lastRelevantRecipe.method_8110(this.field_11863.method_30349());
        if (mintOutput.method_7960()) {
            return;
        }
        if (!this.hasOutputSpace()) {
            return;
        }
        if (this.storage.method_5438(0).method_7947() < this.lastRelevantRecipe.ingredientCount) {
            return;
        }
        if (this.getStorage().method_5438(1).method_7960()) {
            this.getStorage().method_5447(1, mintOutput);
        } else {
            this.getStorage().method_5438(1).method_7933(mintOutput.method_7947());
        }
        this.getStorage().method_5434(0, mintOutput.method_7947());
        this.method_5431();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11036) {
            return new int[]{0};
        }
        if (side == class_2350.field_11033) {
            return new int[]{1};
        }
        return new int[]{0, 1};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 0;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public int method_5439() {
        return this.storage.method_5439();
    }

    public boolean method_5442() {
        return this.storage.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.storage.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot != 1) {
            return class_1799.field_8037;
        }
        return this.storage.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, 64);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.storage.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
        this.storage.method_5448();
    }
}

