/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.common.callbacks.EntityDeathCallback;
import io.github.lightman314.lightmanscurrency.common.callbacks.ItemEntityCollisionCallback;
import io.github.lightman314.lightmanscurrency.common.core.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.integration.trinketsapi.LCTrinketsAPI;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class EventListener {
    public static void registerEventListeners() {
        PlayerBlockBreakEvents.BEFORE.register(EventListener::onBlockBreak);
        ItemEntityCollisionCallback.EVENT.register(EventListener::onPlayerItemPickup);
        EntityDeathCallback.EVENT.register(EventListener::onPlayerDeath);
    }

    private static void onPlayerItemPickup(class_1542 item, class_1657 player) {
        WalletItem walletItem;
        WalletHandler walletHandler;
        class_1799 wallet;
        class_1792 class_17922;
        class_1799 stack = item.method_6983();
        if (MoneyUtil.isCoin(stack.method_7909(), false) && (class_17922 = (wallet = (walletHandler = WalletHandler.getWallet(player)).getWallet()).method_7909()) instanceof WalletItem && WalletItem.CanPickup(walletItem = (WalletItem)class_17922)) {
            class_1799 change = WalletItem.PickupCoin(wallet, stack);
            item.method_6979(change);
        }
    }

    private static boolean onBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IOwnableBlock) {
            IOwnableBlock block = (IOwnableBlock)class_22482;
            return block.canBreak(player, (class_1936)world, pos, state);
        }
        return true;
    }

    private static void onPlayerDeath(class_1309 entity, class_1282 damage) {
        class_1657 player;
        if (entity.method_37908().field_9236) {
            return;
        }
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_7325()) {
            if (LCTrinketsAPI.isValid((class_1309)player)) {
                return;
            }
            WalletHandler walletHandler = WalletHandler.getWallet(player);
            class_1799 walletStack = walletHandler.getWallet();
            if (walletStack.method_7960()) {
                return;
            }
            boolean keepWallet = player.method_37908().method_8450().method_8355(class_1928.field_19389) || player.method_37908().method_8450().method_8355(ModGameRules.KEEP_WALLET);
            int coinDropPercent = MathUtil.clamp(player.method_37908().method_8450().method_8356(ModGameRules.COIN_DROP_PERCENT), 0, 100);
            if (keepWallet && coinDropPercent <= 0) {
                return;
            }
            if (keepWallet) {
                EventListener.spawnWalletDrops(player, walletStack, coinDropPercent);
            } else {
                EventListener.spawnDrop(player, walletStack);
                walletHandler.setWallet(class_1799.field_8037);
            }
        }
    }

    private static void spawnDrop(class_1657 player, class_1799 stack) {
        class_1542 item = new class_1542(player.method_37908(), player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, stack);
        player.method_37908().method_8649((class_1297)item);
    }

    public static void spawnWalletDrops(class_1657 player, class_1799 walletStack, int coinDropPercent) {
        double coinPercentage = MathUtil.clamp((double)coinDropPercent / 100.0, 0.0, 1.0);
        class_2371<class_1799> walletList = WalletItem.getWalletInventory(walletStack);
        long walletContents = new CoinValue(walletList).getRawValue();
        long droppedAmount = (long)((double)walletContents * coinPercentage);
        if (droppedAmount < 1L) {
            return;
        }
        class_1277 walletInventory = InventoryUtil.buildInventory(walletList);
        long extra = MoneyUtil.takeObjectsOfValue(droppedAmount, (class_1263)walletInventory, true);
        if (extra < 0L) {
            List<class_1799> extraCoins = MoneyUtil.getCoinsOfValue(-extra);
            for (class_1799 extraCoin : extraCoins) {
                class_1799 coinStack = InventoryUtil.TryPutItemStack((class_1263)walletInventory, extraCoin);
                if (coinStack.method_7960()) continue;
                EventListener.spawnDrop(player, coinStack);
            }
        }
        WalletItem.putWalletInventory(walletStack, InventoryUtil.buildList((class_1263)walletInventory));
        List<class_1799> coinsOfValue = MoneyUtil.getCoinsOfValue(droppedAmount);
        for (class_1799 coinStack : coinsOfValue) {
            while (!coinStack.method_7960()) {
                EventListener.spawnDrop(player, coinStack.method_7971(1));
            }
        }
    }
}

