/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class IconAndButtonUtil {
    public static final class_2960 ICON_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/icons.png");
    public static final IconData ICON_TRADER = IconData.of((class_1935)ModItems.TRADING_CORE);
    public static final IconData ICON_TRADER_ALT = IconData.of(ICON_TEXTURE, 80, 0);
    public static final IconData ICON_STORAGE = IconData.of((class_1935)class_1802.field_8106);
    public static final IconData ICON_COLLECT_COINS = IconData.of(ICON_TEXTURE, 0, 0);
    public static final IconData ICON_STORE_COINS = IconData.of(ICON_TEXTURE, 16, 0);
    public static final IconData ICON_TRADE_RULES = IconData.of((class_1935)class_1802.field_8529);
    public static final IconData ICON_SETTINGS = IconData.of(ICON_TEXTURE, 32, 0);
    public static final IconData ICON_BACK = IconData.of(ICON_TEXTURE, 0, 16);
    public static final IconData ICON_LEFT = IconData.of(ICON_TEXTURE, 16, 16);
    public static final IconData ICON_RIGHT = IconData.of(ICON_TEXTURE, 32, 16);
    public static final IconData ICON_SHOW_LOGGER = IconData.of((class_1935)class_1802.field_8674);
    public static final IconData ICON_CLEAR_LOGGER = IconData.of(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991));
    private static final IconData ICON_CREATIVE_ON = IconData.of(ICON_TEXTURE, 48, 16);
    private static final IconData ICON_CREATIVE_OFF = IconData.of(ICON_TEXTURE, 64, 16);
    public static final IconData ICON_PERSISTENT_DATA = IconData.of(ICON_TEXTURE, 80, 16);
    public static final IconData ICON_TICKET = IconData.of((class_1935)ModItems.TICKET_MASTER);
    public static final IconData ICON_PAYGATE_ACTIVATE = IconData.of((class_1935)class_1802.field_8725);
    private static final IconData ICON_INTERFACE_ON = IconData.of((class_1935)class_1802.field_8530);
    private static final IconData ICON_INTERFACE_OFF = IconData.of((class_1935)class_1802.field_8810);
    public static final IconData ICON_PLUS = IconData.of(ICON_TEXTURE, 0, 32);
    public static final IconData ICON_X = IconData.of(ICON_TEXTURE, 16, 32);
    public static final IconData ICON_WHITELIST = IconData.of(ICON_TEXTURE, 32, 32);
    public static final IconData ICON_BLACKLIST = IconData.of(ICON_TEXTURE, 48, 32);
    public static final IconData ICON_COUNT = IconData.of(ICON_TEXTURE, 64, 32);
    public static final IconData ICON_COUNT_PLAYER = IconData.of(ICON_TEXTURE, 80, 32);
    public static final IconData ICON_TIMED_SALE = IconData.of((class_1935)class_1802.field_8557);
    public static final IconData ICON_DISCOUNT_LIST = IconData.of(ICON_TEXTURE, 96, 32);
    public static final IconData ICON_FREE_SAMPLE = IconData.of(ICON_TEXTURE, 112, 32);
    public static final IconData ICON_PRICE_FLUCTUATION = IconData.of(ICON_TEXTURE, 128, 32);
    public static final IconData ICON_TRADELIST = IconData.of(ICON_TEXTURE, 48, 0);
    public static final IconData ICON_MODE_DISABLED = IconData.of((class_1935)class_1802.field_8077);
    public static final IconData ICON_MODE_REDSTONE_OFF = IconData.of(ICON_TEXTURE, 64, 0);
    public static final IconData ICON_MODE_REDSTONE = IconData.of((class_1935)class_1802.field_8530);
    public static final IconData ICON_MODE_ALWAYS_ON = IconData.of((class_1935)class_1802.field_8793);
    public static final IconData ICON_CHECKMARK = IconData.of(ICON_TEXTURE, 0, 48);
    public static final IconData ICON_ONLINEMODE_TRUE = IconData.of((class_1935)class_1802.field_8575);
    public static final IconData ICON_ONLINEMODE_FALSE = ICON_CHECKMARK;
    public static final SimpleTooltip TOOLTIP_TRADER = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.opentrades"));
    public static final SimpleTooltip TOOLTIP_STORAGE = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.openstorage"));
    public static final String TOOLTIP_COLLECT_COINS = "tooltip.lightmanscurrency.trader.collectcoins";
    public static final SimpleTooltip TOOLTIP_STORE_COINS = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.storecoins"));
    public static final SimpleTooltip TOOLTIP_BACK_TO_TERMINAL = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.universaltrader.back"));
    public static final class_2561 TOOLTIP_SHOW_LOGGER = class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.log.show");
    public static final class_2561 TOOLTIP_HIDE_LOGGER = class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.log.hide");
    public static final SimpleTooltip TOOLTIP_CLEAR_LOGGER = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.log.clear"));
    public static final SimpleTooltip TOOLTIP_TRADE_RULES = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.traderules"));
    public static final class_2561 TOOLTIP_TRADE_RULES_TRADER = class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.traderules.trader");
    public static final class_2561 TOOLTIP_TRADE_RULES_TRADE = class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.traderules.trade");
    public static final SimpleTooltip TOOLTIP_OPEN_SETTINGS = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.settings"));
    public static final class_2561 TOOLTIP_CREATIVE_ENABLE = class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.creative.enable");
    public static final class_2561 TOOLTIP_CREATIVE_DISABLE = class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.creative.disable");
    public static final class_2561 TOOLTIP_INTERFACE_ENABLE = class_2561.method_43471((String)"tooltip.lightmanscurrency.interface.enable");
    public static final class_2561 TOOLTIP_INTERFACE_DISABLE = class_2561.method_43471((String)"tooltip.lightmanscurrency.interface.disable");
    public static final SimpleTooltip TOOLTIP_PERSISTENT_TRADER = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.persistent.add.trader"));
    public static final SimpleTooltip TOOLTIP_PERSISTENT_AUCTION = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.persistent.add.auction"));
    public static final SimpleTooltip TOOLTIP_PAIR_TICKET = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.paygate.setticket"));
    public static final SimpleTooltip TOOLTIP_PAYGATE_ACTIVATE = new SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.paygate.paybutton"));

    public static Function<IconButton, IconData> ICON_CREATIVE(Supplier<Boolean> isCreative) {
        return b -> {
            boolean creative = b.method_37303() ? !((Boolean)isCreative.get()).booleanValue() : (Boolean)isCreative.get();
            return creative ? ICON_CREATIVE_ON : ICON_CREATIVE_OFF;
        };
    }

    public static Supplier<IconData> ICON_INTERFACE_ACTIVE(Supplier<Boolean> isActive) {
        return () -> (Boolean)isActive.get() != false ? ICON_INTERFACE_ON : ICON_INTERFACE_OFF;
    }

    public static IconData GetIcon(TraderInterfaceBlockEntity.ActiveMode mode) {
        switch (mode) {
            case DISABLED: {
                return ICON_MODE_DISABLED;
            }
            case REDSTONE_OFF: {
                return ICON_MODE_REDSTONE_OFF;
            }
            case REDSTONE_ONLY: {
                return ICON_MODE_REDSTONE;
            }
            case ALWAYS_ON: {
                return ICON_MODE_ALWAYS_ON;
            }
        }
        return IconData.of((class_1935)class_1802.field_8511);
    }

    public static IconButton traderButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_TRADER, (Supplier<class_7919>)TOOLTIP_TRADER);
    }

    public static IconButton storageButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_STORAGE, (Supplier<class_7919>)TOOLTIP_STORAGE);
    }

    public static IconButton storageButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> visiblityCheck) {
        IconButton button = IconAndButtonUtil.storageButton(x, y, pressable);
        button.setVisiblityCheck(visiblityCheck);
        return button;
    }

    public static IconButton collectCoinButton(int x, int y, class_4185.class_4241 pressable, class_1657 player, Supplier<TraderData> traderSource) {
        IconButton button = new IconButton(x, y, pressable, ICON_COLLECT_COINS, (Supplier<class_7919>)new AdditiveTooltip(TOOLTIP_COLLECT_COINS, () -> new Object[]{((TraderData)traderSource.get()).getStoredMoney().getString()}));
        button.setVisiblityCheck(() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader == null) {
                return false;
            }
            return trader.hasPermission(player, "collectCoins") && !trader.hasBankAccount();
        });
        button.setActiveCheck(() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader == null) {
                return false;
            }
            return trader.getInternalStoredMoney().getRawValue() > 0L;
        });
        return button;
    }

    public static IconButton collectCoinButtonAlt(int x, int y, class_4185.class_4241 pressable, Supplier<Object> storedCoinTextSource) {
        return new IconButton(x, y, pressable, ICON_COLLECT_COINS, (Supplier<class_7919>)new AdditiveTooltip(TOOLTIP_COLLECT_COINS, () -> new Object[]{storedCoinTextSource.get()}));
    }

    public static IconButton storeCoinButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_STORE_COINS, (Supplier<class_7919>)TOOLTIP_STORE_COINS);
    }

    public static IconButton leftButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_LEFT);
    }

    public static IconButton rightButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_RIGHT);
    }

    public static IconButton backToTerminalButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_BACK, (Supplier<class_7919>)TOOLTIP_BACK_TO_TERMINAL);
    }

    public static IconButton backToTerminalButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> visibilityCheck) {
        IconButton button = new IconButton(x, y, pressable, ICON_BACK, (Supplier<class_7919>)TOOLTIP_BACK_TO_TERMINAL);
        button.setVisiblityCheck(visibilityCheck);
        return button;
    }

    public static IconButton showLoggerButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> isLoggerVisible) {
        return new IconButton(x, y, pressable, ICON_SHOW_LOGGER, (Supplier<class_7919>)new ToggleTooltip(isLoggerVisible, TOOLTIP_HIDE_LOGGER, TOOLTIP_SHOW_LOGGER));
    }

    public static IconButton clearLoggerButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_CLEAR_LOGGER, (Supplier<class_7919>)TOOLTIP_CLEAR_LOGGER);
    }

    public static IconButton tradeRuleButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_TRADE_RULES, (Supplier<class_7919>)TOOLTIP_TRADE_RULES);
    }

    public static IconButton tradeRuleButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> isTradeSelected) {
        return new IconButton(x, y, pressable, ICON_TRADE_RULES, (Supplier<class_7919>)new ToggleTooltip(isTradeSelected, TOOLTIP_TRADE_RULES_TRADE, TOOLTIP_TRADE_RULES_TRADER));
    }

    public static IconButton openSettingsButton(int x, int y, class_4185.class_4241 pressable) {
        return new IconButton(x, y, pressable, ICON_SETTINGS, (Supplier<class_7919>)TOOLTIP_OPEN_SETTINGS);
    }

    public static IconButton creativeToggleButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> isCreative) {
        return new IconButton(x, y, pressable, IconAndButtonUtil.ICON_CREATIVE(isCreative), (Supplier<class_7919>)new ToggleTooltip(isCreative, TOOLTIP_CREATIVE_DISABLE, TOOLTIP_CREATIVE_ENABLE));
    }

    public static IconButton interfaceActiveToggleButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> isActive) {
        return new IconButton(x, y, pressable, IconAndButtonUtil.ICON_INTERFACE_ACTIVE(isActive), (Supplier<class_7919>)new ToggleTooltip(isActive, TOOLTIP_INTERFACE_DISABLE, TOOLTIP_INTERFACE_ENABLE));
    }

    public static PlainButton quickInsertButton(int x, int y, class_4185.class_4241 pressable) {
        return new PlainButton(x, y, 10, 10, pressable, TraderScreen.GUI_TEXTURE, 224, 0);
    }

    public static PlainButton quickExtractButton(int x, int y, class_4185.class_4241 pressable) {
        return new PlainButton(x, y, 10, 10, pressable, TraderScreen.GUI_TEXTURE, 234, 0);
    }

    public static PlainButton checkmarkButton(int x, int y, class_4185.class_4241 pressable, Supplier<Boolean> isActive) {
        return new PlainButton(x, y, 10, 10, pressable, TraderSettingsScreen.GUI_TEXTURE, () -> Pair.of((Object)10, (Object)((Boolean)isActive.get() != false ? 200 : 220)));
    }

    public static DropdownWidget interactionTypeDropdown(int x, int y, int width, class_327 font, TraderInterfaceBlockEntity.InteractionType currentlySelected, Consumer<Integer> onSelect, Function<class_4185, class_4185> addButton, List<TraderInterfaceBlockEntity.InteractionType> blacklist) {
        ArrayList<class_2561> options = new ArrayList<class_2561>();
        for (int i = 0; i < TraderInterfaceBlockEntity.InteractionType.size(); ++i) {
            options.add(TraderInterfaceBlockEntity.InteractionType.fromIndex(i).getDisplayText());
        }
        return new DropdownWidget(x, y, width, font, currentlySelected.index, onSelect, index -> !blacklist.contains((Object)TraderInterfaceBlockEntity.InteractionType.fromIndex(index)), addButton, options);
    }

    public static void renderButtonTooltips(class_332 gui, class_327 font, int mouseX, int mouseY, List<? extends Object> widgets) {
        for (Object object : widgets) {
            class_7919 t;
            class_4185 button;
            if (!(object instanceof class_4185) || !(button = (class_4185)object).method_25405((double)mouseX, (double)mouseY) || (t = button.method_51254()) == null) continue;
            gui.method_51447(font, t.method_47405(class_310.method_1551()), mouseX, mouseY);
        }
    }

    public static class SimpleTooltip
    extends BaseTooltip {
        private final class_2561 tooltip;

        public SimpleTooltip(class_2561 tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        protected class_2561 getTooltip() {
            return this.tooltip;
        }
    }

    public static class AdditiveTooltip
    extends BaseTooltip {
        private final String translationKey;
        private final Supplier<Object[]> inputSource;

        public AdditiveTooltip(String translationKey, Supplier<Object[]> inputSource) {
            this.translationKey = translationKey;
            this.inputSource = inputSource;
        }

        @Override
        protected class_2561 getTooltip() {
            return class_2561.method_43469((String)this.translationKey, (Object[])this.inputSource.get());
        }
    }

    public static class ToggleTooltip
    extends BaseTooltip {
        private final Supplier<Boolean> toggleSource;
        private final class_2561 trueTooltip;
        private final class_2561 falseTooltip;

        public ToggleTooltip(Supplier<Boolean> toggleSource, class_2561 trueTooltip, class_2561 falseTooltip) {
            this.toggleSource = toggleSource;
            this.trueTooltip = trueTooltip;
            this.falseTooltip = falseTooltip;
        }

        @Override
        protected class_2561 getTooltip() {
            return this.toggleSource.get() != false ? this.trueTooltip : this.falseTooltip;
        }
    }

    public static class ChangingTooltip
    extends BaseTooltip {
        private final Supplier<Integer> indicator;
        private final List<class_2561> tooltips;

        public ChangingTooltip(Supplier<Integer> indicator, class_2561 ... tooltips) {
            this.indicator = indicator;
            this.tooltips = Lists.newArrayList((Object[])tooltips);
        }

        @Override
        protected class_2561 getTooltip() {
            int index = this.indicator.get();
            return this.tooltips.get(MathUtil.clamp(index, 0, this.tooltips.size() - 1));
        }
    }

    public static class SuppliedTooltip
    extends BaseTooltip {
        private final Supplier<class_2561> tooltipSource;

        public SuppliedTooltip(Supplier<class_2561> tooltipSource) {
            this.tooltipSource = tooltipSource;
        }

        @Override
        protected class_2561 getTooltip() {
            return this.tooltipSource.get();
        }
    }

    private static abstract class BaseTooltip
    implements Supplier<class_7919> {
        private BaseTooltip() {
        }

        protected abstract class_2561 getTooltip();

        @Override
        public class_7919 get() {
            return class_7919.method_47407((class_2561)this.getTooltip());
        }
    }
}

