/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine.SlotMachineEntryClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_6382;

public class SlotMachineEntryEditWidget
extends class_339 {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 46;
    public final SlotMachineEntryClientTab tab;
    public final Supplier<Integer> entryIndex;
    private class_342 weightEdit;
    private PlainButton removeEntryButton;
    private int previousIndex = -1;
    private static final int ITEM_POSY = 22;

    public SlotMachineEntryEditWidget(ScreenPosition pos, SlotMachineEntryClientTab tab, Supplier<Integer> entryIndex) {
        this(pos.x, pos.y, tab, entryIndex);
    }

    public SlotMachineEntryEditWidget(int x, int y, SlotMachineEntryClientTab tab, Supplier<Integer> entryIndex) {
        super(x, y, 80, 46, (class_2561)EasyText.empty());
        this.tab = tab;
        this.entryIndex = entryIndex;
    }

    public void addChildren(Consumer<class_339> consumer) {
        this.weightEdit = new class_342(this.tab.font, this.method_46426() + this.tab.font.method_27525((class_5348)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.weight_label", new Object[0])), this.method_46427() + 10, 36, 10, (class_2561)EasyText.empty());
        consumer.accept((class_339)this.weightEdit);
        this.weightEdit.method_1880(4);
        this.removeEntryButton = new PlainButton(this.method_46426(), this.method_46427(), 10, 10, this::Remove, TraderScreen.GUI_TEXTURE, 234, 20);
        consumer.accept((class_339)this.removeEntryButton);
    }

    private SlotMachineEntry getEntry() {
        return this.tab.getEntry(this.entryIndex.get());
    }

    private void Remove(class_4185 button) {
        ((SlotMachineEntryTab)this.tab.commonTab).RemoveEntry(this.entryIndex.get());
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        SlotMachineEntry entry = this.getEntry();
        if (entry != null) {
            context.method_51439(this.tab.font, (class_2561)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.entry_label", this.entryIndex.get() + 1), this.method_46426() + 12, this.method_46427(), 0x404040, false);
            context.method_51439(this.tab.font, (class_2561)EasyText.translatable("gui.lightmanscurrency.trader.slot_machine.weight_label", new Object[0]), this.method_46426(), this.method_46427() + 12, 0x404040, false);
            for (int i = 0; i < 4; ++i) {
                if (i < entry.items.size() && !entry.items.get(i).method_7960()) {
                    ItemRenderUtil.drawItemStack(context, this.tab.font, entry.items.get(i), this.method_46426() + 18 * i, this.method_46427() + 22);
                    continue;
                }
                ItemRenderUtil.drawSlotBackground(context, this.method_46426() + 18 * i, this.method_46427() + 22, ItemTradeRestriction.BACKGROUND);
            }
        }
    }

    protected boolean method_25351(int button) {
        return button == 0 || button == 1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25361(mouseX, mouseY) && this.method_25351(button)) {
            boolean rightClick = button == 1;
            SlotMachineEntry entry = this.getEntry();
            if (entry != null) {
                int itemIndex;
                int entryIndex = this.entryIndex.get();
                class_1799 heldItem = this.tab.menu.method_34255();
                if (mouseY >= (double)(this.method_46427() + 22) && mouseY < (double)(this.method_46427() + 22 + 16) && (itemIndex = this.getItemSlotIndex(mouseX)) >= 0) {
                    if (itemIndex >= entry.items.size()) {
                        if (!heldItem.method_7960()) {
                            if (rightClick) {
                                ((SlotMachineEntryTab)this.tab.commonTab).AddEntryItem(entryIndex, heldItem.method_46651(1));
                            } else {
                                ((SlotMachineEntryTab)this.tab.commonTab).AddEntryItem(entryIndex, heldItem);
                            }
                            return true;
                        }
                    } else {
                        if (heldItem.method_7960()) {
                            if (rightClick) {
                                class_1799 newStack = entry.items.get(itemIndex).method_7972();
                                newStack.method_7934(1);
                                if (newStack.method_7960()) {
                                    ((SlotMachineEntryTab)this.tab.commonTab).RemoveEntryItem(entryIndex, itemIndex);
                                } else {
                                    ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, newStack);
                                }
                            } else {
                                ((SlotMachineEntryTab)this.tab.commonTab).RemoveEntryItem(entryIndex, itemIndex);
                            }
                            return true;
                        }
                        if (rightClick) {
                            class_1799 oldStack = entry.items.get(itemIndex);
                            if (InventoryUtil.ItemMatches(heldItem, oldStack)) {
                                class_1799 newStack = entry.items.get(itemIndex).method_7972();
                                if (newStack.method_7947() >= newStack.method_7914()) {
                                    return false;
                                }
                                newStack.method_7933(1);
                                ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, newStack);
                            } else {
                                ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, heldItem.method_46651(1));
                            }
                            return true;
                        }
                        ((SlotMachineEntryTab)this.tab.commonTab).EditEntryItem(entryIndex, itemIndex, heldItem);
                    }
                }
            }
        }
        return false;
    }

    private int getItemSlotIndex(double mouseX) {
        int x = (int)mouseX - this.method_46426();
        if (x < 0) {
            return -1;
        }
        int result = x / 18;
        return result >= 4 ? -1 : result;
    }

    public void tick() {
        TraderData traderData;
        SlotMachineEntry entry = this.getEntry();
        if (entry != null && (traderData = this.tab.menu.getTrader()) instanceof SlotMachineTraderData) {
            int newWeight;
            boolean hasPerms;
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            this.weightEdit.field_22764 = true;
            this.removeEntryButton.field_22764 = hasPerms = this.tab.menu.hasPermission("editTrades");
            this.weightEdit.method_1888(hasPerms);
            if (trader.areEntriesChanged()) {
                this.weightEdit.method_1852(Integer.toString(entry.getWeight()));
                return;
            }
            int thisIndex = this.entryIndex.get();
            if (thisIndex != this.previousIndex) {
                this.weightEdit.method_1852(Integer.toString(entry.getWeight()));
            }
            if ((newWeight = TextInputUtil.getIntegerValue(this.weightEdit, 1)) != entry.getWeight()) {
                ((SlotMachineEntryTab)this.tab.commonTab).ChangeEntryWeight(thisIndex, newWeight);
            }
            this.previousIndex = thisIndex;
        } else {
            this.removeEntryButton.field_22764 = false;
            this.weightEdit.field_22764 = false;
        }
        TextInputUtil.whitelistInteger(this.weightEdit, 1L, 1000L);
    }

    public void renderTooltips(class_332 context, int mouseX, int mouseY) {
        List<class_2561> tooltips = this.getTooltipText(mouseX, mouseY);
        if (tooltips != null) {
            context.method_51434(this.tab.font, tooltips, mouseX, mouseY);
        }
    }

    public List<class_2561> getTooltipText(int mouseX, int mouseY) {
        class_1799 item;
        int itemIndex;
        SlotMachineEntry entry = this.getEntry();
        if (entry != null && mouseY >= this.method_46427() + 22 && mouseY < this.method_46427() + 22 + 16 && (itemIndex = this.getItemSlotIndex(mouseX)) >= 0 && itemIndex < entry.items.size() && !(item = entry.items.get(itemIndex)).method_7960()) {
            return ItemRenderUtil.getTooltipFromItem(item);
        }
        return null;
    }

    protected void method_47399(class_6382 builder) {
    }
}

