/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.InteractionConsumer;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import org.jetbrains.annotations.Nullable;

public class TradeButton
extends class_4185 {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/trade.png");
    public static final class_4185.class_4241 NULL_PRESS = button -> {};
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 18;
    public static final int TEMPLATE_WIDTH = 212;
    public static final int BUTTON_HEIGHT = 18;
    private final Supplier<TradeData> tradeSource;
    private Supplier<TradeContext> contextSource;
    public boolean displayOnly = false;

    public TradeData getTrade() {
        return this.tradeSource.get();
    }

    public TradeContext getContext() {
        return this.contextSource.get();
    }

    public TradeButton(Supplier<TradeContext> contextSource, Supplier<TradeData> tradeSource, class_4185.class_4241 onPress) {
        super(0, 0, 0, 18, (class_2561)class_2561.method_43473(), onPress, field_40754);
        this.tradeSource = tradeSource;
        this.contextSource = contextSource;
        this.recalculateSize();
    }

    private void recalculateSize() {
        TradeData trade = this.getTrade();
        if (trade != null) {
            TradeContext context = this.getContext();
            this.field_22758 = trade.tradeButtonWidth(context);
        }
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TradeData trade = this.getTrade();
        if (trade == null) {
            return;
        }
        TradeContext context = this.getContext();
        this.recalculateSize();
        boolean isHovered = !context.isStorageMode && !this.displayOnly && this.field_22762;
        this.renderBackground(gui, isHovered);
        try {
            trade.renderAdditional((class_339)this, gui, mouseX, mouseY, context);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error on additional Trade Button rendering.", e);
        }
        if (trade.hasArrow(context)) {
            this.renderArrow(gui, trade.arrowPosition(context), isHovered);
        }
        this.renderAlert(gui, trade.alertPosition(context), trade.getAlertData(context));
        this.renderDisplays(gui, trade, context);
    }

    private void renderBackground(class_332 gui, boolean isHovered) {
        int xRend;
        if (this.field_22758 < 8) {
            LightmansCurrency.LogError("Cannot render a trade button that is less than 8 pixels wide!");
            return;
        }
        if (this.field_22763) {
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            gui.method_51422(0.5f, 0.5f, 0.5f, 1.0f);
        }
        int vOffset = isHovered ? 18 : 0;
        gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427(), 0, vOffset, 4, 18);
        for (int xOff = 4; xOff < this.field_22758 - 4; xOff += xRend) {
            xRend = Math.min(this.field_22758 - 4 - xOff, 204);
            gui.method_25302(GUI_TEXTURE, this.method_46426() + xOff, this.method_46427(), 4, vOffset, xRend, 18);
        }
        gui.method_25302(GUI_TEXTURE, this.method_46426() + this.field_22758 - 4, this.method_46427(), 208, vOffset, 4, 18);
    }

    private void renderArrow(class_332 gui, Pair<Integer, Integer> position, boolean isHovered) {
        if (this.field_22763) {
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            gui.method_51422(0.5f, 0.5f, 0.5f, 1.0f);
        }
        int vOffset = isHovered ? 18 : 0;
        gui.method_25302(GUI_TEXTURE, this.method_46426() + (Integer)position.getFirst(), this.method_46427() + (Integer)position.getSecond(), 212, vOffset, 22, 18);
    }

    private void renderAlert(class_332 gui, Pair<Integer, Integer> position, List<AlertData> alerts) {
        if (alerts == null || alerts.size() == 0) {
            return;
        }
        alerts.sort(AlertData::compare);
        alerts.get(0).setShaderColor(gui, this.field_22763 ? 1.0f : 0.5f);
        gui.method_25302(GUI_TEXTURE, this.method_46426() + (Integer)position.getFirst(), this.method_46427() + (Integer)position.getSecond(), 234, 0, 22, 18);
    }

    public void renderDisplays(class_332 gui, TradeData trade, TradeContext context) {
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(trade, context)) {
            ((DisplayEntry)display.getFirst()).render((class_339)this, gui, this.method_46426(), this.method_46427(), (DisplayData)display.getSecond());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(trade, context)) {
            ((DisplayEntry)display.getFirst()).render((class_339)this, gui, this.method_46426(), this.method_46427(), (DisplayData)display.getSecond());
        }
    }

    public void renderTooltips(class_332 gui, class_327 font, int mouseX, int mouseY) {
        if (!this.field_22764 || !this.method_25405(mouseX, mouseY)) {
            return;
        }
        TradeData trade = this.tradeSource.get();
        if (trade == null) {
            return;
        }
        TradeContext context = this.getContext();
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        this.tryAddTooltip(tooltips, trade.getAdditionalTooltips(context, mouseX - this.method_46426(), mouseY - this.method_46427()));
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(trade, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.method_46426(), this.method_46427(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).getTooltip());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(trade, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.method_46426(), this.method_46427(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).getTooltip());
        }
        if (this.isMouseOverAlert(mouseX, mouseY, trade, context) && trade.hasAlert(context)) {
            this.tryAddAlertTooltips(tooltips, trade.getAlertData(context));
        }
        TradeButton.DrawTooltip(gui, font, mouseX, mouseY, tooltips);
    }

    private void tryAddTooltip(List<class_2561> tooltips, @Nullable List<class_2561> add) {
        if (add == null) {
            return;
        }
        tooltips.addAll(add);
    }

    private void tryAddAlertTooltips(List<class_2561> tooltips, @Nullable List<AlertData> alerts) {
        if (alerts == null) {
            return;
        }
        alerts.sort(AlertData::compare);
        for (AlertData alert : alerts) {
            tooltips.add((class_2561)alert.getFormattedMessage());
        }
    }

    public void onInteractionClick(int mouseX, int mouseY, int button, InteractionConsumer consumer) {
        if (!this.field_22764 || !this.method_25405(mouseX, mouseY)) {
            return;
        }
        TradeData trade = this.tradeSource.get();
        if (trade == null) {
            return;
        }
        TradeContext context = this.getContext();
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(trade, context);
        for (int i = 0; i < inputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = inputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.method_46426(), this.method_46427(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonInputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        List<Pair<DisplayEntry, DisplayData>> outputDisplays = TradeButton.getOutputDisplayData(trade, context);
        for (int i = 0; i < outputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = outputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.method_46426(), this.method_46427(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonOutputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        consumer.onTradeButtonInteraction(context.getTrader(), trade, mouseX - this.method_46426(), mouseY - this.method_46427(), button);
    }

    private static void DrawTooltip(class_332 gui, class_327 font, int mouseX, int mouseY, List<class_2561> tooltips) {
        if (tooltips == null || tooltips.size() == 0) {
            return;
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_51434(font, tooltips, mouseX, mouseY);
    }

    public int isMouseOverInput(int mouseX, int mouseY) {
        TradeData trade = this.getTrade();
        if (trade == null) {
            return -1;
        }
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(trade, this.getContext());
        for (int i = 0; i < inputDisplays.size(); ++i) {
            if (!((DisplayEntry)inputDisplays.get(i).getFirst()).isMouseOver(this.method_46426(), this.method_46427(), (DisplayData)inputDisplays.get(i).getSecond(), mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    public int isMouseOverOutput(int mouseX, int mouseY) {
        TradeData trade = this.getTrade();
        if (trade == null) {
            return -1;
        }
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(trade, this.getContext());
        for (int i = 0; i < inputDisplays.size(); ++i) {
            if (!((DisplayEntry)inputDisplays.get(i).getFirst()).isMouseOver(this.method_46426(), this.method_46427(), (DisplayData)inputDisplays.get(i).getSecond(), mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    public boolean isMouseOverAlert(int mouseX, int mouseY, TradeData trade, TradeContext context) {
        Pair<Integer, Integer> position = trade.alertPosition(context);
        int left = this.method_46426() + (Integer)position.getFirst();
        int top = this.method_46427() + (Integer)position.getSecond();
        return mouseX >= left && mouseX < left + 22 && mouseY >= top && mouseY < top + 18;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getInputDisplayData(TradeData trade, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = trade.getInputDisplays(context);
        List<DisplayData> display = trade.inputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getOutputDisplayData(TradeData trade, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = trade.getOutputDisplays(context);
        List<DisplayData> display = trade.outputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public DisplayEntry getInputDisplay(int index) {
        TradeData trade = this.tradeSource.get();
        if (trade == null) {
            return DisplayEntry.EMPTY;
        }
        List<DisplayEntry> inputDisplays = trade.getInputDisplays(this.getContext());
        if (index < 0 || index >= inputDisplays.size()) {
            return DisplayEntry.EMPTY;
        }
        return inputDisplays.get(index);
    }

    private int inputDisplayCount() {
        TradeData trade = this.tradeSource.get();
        if (trade == null) {
            return 0;
        }
        return trade.getInputDisplays(this.getContext()).size();
    }

    public Pair<Integer, Integer> getInputDisplayPosition(int index) {
        TradeData trade = this.tradeSource.get();
        if (trade == null) {
            return Pair.of((Object)0, (Object)0);
        }
        int xPos = 0;
        int yPos = 0;
        int count = this.inputDisplayCount();
        if (index < 0 || index >= count) {
            return Pair.of((Object)0, (Object)0);
        }
        return Pair.of((Object)(this.method_46426() + xPos), (Object)(this.method_46427() + yPos));
    }

    protected boolean method_25351(int button) {
        if (this.getContext().isStorageMode || this.displayOnly) {
            return false;
        }
        return super.method_25351(button);
    }
}

