/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class ScrollBarWidget
extends class_339 {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/scroll.png");
    public static final int WIDTH = 8;
    public static final int KNOB_HEIGHT = 29;
    public static final int SMALL_KNOB_HEIGHT = 9;
    private final IScrollable scrollable;
    public boolean smallKnob = false;
    public boolean isDragging = false;

    private int getKnobHeight() {
        return this.smallKnob ? 9 : 29;
    }

    public ScrollBarWidget(int x, int y, int height, IScrollable scrollable) {
        super(x, y, 8, height, (class_2561)class_2561.method_43473());
        this.scrollable = scrollable;
    }

    public boolean visible() {
        return this.field_22764 && this.scrollable.getMaxScroll() > this.scrollable.getMinScroll();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible() && this.isDragging) {
            this.isDragging = false;
        }
        super.method_25394(gui, mouseX, mouseY, partialTicks);
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        int yPart;
        if (!this.visible()) {
            return;
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427(), 0, 0, 8, 8);
        for (int yOffset = 8; yOffset < this.field_22759 - 8; yOffset += yPart) {
            yPart = Math.min(this.field_22759 - 8 - yOffset, 240);
            gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427() + yOffset, 0, 8, 8, yPart);
        }
        gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427() + this.field_22759 - 8, 0, 248, 8, 8);
        int knobPosition = this.isDragging ? MathUtil.clamp(mouseY - this.method_46427() - this.getKnobHeight() / 2, 0, this.field_22759 - this.getKnobHeight()) : this.getNaturalKnobPosition();
        gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427() + knobPosition, this.smallKnob ? 16 : 8, 0, 8, this.getKnobHeight());
    }

    public void beforeWidgetRender(double mouseY) {
        if (this.isDragging) {
            this.dragKnob(mouseY);
        }
    }

    private int getNaturalKnobPosition() {
        int notches = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (notches <= 0) {
            return 0;
        }
        double spacing = (double)(this.field_22759 - this.getKnobHeight()) / (double)notches;
        int scroll = this.scrollable.currentScroll() - this.scrollable.getMinScroll();
        return (int)Math.round((double)scroll * spacing);
    }

    public void method_47399(class_6382 narrator) {
    }

    protected void dragKnob(double mouseY) {
        if (!this.visible()) {
            this.isDragging = false;
            return;
        }
        int scroll = this.getScrollFromMouse(mouseY);
        if (this.scrollable.currentScroll() != scroll) {
            this.scrollable.setScroll(scroll);
        }
    }

    private int getScrollFromMouse(double mouseY) {
        if ((mouseY -= (double)this.getKnobHeight() / 2.0) <= (double)this.method_46427()) {
            return this.scrollable.getMinScroll();
        }
        if (mouseY >= (double)(this.method_46427() + this.field_22759 - this.getKnobHeight())) {
            return this.scrollable.getMaxScroll();
        }
        int deltaScroll = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (deltaScroll <= 0) {
            return Integer.MIN_VALUE;
        }
        double sectionHeight = (double)(this.field_22759 - this.getKnobHeight()) / (double)deltaScroll;
        double yPos = (double)this.method_46427() - sectionHeight / 2.0;
        for (int i = this.scrollable.getMinScroll(); i <= this.scrollable.getMaxScroll(); ++i) {
            if (mouseY >= yPos && mouseY < yPos + sectionHeight) {
                return i;
            }
            yPos += sectionHeight;
        }
        LightmansCurrency.LogWarning("Error getting scroll from mouse position.");
        return this.scrollable.getMinScroll();
    }

    @Deprecated
    public void onMouseDragged(double mouseX, double mouseY, int button) {
    }

    public void onMouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        if (this.method_25405(mouseX, mouseY) && this.visible() && button == 0) {
            LightmansCurrency.LogDebug("Started dragging.");
            this.isDragging = true;
            this.dragKnob(mouseY);
        }
    }

    public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && this.visible() && button == 0) {
            this.dragKnob(mouseY);
            this.isDragging = false;
            LightmansCurrency.LogDebug("Stopped dragging.");
        }
    }

    public void method_25354(class_1144 soundManager) {
    }

    public static interface IScrollable {
        public int currentScroll();

        public void setScroll(int var1);

        default public int getMinScroll() {
            return 0;
        }

        public int getMaxScroll();

        default public boolean handleScrollWheel(double delta) {
            int scroll = this.currentScroll();
            if (delta < 0.0) {
                if (scroll < this.getMaxScroll()) {
                    this.setScroll(scroll + 1);
                    return true;
                }
            } else if (delta > 0.0 && scroll > 0) {
                this.setScroll(scroll - 1);
                return true;
            }
            return false;
        }

        default public boolean handleScrollWheel(double mouseX, double mouseY, double delta) {
            return this.handleScrollWheel(delta);
        }

        public static int calculateMaxScroll(int visibleCount, int totalCount) {
            return Math.max(0, totalCount - visibleCount);
        }

        public static int calculateMaxScroll(int visibleCount, int entriesPerScroll, int totalCount) {
            return Math.max(0, MathUtil.DivideByAndRoundUp(totalCount, entriesPerScroll) - visibleCount / entriesPerScroll);
        }
    }
}

