/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class CoinValueInput
extends class_339
implements ScrollBarWidget.IScrollable {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/coinvalueinput.png");
    public static final int HEIGHT = 69;
    public static final int DISPLAY_WIDTH = 176;
    public static final int MAX_BUTTON_COUNT = 6;
    private static final int SEGMENT_WIDTH = 20;
    private static final int SEGMENT_SPACING = 5;
    private static final int SEGMENT_TOTAL = 25;
    private final CoinValue.ValueType inputType;
    private final class_327 font;
    private final Consumer<CoinValue> onValueChanged;
    private final Consumer<class_339> addWidget;
    class_4185 buttonLeft;
    class_4185 buttonRight;
    private CoinValue coinValue;
    class_4185 toggleFree;
    private List<class_4185> increaseButtons;
    private List<class_4185> decreaseButtons;
    private class_2561 title;
    String lastInput = "";
    class_342 valueInput;
    String prefix;
    String postfix;
    public boolean allowFreeToggle = true;
    public boolean drawBG = true;
    public boolean locked = false;
    int scroll = 0;
    List<CoinData> coinData = new ArrayList<CoinData>();

    public void setTitle(class_2561 title) {
        this.title = title;
    }

    @Deprecated
    public CoinValueInput(int y, class_2561 title, CoinValue startingValue, @NotNull ICoinValueInput parent) {
        super((parent.getWidth() - 176) / 2, y, 176, 69, title);
        this.inputType = (CoinValue.ValueType)((Object)LCConfig.SERVER.coinValueInputType.get());
        this.title = title;
        this.coinValue = startingValue.copy();
        this.font = parent.getFont();
        this.onValueChanged = v -> parent.OnCoinValueChanged(this);
        this.addWidget = parent::addCustomWidget;
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.setPrefixAndPostfix();
        }
    }

    public CoinValueInput(int x, int y, class_2561 title, CoinValue startingValue, class_327 font, Consumer<CoinValue> onValueChanged, Consumer<class_339> addWidget) {
        super(x, y, 176, 69, title);
        this.inputType = (CoinValue.ValueType)((Object)LCConfig.SERVER.coinValueInputType.get());
        this.title = title;
        this.font = font;
        this.onValueChanged = onValueChanged;
        this.addWidget = addWidget;
        this.coinValue = startingValue.copy();
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.setPrefixAndPostfix();
        } else {
            this.getCoinData();
        }
    }

    private void setPrefixAndPostfix() {
        String format = (String)LCConfig.SERVER.valueFormat.get();
        String[] splitFormat = format.replace("{value}", "`").split("`", 2);
        if (splitFormat.length < 2) {
            if (format.startsWith("{value}")) {
                this.prefix = "";
                this.postfix = splitFormat[0];
            } else {
                this.prefix = splitFormat[0];
                this.postfix = "";
            }
        } else {
            this.prefix = splitFormat[0];
            this.postfix = splitFormat[1];
        }
    }

    private void getCoinData() {
        this.coinData = MoneyUtil.getAllData("main");
    }

    public void init() {
        this.toggleFree = new PlainButton(this.method_46426() + this.field_22758 - 14, this.method_46427() + 4, 10, 10, this::ToggleFree, GUI_TEXTURE, 40, 69);
        this.addWidget.accept((class_339)this.toggleFree);
        this.increaseButtons = new ArrayList<class_4185>();
        this.decreaseButtons = new ArrayList<class_4185>();
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            int buttonCount = this.coinData.size();
            if (buttonCount > 6) {
                buttonCount = 6;
                this.buttonLeft = new PlainButton(this.method_46426() + 4, this.method_46427() + 29, 10, 20, b -> this.scrollLeft(), GUI_TEXTURE, 50, 69);
                this.buttonLeft.field_22764 = false;
                this.addWidget.accept((class_339)this.buttonLeft);
                this.buttonRight = new PlainButton(this.method_46426() + this.field_22758 - 14, this.method_46427() + 29, 10, 20, b -> this.scrollRight(), GUI_TEXTURE, 60, 69);
                this.addWidget.accept((class_339)this.buttonRight);
            }
            int startX = this.getStartX();
            for (int x = 0; x < buttonCount; ++x) {
                PlainButton newButton = new PlainButton(startX + x * 25, this.method_46427() + 15, 20, 10, this::IncreaseButtonHit, GUI_TEXTURE, 0, 69);
                this.addWidget.accept((class_339)newButton);
                newButton.field_22763 = true;
                this.increaseButtons.add(newButton);
                newButton = new PlainButton(startX + x * 25, this.method_46427() + 53, 20, 10, this::DecreaseButtonHit, GUI_TEXTURE, 20, 69);
                this.addWidget.accept((class_339)newButton);
                newButton.field_22763 = false;
                this.decreaseButtons.add(newButton);
            }
        } else {
            int postfixWidth;
            int prefixWidth = this.font.method_1727(this.prefix);
            if (prefixWidth > 0) {
                prefixWidth += 2;
            }
            if ((postfixWidth = this.font.method_1727(this.postfix)) > 0) {
                postfixWidth += 2;
            }
            this.valueInput = new class_342(this.font, this.method_46426() + 10 + prefixWidth, this.method_46427() + 20, 156 - prefixWidth - postfixWidth, 20, (class_2561)class_2561.method_43473());
            this.addWidget.accept((class_339)this.valueInput);
        }
        this.tick();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.toggleFree.field_22764 = this.allowFreeToggle && this.field_22764;
        this.increaseButtons.forEach(button -> {
            button.field_22764 = this.field_22764;
        });
        this.decreaseButtons.forEach(button -> {
            button.field_22764 = this.field_22764;
        });
        if (this.valueInput != null) {
            this.valueInput.field_22764 = this.field_22764;
        }
        super.method_25394(gui, mouseX, mouseY, partialTicks);
    }

    protected void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.drawBG) {
            gui.method_25302(GUI_TEXTURE, this.method_46426(), this.method_46427(), 0, 0, 176, 69);
        }
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            this.validateScroll();
            int buttonCount = Math.min(this.coinData.size(), 6);
            int startX = this.getStartX();
            for (int x = 0; x < buttonCount; ++x) {
                ItemRenderUtil.drawItemStack(gui, this.font, new class_1799((class_1935)this.coinData.get((int)(x + this.scroll)).coinItem), startX + x * 25 + 2, this.method_46427() + 26);
                String countString = String.valueOf(this.coinValue.getEntry(this.coinData.get((int)(x + this.scroll)).coinItem));
                int width = this.font.method_1727(countString);
                gui.method_51433(this.font, countString, startX + x * 25 + 10 - width / 2, this.method_46427() + 43, 0x404040, false);
            }
        } else if (this.inputType == CoinValue.ValueType.VALUE) {
            gui.method_51433(this.font, this.prefix, this.method_46426() + 10, this.method_46427() + 26, 0xFFFFFF, false);
            int postfixWidth = this.font.method_1727(this.postfix);
            gui.method_51433(this.font, this.postfix, this.method_46426() + 176 - 10 - postfixWidth, this.method_46427() + 26, 0xFFFFFF, false);
        }
        int priceWidth = this.font.method_1727(this.coinValue.getString());
        int freeButtonOffset = this.allowFreeToggle ? 15 : 5;
        gui.method_51439(this.font, (class_2561)this.coinValue.getComponent(), this.method_46426() + this.field_22758 - freeButtonOffset - priceWidth, this.method_46427() + 5, 0x404040, false);
        int titleWidth = this.field_22758 - 7 - freeButtonOffset - priceWidth;
        gui.method_51439(this.font, TextRenderUtil.fitString(this.title, titleWidth), this.method_46426() + 8, this.method_46427() + 5, 0x404040, false);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int getStartX() {
        int buttonCount = Math.min(this.coinData.size(), 6);
        int space = this.field_22758 - buttonCount * 25 + 5;
        return this.method_46426() + space / 2;
    }

    public void tick() {
        boolean bl = this.toggleFree.field_22763 = !this.locked;
        if (this.inputType == CoinValue.ValueType.DEFAULT) {
            List<class_1792> coinItems = MoneyUtil.getAllCoins();
            for (int i = 0; i < this.decreaseButtons.size(); ++i) {
                this.decreaseButtons.get((int)i).field_22763 = i + this.scroll >= coinItems.size() ? false : this.coinValue.getEntry(coinItems.get(i + this.scroll)) > 0 && !this.locked;
            }
            for (class_4185 increaseButton : this.increaseButtons) {
                increaseButton.field_22763 = !this.coinValue.isFree() && !this.locked;
            }
            if (this.buttonLeft != null) {
                boolean bl2 = this.buttonLeft.field_22764 = this.scroll > 0;
            }
            if (this.buttonRight != null) {
                this.buttonRight.field_22764 = this.scroll < this.getMaxScroll();
            }
        } else if (this.valueInput != null) {
            this.valueInput.method_1865();
            boolean bl3 = this.valueInput.field_22763 = !this.coinValue.isFree() && !this.locked;
            if (!this.coinValue.isFree()) {
                TextInputUtil.whitelistFloat(this.valueInput);
                if (!this.lastInput.contentEquals(this.valueInput.method_1882())) {
                    this.lastInput = this.valueInput.method_1882();
                    this.coinValue = MoneyUtil.displayValueToCoinValue(this.getDisplayValue());
                    this.onValueChanged.accept(this.coinValue);
                }
            } else {
                this.valueInput.method_1852("");
                this.lastInput = this.valueInput.method_1882();
            }
        }
    }

    public void IncreaseButtonHit(class_4185 button) {
        if (!this.increaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.increaseButtons.indexOf(button);
        if (coinIndex < 0) {
            return;
        }
        if ((coinIndex += this.scroll) >= 0 && coinIndex < this.coinData.size()) {
            class_1792 coin = this.coinData.get((int)coinIndex).coinItem;
            int addAmount = 1;
            if (class_437.method_25442()) {
                addAmount = this.getLargeIncreaseAmount(coin);
            }
            if (class_437.method_25441()) {
                addAmount *= 10;
            }
            this.coinValue.addValue(coin, addAmount);
            this.onValueChanged.accept(this.coinValue);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the increasing button.");
        }
    }

    public void DecreaseButtonHit(class_4185 button) {
        if (!this.decreaseButtons.contains(button)) {
            return;
        }
        int coinIndex = this.decreaseButtons.indexOf(button);
        if (coinIndex < 0) {
            return;
        }
        if ((coinIndex += this.scroll) >= 0 && coinIndex < this.coinData.size()) {
            class_1792 coin = this.coinData.get((int)coinIndex).coinItem;
            int removeAmount = 1;
            if (class_437.method_25442()) {
                removeAmount = this.getLargeIncreaseAmount(coin);
            }
            if (class_437.method_25441()) {
                removeAmount *= 10;
            }
            this.coinValue.removeValue(coin, removeAmount);
            this.onValueChanged.accept(this.coinValue);
        } else {
            LightmansCurrency.LogError("Invalid index (" + coinIndex + ") found for the decreasing button.");
        }
    }

    private int getLargeIncreaseAmount(class_1792 coinItem) {
        Pair<class_1792, Integer> upwardConversion = MoneyUtil.getUpwardConversion(coinItem);
        if (upwardConversion != null) {
            return this.getLargeAmount(upwardConversion);
        }
        Pair<class_1792, Integer> downwardConversion = MoneyUtil.getDownwardConversion(coinItem);
        if (downwardConversion != null) {
            return this.getLargeAmount(downwardConversion);
        }
        return 10;
    }

    private int getLargeAmount(Pair<class_1792, Integer> conversion) {
        if ((Integer)conversion.getSecond() >= 64) {
            return 16;
        }
        if ((Integer)conversion.getSecond() > 10) {
            return 10;
        }
        if ((Integer)conversion.getSecond() > 5) {
            return 5;
        }
        return 2;
    }

    private void ToggleFree(class_4185 button) {
        this.coinValue.setFree(!this.coinValue.isFree());
        this.onValueChanged.accept(this.coinValue);
    }

    public CoinValue getCoinValue() {
        return this.coinValue;
    }

    public double getDisplayValue() {
        if (this.valueInput != null) {
            return TextInputUtil.getDoubleValue(this.valueInput);
        }
        return this.coinValue.getDisplayValue();
    }

    public void setCoinValue(CoinValue newValue) {
        this.coinValue = newValue.copy();
        if (this.inputType == CoinValue.ValueType.VALUE) {
            this.valueInput.method_1852(LCConfig.SERVER.formatValueOnly(newValue.getDisplayValue()));
        }
    }

    private void scrollLeft() {
        --this.scroll;
        this.validateScroll();
    }

    private void scrollRight() {
        ++this.scroll;
        this.validateScroll();
    }

    public void method_47399(class_6382 narrator) {
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = Math.max(newScroll, this.getMaxScroll());
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.coinData.size() - 6);
    }

    private void validateScroll() {
        this.scroll = MathUtil.clamp(this.scroll, 0, this.getMaxScroll());
    }

    @Deprecated
    public static interface ICoinValueInput {
        public <T extends class_364 & class_4068> T addCustomWidget(T var1);

        public int getWidth();

        public class_327 getFont();

        public void OnCoinValueChanged(CoinValueInput var1);
    }
}

