/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageDisbandTeam;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageEditTeam;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TeamOwnerTab
extends TeamTab {
    public static final TeamOwnerTab INSTANCE = new TeamOwnerTab();
    class_342 newOwnerName;
    class_4185 buttonChangeOwner;
    class_4185 buttonDisbandTeam;

    private TeamOwnerTab() {
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8674);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.team.owner");
    }

    @Override
    public boolean allowViewing(class_1657 player, Team team) {
        return team != null && team.isOwner(player);
    }

    @Override
    public void initTab() {
        if (this.getActiveTeam() == null) {
            this.getScreen().changeTab(0);
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        this.newOwnerName = screen.addRenderableTabWidget(new class_342(this.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (class_2561)class_2561.method_43473()));
        this.newOwnerName.method_1880(16);
        this.buttonChangeOwner = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 45, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.set_owner"), this::setNewOwner));
        this.buttonChangeOwner.field_22763 = false;
        this.buttonDisbandTeam = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 160, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.team.disband"), this::disbandTeam));
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.getActiveTeam() == null) {
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43469((String)"gui.button.lightmanscurrency.team.owner", (Object[])new Object[]{this.getActiveTeam().getOwner().getName(true)}), screen.guiLeft() + 20, screen.guiTop() + 10, 0x404040, false);
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonChangeOwner.method_25405((double)mouseX, (double)mouseY) || this.buttonDisbandTeam.method_25405((double)mouseX, (double)mouseY)) {
            gui.method_51438(this.getFont(), (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.warning").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        this.newOwnerName.method_1865();
        this.buttonChangeOwner.field_22763 = !this.newOwnerName.method_1882().isBlank();
    }

    @Override
    public void closeTab() {
    }

    private void setNewOwner(class_4185 button) {
        Team team = this.getActiveTeam();
        if (this.newOwnerName.method_1882().isBlank() || team == null) {
            return;
        }
        new CMessageEditTeam(team.getID(), this.newOwnerName.method_1882(), 10).sendToServer();
        this.newOwnerName.method_1852("");
    }

    private void disbandTeam(class_4185 button) {
        Team team = this.getActiveTeam();
        if (team == null) {
            return;
        }
        new CMessageDisbandTeam(team.getID()).sendToServer();
    }
}

