/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageCreateTeamBankAccount;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageSetTeamBankLimit;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TeamBankAccountTab
extends TeamTab {
    public static final TeamBankAccountTab INSTANCE = new TeamBankAccountTab();
    class_4185 buttonCreateBankAccount;
    class_4185 buttonToggleAccountLimit;

    private TeamBankAccountTab() {
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of(ModBlocks.COINPILE_GOLD);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.team.bank");
    }

    @Override
    public boolean allowViewing(class_1657 player, Team team) {
        return team != null && team.isOwner(player);
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.buttonCreateBankAccount = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.team.bank.create"), this::createBankAccount));
        this.buttonToggleAccountLimit = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 60, 160, 20, (class_2561)class_2561.method_43473(), this::toggleBankLimit));
        this.updateBankLimitText();
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.getActiveTeam() == null) {
            return;
        }
        TeamManagerScreen screen = this.getScreen();
        if (this.getActiveTeam() != null && this.getActiveTeam().hasBankAccount()) {
            gui.method_51439(this.getFont(), (class_2561)class_2561.method_43469((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{this.getActiveTeam().getBankAccount().getCoinStorage().getString("0")}), screen.guiLeft() + 20, screen.guiTop() + 46, 0x404040, false);
        }
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        if (this.getActiveTeam() == null) {
            return;
        }
        this.buttonCreateBankAccount.field_22763 = !this.getActiveTeam().hasBankAccount();
    }

    @Override
    public void closeTab() {
    }

    private void createBankAccount(class_4185 button) {
        if (this.getActiveTeam() == null || !this.getActiveTeam().isOwner(this.getPlayer())) {
            return;
        }
        this.getActiveTeam().createBankAccount(this.getPlayer());
        new CMessageCreateTeamBankAccount(this.getActiveTeam().getID()).sendToServer();
    }

    private void toggleBankLimit(class_4185 button) {
        if (this.getActiveTeam() == null || !this.getActiveTeam().isOwner(this.getPlayer())) {
            return;
        }
        int newLimit = Team.NextBankLimit(this.getActiveTeam().getBankLimit());
        this.getActiveTeam().changeBankLimit(this.getPlayer(), newLimit);
        new CMessageSetTeamBankLimit(this.getActiveTeam().getID(), newLimit).sendToServer();
        this.updateBankLimitText();
    }

    private void updateBankLimitText() {
        class_5250 message = class_2561.method_43469((String)"gui.button.lightmanscurrency.team.bank.limit", (Object[])new Object[]{class_2561.method_43471((String)("gui.button.lightmanscurrency.team.bank.limit." + this.getActiveTeam().getBankLimit()))});
        this.buttonToggleAccountLimit.method_25355((class_2561)message);
    }
}

