/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.settings.input;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class InputTab
extends SettingsTab {
    public static final InputTab INSTANCE = new InputTab();
    DirectionalSettingsWidget inputWidget;
    DirectionalSettingsWidget outputWidget;

    private InputTab() {
    }

    protected InputTraderData getInputTrader() {
        TraderData trader = this.getTrader();
        if (trader instanceof InputTraderData) {
            return (InputTraderData)trader;
        }
        return null;
    }

    protected boolean getInputSideValue(class_2350 side) {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.allowInputSide(side);
        }
        return false;
    }

    protected boolean getOutputSideValue(class_2350 side) {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.allowOutputSide(side);
        }
        return false;
    }

    protected ImmutableList<class_2350> getIgnoreList() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.ignoreSides;
        }
        return ImmutableList.of((Object)class_2350.field_11043, (Object)class_2350.field_11035, (Object)class_2350.field_11034, (Object)class_2350.field_11039, (Object)class_2350.field_11036, (Object)class_2350.field_11033);
    }

    public int getTextColor() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsTextColor();
        }
        return 0xD0D0D0;
    }

    @Override
    public int getColor() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsTabColor();
        }
        return 0xFFFFFF;
    }

    @Override
    @NotNull
    public IconData getIcon() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsTabIcon();
        }
        return IconData.of((class_1935)class_1802.field_8239);
    }

    @Override
    public class_5250 getTooltip() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsTabTooltip();
        }
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.iteminput");
    }

    public List<InputTabAddon> getAddons() {
        InputTraderData trader = this.getInputTrader();
        if (trader != null) {
            return trader.inputSettingsAddons();
        }
        return ImmutableList.of();
    }

    @Override
    public boolean canOpen() {
        return this.hasPermissions("changeExternalInputs");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.inputWidget = new DirectionalSettingsWidget(screen.guiLeft() + 20, screen.guiTop() + 25, this::getInputSideValue, this.getIgnoreList(), this::ToggleInputSide, screen::addRenderableTabWidget);
        this.outputWidget = new DirectionalSettingsWidget(screen.guiLeft() + 110, screen.guiTop() + 25, this::getOutputSideValue, this.getIgnoreList(), this::ToggleOutputSide, screen::addRenderableTabWidget);
        this.getAddons().forEach(a -> a.onInit(screen));
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.settings.iteminput.side"), screen.guiLeft() + 20, screen.guiTop() + 7, this.getTextColor(), false);
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.settings.itemoutput.side"), screen.guiLeft() + 110, screen.guiTop() + 7, this.getTextColor(), false);
        this.getAddons().forEach(a -> a.preRender(screen, gui, mouseX, mouseY, partialTicks));
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        this.inputWidget.renderTooltips(gui, mouseX, mouseY, this.getFont());
        this.outputWidget.renderTooltips(gui, mouseX, mouseY, this.getFont());
        this.getAddons().forEach(a -> a.postRender(screen, gui, mouseX, mouseY, partialTicks));
    }

    @Override
    public void tick() {
        TraderSettingsScreen screen = this.getScreen();
        this.inputWidget.tick();
        this.outputWidget.tick();
        this.getAddons().forEach(a -> a.tick(screen));
    }

    @Override
    public void closeTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.getAddons().forEach(a -> a.onClose(screen));
    }

    private void ToggleInputSide(class_2350 side) {
        class_2487 message = new class_2487();
        message.method_10556("SetInputSide", !this.getInputSideValue(side));
        message.method_10569("Side", side.method_10146());
        this.sendNetworkMessage(message);
    }

    private void ToggleOutputSide(class_2350 side) {
        class_2487 message = new class_2487();
        message.method_10556("SetOutputSide", !this.getOutputSideValue(side));
        message.method_10569("Side", side.method_10146());
        this.sendNetworkMessage(message);
    }
}

