/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core;

import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.server.messages.persistentdata.CMessageAddPersistentTrader;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageAddOrRemoveTrade;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class MainTab
extends SettingsTab {
    public static final MainTab INSTANCE = new MainTab();
    class_342 nameInput;
    class_4185 buttonSetName;
    class_4185 buttonResetName;
    PlainButton buttonToggleBankLink;
    IconButton buttonToggleCreative;
    class_4185 buttonAddTrade;
    class_4185 buttonRemoveTrade;
    class_4185 buttonSavePersistentTrader;
    class_342 persistentTraderIDInput;
    class_342 persistentTraderOwnerInput;

    private MainTab() {
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        TraderData trader = this.getTrader();
        this.nameInput = screen.addRenderableTabWidget(new class_342(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 25, 160, 20, (class_2561)class_2561.method_43473()));
        this.nameInput.method_1880(32);
        this.nameInput.method_1852(trader.getCustomName());
        this.buttonSetName = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 50, 74, 20, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.changename"), this::SetName));
        int n = screen.guiLeft();
        Objects.requireNonNull(screen);
        this.buttonResetName = screen.addRenderableTabWidget(new VanillaButton(n + 200 - 93, screen.guiTop() + 50, 74, 20, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.resetname"), this::ResetName));
        int n2 = screen.guiLeft() + 176;
        int n3 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonToggleCreative = screen.addRenderableTabWidget(IconAndButtonUtil.creativeToggleButton(n2, n3 + 200 - 30, this::ToggleCreative, () -> this.getTrader().isCreative()));
        int n4 = screen.guiLeft() + 166;
        int n5 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonAddTrade = screen.addRenderableTabWidget(new PlainButton(n4, n5 + 200 - 30, 10, 10, this::AddTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 200));
        int n6 = screen.guiLeft() + 166;
        int n7 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonRemoveTrade = screen.addRenderableTabWidget(new PlainButton(n6, n7 + 200 - 20, 10, 10, this::RemoveTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 220));
        this.buttonToggleBankLink = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 100, 10, 10, this::ToggleBankLink, TraderSettingsScreen.GUI_TEXTURE, 10, trader.getLinkedToBank() ? 200 : 220));
        this.buttonToggleBankLink.field_22764 = screen.hasPermission("bankLink");
        int n8 = screen.guiLeft() + 10;
        int n9 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.buttonSavePersistentTrader = screen.addRenderableTabWidget(new IconButton(n8, n9 + 200 - 30, this::SavePersistentTraderData, IconAndButtonUtil.ICON_PERSISTENT_DATA, (Supplier<class_7919>)IconAndButtonUtil.TOOLTIP_PERSISTENT_TRADER));
        this.buttonSavePersistentTrader.field_22764 = CommandLCAdmin.isAdminPlayer(this.getPlayer());
        int idWidth = this.getFont().method_27525((class_5348)class_2561.method_43471((String)"gui.lightmanscurrency.settings.persistent.id"));
        class_327 class_3272 = this.getFont();
        int n10 = screen.guiLeft() + 37 + idWidth;
        int n11 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.persistentTraderIDInput = screen.addRenderableTabWidget(new class_342(class_3272, n10, n11 + 200 - 30, 108 - idWidth, 18, (class_2561)class_2561.method_43473()));
        int ownerWidth = this.getFont().method_27525((class_5348)class_2561.method_43471((String)"gui.lightmanscurrency.settings.persistent.owner"));
        class_327 class_3273 = this.getFont();
        int n12 = screen.guiLeft() + 12 + ownerWidth;
        int n13 = screen.guiTop();
        Objects.requireNonNull(screen);
        this.persistentTraderOwnerInput = screen.addRenderableTabWidget(new class_342(class_3273, n12, n13 + 200 - 55, 178 - ownerWidth, 18, (class_2561)class_2561.method_43473()));
        this.tick();
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        TraderData trader = this.getScreen().getTrader();
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.customname"), screen.guiLeft() + 20, screen.guiTop() + 15, 0x404040, false);
        if (screen.hasPermission("bankLink")) {
            gui.method_51439(this.getFont(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.settings.banklink"), screen.guiLeft() + 32, screen.guiTop() + 101, 0x404040, false);
        }
        if (CommandLCAdmin.isAdminPlayer(this.getScreen().getPlayer()) && trader != null) {
            String count = String.valueOf(trader.getTradeCount());
            int width = this.getFont().method_1727(count);
            class_327 class_3272 = this.getFont();
            int n = screen.guiLeft() + 164 - width;
            int n2 = screen.guiTop();
            Objects.requireNonNull(screen);
            gui.method_51433(class_3272, count, n, n2 + 200 - 25, 0x404040, false);
            if (this.persistentTraderIDInput != null) {
                class_327 class_3273 = this.getFont();
                class_5250 class_52502 = class_2561.method_43471((String)"gui.lightmanscurrency.settings.persistent.id");
                int n3 = screen.guiLeft() + 35;
                int n4 = screen.guiTop();
                Objects.requireNonNull(screen);
                gui.method_51439(class_3273, (class_2561)class_52502, n3, n4 + 200 - 25, 0xFFFFFF, false);
                class_327 class_3274 = this.getFont();
                class_5250 class_52503 = class_2561.method_43471((String)"gui.lightmanscurrency.settings.persistent.owner");
                int n5 = screen.guiLeft() + 10;
                int n6 = screen.guiTop();
                Objects.requireNonNull(screen);
                gui.method_51439(class_3274, (class_2561)class_52503, n5, n6 + 200 - 50, 0xFFFFFF, false);
            }
        }
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        if (this.buttonAddTrade.method_25405((double)mouseX, (double)mouseY)) {
            gui.method_51438(this.getFont(), (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.creative.addTrade"), mouseX, mouseY);
        } else if (this.buttonRemoveTrade.method_25405((double)mouseX, (double)mouseY)) {
            gui.method_51438(this.getFont(), (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.creative.removeTrade"), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        boolean canLinkAccount;
        boolean isAdmin;
        boolean canChangeName = this.getScreen().hasPermission("changeName");
        this.nameInput.method_1888(canChangeName);
        this.nameInput.method_1865();
        TraderData trader = this.getTrader();
        this.buttonSetName.field_22763 = !this.nameInput.method_1882().contentEquals(trader.getCustomName());
        this.buttonSetName.field_22764 = canChangeName;
        this.buttonResetName.field_22763 = trader.hasCustomName();
        this.buttonResetName.field_22764 = canChangeName;
        this.buttonToggleCreative.field_22764 = isAdmin = CommandLCAdmin.isAdminPlayer(this.getPlayer());
        if (this.buttonToggleCreative.field_22764) {
            this.buttonAddTrade.field_22764 = true;
            this.buttonAddTrade.field_22763 = trader.getTradeCount() < 32;
            this.buttonRemoveTrade.field_22764 = true;
            this.buttonRemoveTrade.field_22763 = trader.getTradeCount() > 1;
        } else {
            this.buttonAddTrade.field_22764 = false;
            this.buttonRemoveTrade.field_22764 = false;
        }
        this.buttonToggleBankLink.field_22764 = canLinkAccount = this.getScreen().hasPermission("bankLink");
        if (canLinkAccount) {
            this.buttonToggleBankLink.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, trader.getLinkedToBank() ? 200 : 220);
            boolean bl = this.buttonToggleBankLink.field_22763 = trader.canLinkBankAccount() || trader.getLinkedToBank();
        }
        if (this.buttonSavePersistentTrader != null) {
            this.buttonSavePersistentTrader.field_22764 = isAdmin;
            this.buttonSavePersistentTrader.field_22763 = trader.hasValidTrade();
        }
        if (this.persistentTraderIDInput != null) {
            this.persistentTraderIDInput.field_22764 = isAdmin;
            this.persistentTraderIDInput.method_1865();
        }
        if (this.persistentTraderOwnerInput != null) {
            this.persistentTraderOwnerInput.field_22764 = isAdmin;
            this.persistentTraderOwnerInput.method_1865();
        }
    }

    @Override
    public void closeTab() {
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)ModItems.TRADING_CORE);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.name");
    }

    private void SetName(class_4185 button) {
        TraderData trader = this.getTrader();
        String customName = trader.getCustomName();
        if (!customName.contentEquals(this.nameInput.method_1882())) {
            class_2487 message = new class_2487();
            message.method_10582("ChangeName", this.nameInput.method_1882());
            this.sendNetworkMessage(message);
        }
    }

    private void ResetName(class_4185 button) {
        this.nameInput.method_1852("");
        this.SetName(button);
    }

    private void ToggleCreative(class_4185 button) {
        TraderData trader = this.getTrader();
        class_2487 message = new class_2487();
        message.method_10556("MakeCreative", !trader.isCreative());
        this.sendNetworkMessage(message);
    }

    private void ToggleBankLink(class_4185 button) {
        TraderData trader = this.getTrader();
        class_2487 message = new class_2487();
        message.method_10556("LinkToBankAccount", !trader.getLinkedToBank());
        this.sendNetworkMessage(message);
    }

    private void AddTrade(class_4185 button) {
        new CMessageAddOrRemoveTrade(this.getTrader().getID(), true).sendToServer();
    }

    private void RemoveTrade(class_4185 button) {
        new CMessageAddOrRemoveTrade(this.getTrader().getID(), false).sendToServer();
    }

    private void SavePersistentTraderData(class_4185 button) {
        TraderData trader = this.getScreen().getTrader();
        if (trader != null && trader.canMakePersistent()) {
            new CMessageAddPersistentTrader(trader.getID(), this.persistentTraderIDInput.method_1882(), this.persistentTraderOwnerInput.method_1882()).sendToServer();
        }
    }
}

