/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ItemStorageClientTab
extends TraderStorageClientTab<ItemStorageTab>
implements ScrollListener.IScrollListener,
ScrollBarWidget.IScrollable {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 8;
    private static final int ROWS = 5;
    int scroll = 0;
    ScrollBarWidget scrollBar;

    public ItemStorageClientTab(TraderStorageScreen screen, ItemStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.storage");
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        this.scrollBar = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 13 + 144, this.screen.getGuiTop() + 17, 90, this));
        this.screen.addTabListener(new ScrollListener(this.screen.getGuiLeft(), this.screen.getGuiTop(), this.screen.getImageWidth(), 118, this));
        this.screen.addRenderableTabWidget(IconAndButtonUtil.quickInsertButton(this.screen.getGuiLeft() + 22, this.screen.getGuiTop() + 17 + 90 + 8, b -> ((ItemStorageTab)this.commonTab).quickTransfer(0)));
        this.screen.addRenderableTabWidget(IconAndButtonUtil.quickExtractButton(this.screen.getGuiLeft() + 34, this.screen.getGuiTop() + 17 + 90 + 8, b -> ((ItemStorageTab)this.commonTab).quickTransfer(1)));
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.storage"), this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, 0x404040, false);
        this.scrollBar.beforeWidgetRender(mouseY);
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            this.validateScroll();
            int index = this.scroll * 8;
            TraderItemStorage storage = trader.getStorage();
            int hoverSlot = this.isMouseOverSlot(mouseX, mouseY) + this.scroll * 8;
            for (int y = 0; y < 5; ++y) {
                int n = this.screen.getGuiTop() + 17 + y * 18;
                for (int x = 0; x < 8; ++x) {
                    int xPos = this.screen.getGuiLeft() + 13 + x * 18;
                    gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                    gui.method_25302(TraderScreen.GUI_TEXTURE, xPos, n, 206, 0, 18, 18);
                    if (index < storage.getSlotCount()) {
                        ItemRenderUtil.drawItemStack(gui, this.font, storage.getContents().get(index), xPos + 1, n + 1, this.getCountText(storage.getContents().get(index)));
                    }
                    if (index == hoverSlot) {
                        class_465.method_33285((class_332)gui, (int)(xPos + 1), (int)(n + 1), (int)0);
                    }
                    ++index;
                }
            }
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            for (class_1735 class_17352 : ((ItemStorageTab)this.commonTab).getSlots()) {
                gui.method_25302(TraderScreen.GUI_TEXTURE, this.screen.getGuiLeft() + class_17352.field_7873 - 1, this.screen.getGuiTop() + class_17352.field_7872 - 1, 206, 0, 18, 18);
            }
        }
    }

    private String getCountText(class_1799 stack) {
        int count = stack.method_7947();
        if (count <= 1) {
            return null;
        }
        if (count >= 1000) {
            Object countText = String.valueOf(count / 1000);
            if (count % 1000 / 100 > 0) {
                countText = (String)countText + "." + count % 1000 / 100;
            }
            return (String)countText + "k";
        }
        return String.valueOf(count);
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        TraderItemStorage storage;
        int hoveredSlot;
        if (this.menu.getTrader() instanceof ItemTraderData && this.menu.method_34255().method_7960() && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0 && (hoveredSlot += this.scroll * 8) < (storage = ((ItemTraderData)this.menu.getTrader()).getStorage()).getContents().size()) {
            class_1799 stack = storage.getContents().get(hoveredSlot);
            List<class_2561> tooltip = ItemRenderUtil.getTooltipFromItem(stack);
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.itemstorage", (Object[])new Object[]{stack.method_7947()}));
            if (stack.method_7947() >= 64) {
                if (stack.method_7947() % 64 == 0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.itemstorage.stacks.single", (Object[])new Object[]{stack.method_7947() / 64}));
                } else {
                    tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.itemstorage.stacks.multi", (Object[])new Object[]{stack.method_7947() / 64, stack.method_7947() % 64}));
                }
            }
            gui.method_51434(this.font, tooltip, mouseX, mouseY);
        }
    }

    private void validateScroll() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < 8 && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(leftEdge + x * 18)) || !(mouseX < (double)(leftEdge + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 5 && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(topEdge + y * 18)) || !(mouseY < (double)(topEdge + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 8 + foundColumn;
    }

    private int totalStorageSlots() {
        if (this.menu.getTrader() instanceof ItemTraderData) {
            return ((ItemTraderData)this.menu.getTrader()).getStorage().getContents().size();
        }
        return 0;
    }

    private boolean canScrollDown() {
        return this.totalStorageSlots() - this.scroll * 8 > 40;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getTrader() instanceof ItemTraderData && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0) {
            ((ItemStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 8, class_437.method_25442(), button == 0);
            return true;
        }
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 8 - 5 + 1, 0);
    }
}

