/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class AuctionStorageClientTab
extends TraderStorageClientTab<AuctionStorageTab>
implements ScrollListener.IScrollListener,
ScrollBarWidget.IScrollable {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 10;
    private static final int ROWS = 4;
    int scroll = 0;
    ScrollBarWidget scrollBar;
    class_4185 buttonCollectItems;
    IconButton buttonCollectMoney;

    public AuctionStorageClientTab(TraderStorageScreen screen, AuctionStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.auction.storage");
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        this.scrollBar = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 13 + 180, this.screen.getGuiTop() + 17, 72, this));
        this.buttonCollectItems = this.screen.addRenderableTabWidget(IconAndButtonUtil.quickExtractButton(this.screen.getGuiLeft() + 11, this.screen.getGuiTop() + 17 + 72 + 8, b -> ((AuctionStorageTab)this.commonTab).quickTransfer()));
        this.buttonCollectMoney = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + 25, this.screen.getGuiTop() + 118, b -> ((AuctionStorageTab)this.commonTab).collectCoins(), IconAndButtonUtil.ICON_COLLECT_COINS));
        this.screen.addTabListener(new ScrollListener(this.screen.getGuiLeft(), this.screen.getGuiTop(), this.screen.getImageWidth(), 118, this));
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.auction.storage"), this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, 0x404040, false);
        this.scrollBar.beforeWidgetRender(mouseY);
        if (this.menu.getTrader() instanceof AuctionHouseTrader) {
            this.validateScroll();
            int index = this.scroll * 10;
            AuctionPlayerStorage storage = ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player);
            if (storage != null) {
                List<class_1799> storedItems = storage.getStoredItems();
                int hoverSlot = this.isMouseOverSlot(mouseX, mouseY) + this.scroll * 10;
                for (int y = 0; y < 4 && index < storedItems.size(); ++y) {
                    int yPos = this.screen.getGuiTop() + 17 + y * 18;
                    for (int x = 0; x < 10 && index < storedItems.size(); ++index, ++x) {
                        int xPos = this.screen.getGuiLeft() + 13 + x * 18;
                        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                        gui.method_25302(TraderScreen.GUI_TEXTURE, xPos, yPos, 206, 0, 18, 18);
                        if (index < storedItems.size()) {
                            ItemRenderUtil.drawItemStack(gui, this.font, storedItems.get(index), xPos + 1, yPos + 1);
                        }
                        if (index != hoverSlot) continue;
                        class_465.method_33285((class_332)gui, (int)(xPos + 1), (int)(yPos + 1), (int)0);
                    }
                }
                if (storedItems.size() == 0) {
                    TextRenderUtil.drawCenteredMultilineText(gui, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.auction.storage.items.none"), this.screen.getGuiLeft() + 10, this.screen.getImageWidth() - 20, this.screen.getGuiTop() + 13 + 36, 0x404040);
                }
                boolean bl = this.buttonCollectItems.field_22763 = storedItems.size() > 0;
                if (storage.getStoredCoins().hasAny()) {
                    this.buttonCollectMoney.field_22763 = true;
                    gui.method_51439(this.font, (class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.auction.storage.money", (Object[])new Object[]{storage.getStoredCoins().getString("0")}), this.screen.getGuiLeft() + 50, this.screen.getGuiTop() + 118, 0x404040, false);
                } else {
                    this.buttonCollectMoney.field_22763 = false;
                    gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.auction.storage.money.none"), this.screen.getGuiLeft() + 50, this.screen.getGuiTop() + 118, 0x404040, false);
                }
            }
        }
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        AuctionPlayerStorage storage;
        int hoveredSlot;
        if (this.menu.getTrader() instanceof AuctionHouseTrader && this.menu.method_34255().method_7960() && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0 && (hoveredSlot += this.scroll * 10) < (storage = ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player)).getStoredItems().size()) {
            class_1799 stack = storage.getStoredItems().get(hoveredSlot);
            gui.method_51434(this.font, ItemRenderUtil.getTooltipFromItem(stack), mouseX, mouseY);
        }
    }

    private void validateScroll() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < 10 && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(leftEdge + x * 18)) || !(mouseX < (double)(leftEdge + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 4 && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(topEdge + y * 18)) || !(mouseY < (double)(topEdge + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 10 + foundColumn;
    }

    private int totalStorageSlots() {
        if (this.menu.getTrader() instanceof AuctionHouseTrader) {
            return ((AuctionHouseTrader)this.menu.getTrader()).getStorage(this.menu.player).getStoredItems().size();
        }
        return 0;
    }

    private boolean canScrollDown() {
        return this.totalStorageSlots() - this.scroll * 10 > 40;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getTrader() instanceof AuctionHouseTrader && (hoveredSlot = this.isMouseOverSlot(mouseX, mouseY)) >= 0) {
            ((AuctionStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 10, class_437.method_25442());
            return true;
        }
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 10 - 4 + 1, 0);
    }
}

