/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineLine;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineRenderBlock;
import io.github.lightman314.lightmanscurrency.common.menu.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5819;

public final class SlotMachineRenderer {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/slot_machine_overlay.png");
    private final SlotMachineScreen screen;
    private final SlotMachineMenu menu;
    private int animationTick = 0;
    private int restTick = 0;
    public final class_2371<SlotMachineLine> lines = class_2371.method_10211();
    private final List<SlotMachineRenderBlock> possibleBlocks = new ArrayList<SlotMachineRenderBlock>();
    private int totalWeight = 0;

    public class_327 getFont() {
        return this.screen.getFont();
    }

    private SlotMachineTraderData getTrader() {
        return this.menu.getTrader();
    }

    private class_5819 getRandom() {
        return this.menu.player.method_37908().field_9229;
    }

    public static int GetAnimationTime() {
        return Math.max((Integer)LCConfig.CLIENT.slotMachineAnimationTime.get(), 20);
    }

    public static int GetRestTime() {
        return Math.max((Integer)LCConfig.CLIENT.slotMachineAnimationRestTime.get(), 1);
    }

    public SlotMachineRenderer(SlotMachineScreen screen) {
        this.screen = screen;
        this.menu = (SlotMachineMenu)this.screen.method_17577();
        this.recollectPossibleBlocks();
        this.initializeLines();
    }

    public SlotMachineRenderBlock getRandomBlock() {
        if (this.totalWeight <= 0) {
            return SlotMachineRenderBlock.empty();
        }
        int rand = this.getRandom().method_43048(this.totalWeight) + 1;
        for (SlotMachineRenderBlock block : this.possibleBlocks) {
            if ((rand -= block.weight) > 0) continue;
            return block;
        }
        return SlotMachineRenderBlock.empty();
    }

    private void recollectPossibleBlocks() {
        SlotMachineTraderData trader = this.getTrader();
        this.possibleBlocks.clear();
        this.totalWeight = 0;
        if (trader != null) {
            for (SlotMachineEntry entry : trader.getValidEntries()) {
                for (class_1799 item : entry.items) {
                    this.possibleBlocks.add(SlotMachineRenderBlock.forItem(entry.getWeight(), item));
                    this.totalWeight += entry.getWeight();
                }
            }
            trader.clearEntriesChangedCache();
        }
        if (this.possibleBlocks.size() == 0) {
            this.possibleBlocks.add(SlotMachineRenderBlock.empty());
        }
    }

    private void initializeLines() {
        while (this.lines.size() < 4) {
            this.lines.add((Object)new SlotMachineLine(this));
        }
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null) {
            List<class_1799> previousRewards = trader.getLastRewards();
            for (int i = 0; i < 4; ++i) {
                if (i < previousRewards.size()) {
                    ((SlotMachineLine)this.lines.get(i)).initialize(SlotMachineRenderBlock.forItem(0, previousRewards.get(i)));
                    continue;
                }
                ((SlotMachineLine)this.lines.get(i)).initialize();
            }
        } else {
            for (SlotMachineLine line : this.lines) {
                line.initialize();
            }
        }
    }

    public void tick() {
        SlotMachineTraderData trader = this.getTrader();
        if (trader != null && trader.areEntriesChanged()) {
            this.recollectPossibleBlocks();
        }
        if (this.menu.hasPendingReward() && this.animationTick == 0) {
            this.startAnimation();
            ++this.animationTick;
        } else if (this.animationTick > 0) {
            if (this.animationTick >= SlotMachineRenderer.GetAnimationTime()) {
                ++this.restTick;
                if (this.restTick >= SlotMachineRenderer.GetRestTime()) {
                    this.animationTick = 0;
                    this.restTick = 0;
                    if (!this.menu.hasPendingReward()) {
                        this.menu.SendMessageToServer(LazyPacketData.builder().setBoolean("AnimationsCompleted", true));
                    }
                }
            } else {
                this.animationTick();
            }
        }
    }

    private void animationTick() {
        ++this.animationTick;
        for (SlotMachineLine line : this.lines) {
            line.animationTick();
        }
        if (this.animationTick >= SlotMachineRenderer.GetAnimationTime()) {
            this.menu.getAndRemoveNextReward();
            this.menu.SendMessageToServer(LazyPacketData.builder().setBoolean("GiveNextReward", true));
        }
    }

    private void startAnimation() {
        SlotMachineMenu.RewardCache pendingReward = this.menu.getNextReward();
        ArrayList<SlotMachineRenderBlock> resultBlocks = new ArrayList<SlotMachineRenderBlock>(4);
        List<class_1799> displayItems = pendingReward.getDisplayItems();
        for (int i = 0; i < 4; ++i) {
            if (i < displayItems.size()) {
                class_1799 item = displayItems.get(i);
                if (item.method_7960()) {
                    resultBlocks.add(SlotMachineRenderBlock.empty());
                    continue;
                }
                resultBlocks.add(SlotMachineRenderBlock.forItem(0, item));
                continue;
            }
            resultBlocks.add(SlotMachineRenderBlock.empty());
        }
        for (SlotMachineLine line : this.lines) {
            line.unlock();
        }
        class_5819 rand = this.getRandom();
        ArrayList<SlotMachineLine> randomLines = new ArrayList<SlotMachineLine>((Collection<SlotMachineLine>)this.lines);
        ArrayList lockDelay = Lists.newArrayList((Object[])new Integer[]{SlotMachineRenderer.GetAnimationTime() - 1});
        while (lockDelay.size() < randomLines.size()) {
            lockDelay.add(rand.method_39332(SlotMachineRenderer.GetAnimationTime() - 11, SlotMachineRenderer.GetAnimationTime() - 1));
        }
        while (randomLines.size() > 0) {
            SlotMachineLine line = randomLines.size() > 1 ? (SlotMachineLine)randomLines.remove(rand.method_43048(randomLines.size())) : (SlotMachineLine)randomLines.remove(0);
            line.lockAtResult((SlotMachineRenderBlock)resultBlocks.remove(0), (Integer)lockDelay.remove(0));
        }
    }

    public void render(class_332 gui, float partialTicks) {
        int startX = this.screen.getImageWidth() / 2 - 4 * SlotMachineLine.BLOCK_SIZE / 2 + this.screen.getGuiLeft();
        int y = this.screen.getGuiTop() + 10;
        for (int i = 0; i < 4; ++i) {
            ((SlotMachineLine)this.lines.get(i)).render(gui, partialTicks, startX, y);
            startX += SlotMachineLine.BLOCK_SIZE;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.method_51448().method_22903();
        gui.method_51448().method_22904(0.0, 0.0, 250.0);
        gui.method_25302(GUI_TEXTURE, this.screen.getGuiLeft(), this.screen.getGuiTop(), 0, 0, this.screen.getImageWidth(), this.screen.getImageHeight());
        gui.method_51448().method_22909();
    }
}

