/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineRenderBlock;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineRenderer;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public final class SlotMachineLine {
    public static int BLOCK_SIZE = 18;
    private final SlotMachineRenderer parent;
    int lockDelay = 0;
    SlotMachineRenderBlock resultBlock = SlotMachineRenderBlock.empty();
    SlotMachineRenderBlock previousBlock2 = SlotMachineRenderBlock.empty();
    SlotMachineRenderBlock previousBlock1 = SlotMachineRenderBlock.empty();
    SlotMachineRenderBlock centerBlock = SlotMachineRenderBlock.empty();
    SlotMachineRenderBlock nextBlock = SlotMachineRenderBlock.empty();

    public SlotMachineLine(SlotMachineRenderer parent) {
        this.parent = parent;
    }

    public void render(class_332 context, float partialTicks, int x, int y) {
        float partialTick = MathUtil.clamp(partialTicks, 0.0f, 1.0f);
        if (this.lockDelay != 0) {
            y += (int)((float)BLOCK_SIZE * partialTick);
        }
        this.previousBlock2.render(context, ++x, ++y);
        this.previousBlock1.render(context, x, y + BLOCK_SIZE);
        this.centerBlock.render(context, x, y + 2 * BLOCK_SIZE);
        this.nextBlock.render(context, x, y + 3 * BLOCK_SIZE);
    }

    public void initialize() {
        this.initialize(SlotMachineRenderBlock.empty());
    }

    public void initialize(SlotMachineRenderBlock previousReward) {
        this.previousBlock2 = this.parent.getRandomBlock();
        this.previousBlock1 = this.parent.getRandomBlock();
        this.centerBlock = previousReward;
        this.nextBlock = this.parent.getRandomBlock();
    }

    public void animationTick() {
        if (this.lockDelay > 0) {
            --this.lockDelay;
            if (this.lockDelay == 2) {
                this.rotateBlocks(this.resultBlock);
                return;
            }
            if (this.lockDelay == 0) {
                this.playDing();
            }
        } else if (this.lockDelay == 0) {
            return;
        }
        this.rotateBlocks();
    }

    private void playDing() {
        class_1144 soundManager = class_310.method_1551().method_1483();
        if (soundManager != null) {
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.0f));
        }
    }

    private void rotateBlocks() {
        this.rotateBlocks(this.parent.getRandomBlock());
    }

    private void rotateBlocks(SlotMachineRenderBlock newBlock) {
        this.nextBlock = this.centerBlock;
        this.centerBlock = this.previousBlock1;
        this.previousBlock1 = this.previousBlock2;
        this.previousBlock2 = newBlock;
    }

    public void lockAtResult(SlotMachineRenderBlock block, int lockDelay) {
        this.lockDelay = lockDelay;
        this.resultBlock = block;
    }

    public void unlock() {
        this.lockDelay = -1;
        this.resultBlock = SlotMachineRenderBlock.empty();
    }
}

