/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common.TraderInteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menu.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import org.jetbrains.annotations.NotNull;

public class TraderScreen
extends MenuScreen<TraderMenu> {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/trader.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    IconButton buttonOpenStorage;
    IconButton buttonCollectCoins;
    class_4185 buttonOpenTerminal;
    List<class_339> tabRenderables = new ArrayList<class_339>();
    List<class_364> tabListeners = new ArrayList<class_364>();
    TraderClientTab currentTab = new TraderInteractionTab(this);

    public void setTab(@NotNull TraderClientTab tab) {
        this.currentTab.onClose();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.currentTab = tab;
        this.currentTab.onOpen();
    }

    public void closeTab() {
        this.setTab(new TraderInteractionTab(this));
    }

    protected boolean forceShowTerminalButton() {
        return false;
    }

    public TraderScreen(TraderMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        this.field_2792 = 206;
        this.field_2779 = 236;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.buttonOpenStorage = (IconButton)this.method_37063((class_364)IconAndButtonUtil.storageButton(this.field_2776 + 15 - 20, this.field_2800 + 118, this::OpenStorage, () -> ((TraderMenu)this.field_2797).isSingleTrader() && ((TraderMenu)this.field_2797).getSingleTrader().hasPermission(((TraderMenu)this.field_2797).player, "openStorage")));
        this.buttonCollectCoins = (IconButton)this.method_37063((class_364)IconAndButtonUtil.collectCoinButton(this.field_2776 + 15 - 20, this.field_2800 + 138, this::CollectCoins, ((TraderMenu)this.field_2797).player, ((TraderMenu)this.field_2797)::getSingleTrader));
        this.buttonOpenTerminal = (class_4185)this.method_37063((class_364)IconAndButtonUtil.backToTerminalButton(this.field_2776 + 15 - 20, this.field_2800 + this.field_2779 - 20, this::OpenTerminal, this::showTerminalButton));
        LazyWidgetPositioner.create(this, LazyWidgetPositioner.MODE_TOPDOWN, -5, 118, 20, new class_339[]{this.buttonOpenStorage, this.buttonCollectCoins});
        this.currentTab.onOpen();
        this.method_37432();
    }

    private boolean showTerminalButton() {
        return this.forceShowTerminalButton() || ((TraderMenu)this.field_2797).isSingleTrader() && ((TraderMenu)this.field_2797).getSingleTrader().showOnTerminal();
    }

    protected void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(GUI_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (class_1735 slot : ((TraderMenu)this.field_2797).getCoinSlots()) {
            gui.method_25302(GUI_TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, this.field_2792, 0, 18, 18);
        }
        if (((TraderMenu)this.field_2797).getInteractionSlot().method_7682()) {
            gui.method_25302(GUI_TEXTURE, this.field_2776 + ((TraderMenu)this.field_2797).getInteractionSlot().field_7873 - 1, this.field_2800 + ((TraderMenu)this.field_2797).getInteractionSlot().field_7872 - 1, this.field_2792, 0, 18, 18);
        }
        try {
            this.currentTab.renderBG(gui, mouseX, mouseY, partialTicks);
            this.tabRenderables.forEach(widget -> widget.method_25394(gui, mouseX, mouseY, partialTicks));
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab " + this.currentTab.getClass().getName(), t);
        }
    }

    protected void method_2388(class_332 gui, int mouseX, int mouseY) {
        gui.method_51439(this.field_22793, this.field_29347, 23, this.field_2779 - 94, 0x404040, false);
        String valueText = MoneyUtil.getStringOfValue(((TraderMenu)this.field_2797).getContext(null).getAvailableFunds());
        gui.method_51433(this.field_22793, valueText, 185 - this.field_22793.method_1727(valueText), this.field_2779 - 94, 0x404040, false);
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gui);
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        this.method_2380(gui, mouseX, mouseY);
        try {
            this.currentTab.renderTooltips(gui, mouseX, mouseY);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error rendering trader tab tooltips " + this.currentTab.getClass().getName(), t);
        }
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.currentTab.tick();
    }

    private void OpenStorage(class_4185 button) {
        if (((TraderMenu)this.field_2797).isSingleTrader()) {
            new CMessageOpenStorage(((TraderMenu)this.field_2797).getSingleTrader().getID()).sendToServer();
        }
    }

    private void CollectCoins(class_4185 button) {
        if (((TraderMenu)this.field_2797).isSingleTrader()) {
            new CMessageCollectCoins().sendToServer();
        }
    }

    private void OpenTerminal(class_4185 button) {
        if (this.showTerminalButton()) {
            ((TraderMenu)this.field_2797).closeMenu(((TraderMenu)this.field_2797).player);
            TradingTerminalScreen.open();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) && this.currentTab.blockInventoryClosing()) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifier);
    }

    public <T extends class_339> T addRenderableTabWidget(T widget) {
        this.tabRenderables.add(widget);
        return widget;
    }

    public <T extends class_4068> void removeRenderableTabWidget(T widget) {
        this.tabRenderables.remove(widget);
    }

    public <T extends class_364> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public <T extends class_364> void removeTabListener(T listener) {
        this.tabListeners.remove(listener);
    }

    public List<? extends class_364> method_25396() {
        List coreListeners = super.method_25396();
        ArrayList listeners = Lists.newArrayList();
        listeners.addAll(coreListeners);
        listeners.addAll(this.tabRenderables);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            if (this.currentTab.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        try {
            if (this.currentTab.mouseReleased(mouseX, mouseY, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_25406(mouseX, mouseY, button);
    }
}

