/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineRenderer;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine.SlotMachineEntryDisplayWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menu.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class SlotMachineScreen
extends MenuScreen<SlotMachineMenu>
implements ScrollListener.IScrollListener,
ScrollBarWidget.IScrollable {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/slot_machine.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 222;
    public static final int ENTRY_ROWS = 2;
    public static final int ENTRY_COLUMNS = 2;
    public static final int ENTRIES_PER_PAGE = 4;
    private boolean interactMode = true;
    private int scroll = 0;
    IconButton buttonOpenStorage;
    IconButton buttonCollectCoins;
    private final Supplier<class_7919> collectCoinsTooltip = new IconAndButtonUtil.AdditiveTooltip("tooltip.lightmanscurrency.trader.collectcoins", () -> {
        SlotMachineTraderData t = ((SlotMachineMenu)this.field_2797).getTrader();
        if (t != null) {
            return new Object[]{t.getStoredMoney().getString()};
        }
        return new Object[0];
    });
    IconButton buttonOpenTerminal;
    class_4185 buttonInteract;
    class_4185 buttonInteract5;
    class_4185 buttonInteract10;
    class_4185 buttonInfo;
    ScrollListener scrollListener;
    ScrollBarWidget scrollBar;
    List<SlotMachineEntryDisplayWidget> infoWidgets = new ArrayList<SlotMachineEntryDisplayWidget>();
    private final SlotMachineRenderer slotRenderer = new SlotMachineRenderer(this);
    public final ScreenPosition SM_INFO_WIDGET = ScreenPosition.of(160, 8);

    public class_327 getFont() {
        return this.field_22793;
    }

    public SlotMachineScreen(SlotMachineMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 222;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        LazyWidgetPositioner leftEdgePositioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.MODE_BOTTOMUP, -20, 202, 20, new class_339[0]);
        this.infoWidgets.clear();
        this.buttonOpenStorage = (IconButton)this.method_37063((class_364)new IconButton(this.getGuiLeft() + 15 - 20, this.getGuiTop() + 118, this::OpenStorage, IconAndButtonUtil.ICON_STORAGE));
        this.buttonOpenStorage.setVisiblityCheck(() -> ((SlotMachineMenu)this.field_2797).getTrader() != null && ((SlotMachineMenu)this.field_2797).getTrader().hasPermission(((SlotMachineMenu)this.field_2797).player, "openStorage"));
        this.buttonCollectCoins = (IconButton)this.method_37063((class_364)new IconButton(this.getGuiLeft() + 15 - 20, this.getGuiTop() + 138, this::CollectCoins, IconAndButtonUtil.ICON_COLLECT_COINS));
        this.buttonCollectCoins.setVisiblityCheck(() -> {
            SlotMachineTraderData trader = ((SlotMachineMenu)this.field_2797).getTrader();
            if (trader == null) {
                return false;
            }
            return trader.hasPermission(((SlotMachineMenu)this.field_2797).player, "collectCoins") && !trader.hasBankAccount();
        });
        this.buttonCollectCoins.setActiveCheck(() -> {
            SlotMachineTraderData trader = ((SlotMachineMenu)this.field_2797).getTrader();
            if (trader == null) {
                return false;
            }
            return trader.getInternalStoredMoney().getRawValue() > 0L;
        });
        this.buttonOpenTerminal = (IconButton)this.method_37063((class_364)new IconButton(this.getGuiLeft() + 15 - 20, this.getGuiTop() + this.getImageHeight() - 20, this::OpenTerminal, IconAndButtonUtil.ICON_BACK));
        this.buttonOpenTerminal.setVisiblityCheck(this::showTerminalButton);
        leftEdgePositioner.clear();
        leftEdgePositioner.addWidgets(new Object[]{this.buttonOpenTerminal, this.buttonOpenStorage, this.buttonCollectCoins});
        leftEdgePositioner.reposition();
        this.buttonInteract = (class_4185)this.method_37063((class_364)new PlainButton(this.getGuiLeft() + 52, this.getGuiTop() + 107, 18, 18, b -> this.ExecuteTrade(1), GUI_TEXTURE, 176, 0));
        this.buttonInteract5 = (class_4185)this.method_37063((class_364)new PlainButton(this.getGuiLeft() + 29, this.getGuiTop() + 107, 18, 18, b -> this.ExecuteTrade(5), GUI_TEXTURE, 194, 0));
        this.buttonInteract10 = (class_4185)this.method_37063((class_364)new PlainButton(this.getGuiLeft() + 7, this.getGuiTop() + 107, 18, 18, b -> this.ExecuteTrade(10), GUI_TEXTURE, 212, 0));
        this.buttonInfo = (class_4185)this.method_37063((class_364)new PlainButton(this.getGuiLeft() + this.SM_INFO_WIDGET.x, this.getGuiTop() + this.SM_INFO_WIDGET.y, 10, 11, this::ToggleMode, GUI_TEXTURE, 176, 36));
        this.scrollListener = (ScrollListener)this.method_25429(new ScrollListener(this.getGuiLeft(), this.getGuiTop(), this.getImageWidth(), this.getImageHeight(), this));
        this.scrollListener.active = this.isInfoMode();
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                int displayIndex = y * 2 + x;
                this.infoWidgets.add((SlotMachineEntryDisplayWidget)this.method_37063((class_364)new SlotMachineEntryDisplayWidget(ScreenPosition.of(this.getGuiLeft(), this.getGuiTop()).offset(19 + x * 80, 10 + y * 46), ((SlotMachineMenu)this.field_2797)::getTrader, () -> this.getTrueIndex(displayIndex), this.getFont())));
            }
        }
        this.scrollBar = (ScrollBarWidget)this.method_37063((class_364)new ScrollBarWidget(this.getGuiLeft() + 8, this.getGuiTop() + 10, 92, this));
    }

    private boolean isInteractMode() {
        return this.interactMode;
    }

    private boolean isInfoMode() {
        return !this.interactMode;
    }

    private void ToggleMode(class_4185 button) {
        if (((SlotMachineMenu)this.field_2797).hasPendingReward()) {
            return;
        }
        boolean bl = this.interactMode = !this.interactMode;
        if (this.isInfoMode()) {
            this.validateScroll();
        }
    }

    private boolean allowInteraction() {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.field_2797).getTrader();
        return !((SlotMachineMenu)this.field_2797).hasPendingReward() && trader != null && trader.hasStock() && trader.hasValidTrade();
    }

    private boolean showTerminalButton() {
        if (((SlotMachineMenu)this.field_2797).getTrader() != null) {
            return ((SlotMachineMenu)this.field_2797).getTrader().showOnTerminal();
        }
        return false;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25302(GUI_TEXTURE, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getImageWidth(), this.getImageHeight());
        if (this.isInteractMode()) {
            this.slotRenderer.render(context, delta);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_29347, 8, this.getImageHeight() - 94, 0x404040, false);
        String valueText = MoneyUtil.getStringOfValue(((SlotMachineMenu)this.field_2797).getContext(null).getAvailableFunds());
        context.method_51433(this.field_22793, valueText, 170 - this.field_22793.method_1727(valueText) - 10, this.getImageHeight() - 94, 0x404040, false);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        try {
            this.buttonInteract5.field_22764 = this.buttonInteract10.field_22764 = this.isInteractMode();
            this.buttonInteract.field_22764 = this.buttonInteract10.field_22764;
            this.buttonInteract5.field_22763 = this.buttonInteract10.field_22763 = this.allowInteraction();
            this.buttonInteract.field_22763 = this.buttonInteract10.field_22763;
            this.scrollListener.active = this.scrollBar.field_22764 = this.isInfoMode();
            for (SlotMachineEntryDisplayWidget w : this.infoWidgets) {
                w.field_22764 = this.isInfoMode();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51448().method_22903();
        context.method_51448().method_22904(0.0, 0.0, 250.0);
        this.method_2380(context, mouseX, mouseY);
        if (this.buttonInteract != null && this.buttonInteract.method_25405((double)mouseX, (double)mouseY)) {
            context.method_51434(this.field_22793, this.getInteractionTooltip(1), mouseX, mouseY);
        }
        if (this.buttonInteract5 != null && this.buttonInteract5.method_25405((double)mouseX, (double)mouseY)) {
            context.method_51434(this.field_22793, this.getInteractionTooltip(5), mouseX, mouseY);
        }
        if (this.buttonInteract10 != null && this.buttonInteract10.method_25405((double)mouseX, (double)mouseY)) {
            context.method_51434(this.field_22793, this.getInteractionTooltip(10), mouseX, mouseY);
        }
        if (this.buttonInfo != null && this.buttonInfo.method_25405((double)mouseX, (double)mouseY)) {
            context.method_51434(this.field_22793, this.getInfoTooltip(), mouseX, mouseY);
        }
        if (this.buttonOpenStorage != null && this.buttonOpenStorage.method_25405(mouseX, mouseY)) {
            context.method_51447(this.field_22793, IconAndButtonUtil.TOOLTIP_STORAGE.get().method_47405(this.field_22787), mouseX, mouseY);
        }
        if (this.buttonCollectCoins != null && this.buttonCollectCoins.method_25405(mouseX, mouseY)) {
            context.method_51447(this.field_22793, this.collectCoinsTooltip.get().method_47405(this.field_22787), mouseX, mouseY);
        }
        if (this.buttonOpenTerminal != null && this.buttonOpenTerminal.method_25405(mouseX, mouseY)) {
            context.method_51447(this.field_22793, IconAndButtonUtil.TOOLTIP_BACK_TO_TERMINAL.get().method_47405(this.field_22787), mouseX, mouseY);
        }
        for (SlotMachineEntryDisplayWidget w : this.infoWidgets) {
            w.renderTooltips(context, mouseX, mouseY);
        }
        context.method_51448().method_22909();
    }

    @Nullable
    private List<class_2561> getInfoTooltip() {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.field_2797).getTrader();
        if (trader != null) {
            List<class_2561> info = trader.getSlotMachineInfo();
            if (this.isInfoMode()) {
                info.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.to_interact", new Object[0]));
            } else {
                info.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.to_info", new Object[0]));
            }
            return info;
        }
        return null;
    }

    private List<class_2561> getInteractionTooltip(int count) {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.field_2797).getTrader();
        if (trader != null) {
            if (count == 1) {
                return ImmutableList.of((Object)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.roll", new Object[0]), (Object)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.roll.cost", trader.getPrice().getString()));
            }
            return ImmutableList.of((Object)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.rolls", count), (Object)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.rolls.cost", trader.getPrice().getString()));
        }
        return ImmutableList.of();
    }

    private void ExecuteTrade(int count) {
        ((SlotMachineMenu)this.field_2797).SendMessageToServer(LazyPacketData.builder().setInt("ExecuteTrade", count));
    }

    private void OpenStorage(class_4185 button) {
        if (((SlotMachineMenu)this.field_2797).getTrader() != null) {
            new CMessageOpenStorage(((SlotMachineMenu)this.field_2797).getTrader().getID()).sendToServer();
        }
    }

    private void CollectCoins(class_4185 button) {
        if (((SlotMachineMenu)this.field_2797).getTrader() != null) {
            new CMessageCollectCoins().sendToServer();
        }
    }

    private void OpenTerminal(class_4185 button) {
        if (this.showTerminalButton()) {
            ((SlotMachineMenu)this.field_2797).closeMenu(((SlotMachineMenu)this.field_2797).player);
            TradingTerminalScreen.open();
        }
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.scrollListener.active = this.isInfoMode();
        if (this.isInfoMode()) {
            this.validateScroll();
        }
        this.slotRenderer.tick();
    }

    protected void validateScroll() {
        if (this.scroll > this.getMaxScroll() && this.scroll > 0) {
            this.setScroll(Math.max(this.getMaxScroll(), 0));
        }
    }

    private List<SlotMachineEntry> getEntries() {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.field_2797).getTrader();
        if (trader != null) {
            return trader.getValidEntries();
        }
        return new ArrayList<SlotMachineEntry>();
    }

    private int getTrueIndex(int displayIndex) {
        return displayIndex + this.scroll * 2;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return ScrollBarWidget.IScrollable.calculateMaxScroll(4, 2, this.getEntries().size());
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int scroll = this.currentScroll();
        if (delta < 0.0) {
            if (scroll < this.getMaxScroll()) {
                this.setScroll(scroll + 1);
                return true;
            }
        } else if (delta > 0.0 && scroll > 0) {
            this.setScroll(scroll - 1);
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }
}

