/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ExchangeTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.InteractionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.LogTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.NotificationTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.SelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.TransferTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menu.ATMMenu;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class ATMScreen
extends MenuScreen<ATMMenu> {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/atm.png");
    public static final class_2960 BUTTON_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/atm_buttons.png");
    int currentTabIndex = 0;
    List<ATMTab> tabs = Lists.newArrayList((Object[])new ATMTab[]{new ExchangeTab(this), new SelectionTab(this), new InteractionTab(this), new NotificationTab(this), new LogTab(this), new TransferTab(this)});
    List<class_339> tabWidgets = new ArrayList<class_339>();
    List<class_364> tabListeners = new ArrayList<class_364>();
    List<TabButton> tabButtons = new ArrayList<TabButton>();
    boolean logError = true;

    public List<ATMTab> getTabs() {
        return this.tabs;
    }

    public ATMTab currentTab() {
        return this.tabs.get(this.currentTabIndex);
    }

    public ATMScreen(ATMMenu container, class_1661 inventory, class_2561 title) {
        super(container, inventory, title);
        this.field_2779 = 243;
        this.field_2792 = 176;
    }

    protected void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
        block2: {
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            gui.method_25302(GUI_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
            try {
                this.currentTab().preRender(gui, mouseX, mouseY, partialTicks);
                this.tabWidgets.forEach(widget -> widget.method_25394(gui, mouseX, mouseY, partialTicks));
            }
            catch (Exception e) {
                if (!this.logError) break block2;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
    }

    protected void method_2388(class_332 gui, int mouseX, int mouseY) {
        gui.method_51439(this.field_22793, this.field_29347, 8, this.field_2779 - 94, 0x404040, false);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.tabButtons = new ArrayList<TabButton>();
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.method_37063((class_364)new TabButton(this::clickedOnTab, this.field_22793, this.tabs.get(i)));
            button.reposition(this.field_2776 - 25, this.field_2800 + i * 25, 3);
            button.field_22763 = i != this.currentTabIndex;
            this.tabButtons.add(button);
        }
        this.currentTab().init();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        block3: {
            this.method_25420(gui);
            super.method_25394(gui, mouseX, mouseY, partialTicks);
            try {
                this.currentTab().postRender(gui, mouseX, mouseY);
            }
            catch (Exception e) {
                if (!this.logError) break block3;
                LightmansCurrency.LogError("Error rendering " + this.currentTab().getClass().getName() + " tab.", e);
                this.logError = false;
            }
        }
        this.method_2380(gui, mouseX, mouseY);
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            if (!this.tabButtons.get(i).method_25405(mouseX, mouseY)) continue;
            gui.method_51438(this.field_22793, (class_2561)this.tabButtons.get((int)i).tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void changeTab(int tabIndex) {
        this.currentTab().onClose();
        this.tabButtons.get((int)this.currentTabIndex).field_22763 = true;
        this.currentTabIndex = MathUtil.clamp(tabIndex, 0, this.tabs.size() - 1);
        this.tabButtons.get((int)this.currentTabIndex).field_22763 = false;
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().init();
        this.logError = true;
    }

    private void clickedOnTab(class_4185 tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.currentTab().tick();
    }

    public <T extends class_339> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(class_339 widget) {
        if (this.tabWidgets.contains(widget)) {
            this.tabWidgets.remove(widget);
        }
    }

    public <T extends class_364> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(class_364 listener) {
        if (this.tabListeners.contains(listener)) {
            this.tabListeners.remove(listener);
        }
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public List<? extends class_364> method_25396() {
        List coreListeners = super.method_25396();
        ArrayList listeners = Lists.newArrayList();
        listeners.addAll(coreListeners);
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

