/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenTrades;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class TradingTerminalScreen
extends class_437
implements ScrollBarWidget.IScrollable {
    private static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/trader_selection.png");
    public static final Comparator<TraderData> TERMINAL_SORTER = new TraderSorter(true, true, true);
    public static final Comparator<TraderData> NAME_ONLY_SORTER = new TraderSorter(false, false, false);
    private final int xSize = 176;
    private final int ySize = 187;
    private class_342 searchField;
    private static int scroll = 0;
    ScrollBarWidget scrollBar;
    List<NetworkTraderButton> traderButtons;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();

    public static void open() {
        if (RenderSystem.isOnRenderThread()) {
            class_310 client = class_310.method_1551();
            client.method_1507((class_437)new TradingTerminalScreen());
        } else {
            ScreenUtil.safelyOpenScreen(new TradingTerminalScreen());
        }
    }

    private List<TraderData> traderList() {
        List<TraderData> traderList = TraderSaveData.GetAllTerminalTraders(true);
        traderList.removeIf(d -> d instanceof AuctionHouseTrader && (Boolean)LCConfig.SERVER.auctionHouseEnabled.get() == false);
        traderList.sort(TERMINAL_SORTER);
        return traderList;
    }

    public TradingTerminalScreen() {
        super((class_2561)class_2561.method_43471((String)"block.lightmanscurrency.terminal"));
    }

    protected void method_25426() {
        super.method_25426();
        int guiLeft = (this.field_22789 - this.xSize) / 2;
        int guiTop = (this.field_22790 - this.ySize) / 2;
        this.searchField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, guiLeft + 28, guiTop + 6, 101, 9, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.terminal.search")));
        this.searchField.method_1858(false);
        this.searchField.method_1880(32);
        this.searchField.method_1868(0xFFFFFF);
        this.scrollBar = (ScrollBarWidget)this.method_37063((class_364)new ScrollBarWidget(guiLeft + 16 + 146, guiTop + 17, 152, this));
        this.initTraderButtons(guiLeft, guiTop);
        this.method_25393();
        this.updateTraderList();
        this.validateScroll();
    }

    public boolean method_25421() {
        return false;
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < 5; ++y) {
            NetworkTraderButton newButton = (NetworkTraderButton)this.method_37063((class_364)new NetworkTraderButton(guiLeft + 15, guiTop + 18 + y * 30, this::OpenTrader, this.field_22793));
            this.traderButtons.add(newButton);
        }
    }

    public void method_25393() {
        super.method_25393();
        this.searchField.method_1865();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22787 == null) {
            this.field_22787 = class_310.method_1551();
        }
        this.method_25420(gui);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int startX = (this.field_22789 - this.xSize) / 2;
        int startY = (this.field_22790 - this.ySize) / 2;
        gui.method_25302(GUI_TEXTURE, startX, startY, 0, 0, this.xSize, this.ySize);
        this.scrollBar.beforeWidgetRender(mouseY);
        super.method_25394(gui, mouseX, mouseY, partialTicks);
    }

    public boolean method_25400(char c, int code) {
        String s = this.searchField.method_1882();
        if (this.searchField.method_25400(c, code)) {
            if (!Objects.equals(s, this.searchField.method_1882())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int key, int scanCode, int mods) {
        String s = this.searchField.method_1882();
        if (this.searchField.method_25404(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.method_1882())) {
                this.updateTraderList();
            }
            return true;
        }
        return this.searchField.method_25370() && this.searchField.method_1885() && key != 256 || super.method_25404(key, scanCode, mods);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (scroll < this.getMaxScroll()) {
                this.setScroll(scroll + 1);
            }
        } else if (delta > 0.0 && scroll > 0) {
            this.setScroll(scroll - 1);
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void OpenTrader(class_4185 button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            new CMessageOpenTrades(this.filteredTraderList.get(index).getID()).sendToServer();
        }
    }

    private int getTraderIndex(class_4185 button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += scroll;
    }

    private void updateTraderList() {
        this.filteredTraderList = this.searchField.method_1882().isBlank() ? this.traderList() : TraderSearchFilter.FilterTraders(this.traderList(), this.searchField.method_1882());
        this.validateScroll();
        this.updateTraderButtons();
    }

    private void updateTraderButtons() {
        int startIndex = scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    private void validateScroll() {
        scroll = Math.min(scroll, this.getMaxScroll());
    }

    @Override
    public int currentScroll() {
        return scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        scroll = newScroll;
        this.updateTraderButtons();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.filteredTraderList.size() - this.traderButtons.size());
    }

    private record TraderSorter(boolean creativeAtTop, boolean emptyAtBottom, boolean auctionHousePriority) implements Comparator<TraderData>
    {
        @Override
        public int compare(TraderData a, TraderData b) {
            try {
                int sort;
                if (this.auctionHousePriority) {
                    boolean ahA = a instanceof AuctionHouseTrader;
                    boolean ahB = b instanceof AuctionHouseTrader;
                    if (ahA && !ahB) {
                        return -1;
                    }
                    if (ahB && !ahA) {
                        return 1;
                    }
                }
                if (this.emptyAtBottom) {
                    boolean emptyB;
                    boolean emptyA = !a.hasValidTrade();
                    boolean bl = emptyB = !b.hasValidTrade();
                    if (emptyA != emptyB) {
                        return emptyA ? 1 : -1;
                    }
                }
                if (this.creativeAtTop) {
                    if (a.isCreative() && !b.isCreative()) {
                        return -1;
                    }
                    if (b.isCreative() && !a.isCreative()) {
                        return 1;
                    }
                }
                if ((sort = a.getName().getString().toLowerCase().compareTo(b.getName().getString().toLowerCase())) == 0) {
                    sort = a.getOwner().getOwnerName(true).compareToIgnoreCase(b.getOwner().getOwnerName(true));
                }
                return sort;
            }
            catch (Throwable t) {
                return 0;
            }
        }
    }
}

