/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;

public class TradeRuleScreen
extends class_437 {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/traderules.png");
    public final int xSize = 176;
    public final int ySize = 176;
    private final long traderID;
    private final int tradeIndex;
    int openTab = -1;
    class_4185 managerTab;
    Map<Integer, class_4185> tabButtons = new HashMap<Integer, class_4185>();
    List<class_4185> toggleRuleButtons = new ArrayList<class_4185>();
    TradeRule.GUIHandler currentGUIHandler = null;

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.field_22789 - 176) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.field_22790 - 176) / 2;
    }

    private TraderData getTrader() {
        return TraderSaveData.GetTrader(true, this.traderID);
    }

    private TradeData getTrade() {
        return this.getTrader().getTradeData().get(this.tradeIndex);
    }

    private boolean stillValid() {
        try {
            if (this.getTrader() == null || this.tradeIndex >= 0 && this.getTrade() == null) {
                return false;
            }
            if (!this.getTrader().hasPermission((class_1657)this.field_22787.field_1724, "editTradeRules")) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private List<TradeRule> getTradeRules() {
        try {
            if (this.tradeIndex < 0) {
                return this.getTrader().getRules();
            }
            return this.getTrade().getRules();
        }
        catch (Throwable t) {
            return new ArrayList<TradeRule>();
        }
    }

    TradeRule currentRule() {
        if (this.openTab >= 0 && this.openTab < this.getTradeRules().size()) {
            return this.getTradeRules().get(this.openTab);
        }
        return null;
    }

    public TradeRuleScreen(long traderID, int tradeIndex) {
        super((class_2561)class_2561.method_43473());
        this.traderID = traderID;
        this.tradeIndex = tradeIndex;
    }

    public void method_25426() {
        int n = this.guiLeft();
        Objects.requireNonNull(this);
        this.method_37063((class_364)new IconButton(n + 176, this.guiTop(), this::PressBackButton, IconAndButtonUtil.ICON_BACK));
        this.managerTab = (class_4185)this.method_37063((class_364)new IconButton(this.guiLeft(), this.guiTop() - 20, b -> this.PressTabButton(-1), IconAndButtonUtil.ICON_TRADE_RULES));
        this.refreshTabs();
        this.initManagerTab();
    }

    private void initManagerTab() {
        this.toggleRuleButtons.clear();
        int count = this.getTradeRules().size();
        for (int i = 0; i < count; ++i) {
            int index = i;
            this.toggleRuleButtons.add((class_4185)this.method_37063((class_364)IconAndButtonUtil.checkmarkButton(this.guiLeft() + 20, this.guiTop() + 25 + 12 * i, this::PressManagerActiveButton, () -> {
                List<TradeRule> rules = this.getTradeRules();
                if (index < rules.size()) {
                    return rules.get(index).isActive();
                }
                return false;
            })));
        }
    }

    private void closeManagerTab() {
        for (class_4185 b : this.toggleRuleButtons) {
            this.removeCustomWidget(b);
        }
        this.toggleRuleButtons.clear();
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        List<TradeRule> rules;
        this.method_25420(gui);
        if (this.openTab >= 0) {
            TradeRule rule = this.currentRule();
            if (rule != null && !rule.isActive()) {
                gui.method_51422(1.0f, 0.5f, 0.5f, 1.0f);
            } else {
                gui.method_51422(0.0f, 1.0f, 0.0f, 1.0f);
            }
        } else {
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        int n = this.guiLeft();
        int n2 = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        gui.method_25302(GUI_TEXTURE, n, n2, 0, 0, 176, 176);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.currentGUIHandler != null) {
            this.currentGUIHandler.renderTab(gui, mouseX, mouseY, partialTicks);
        } else {
            if (this.openTab >= 0) {
                this.openTab = -1;
            }
            gui.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"traderule.list.blurb").method_27692(class_124.field_1067), this.guiLeft() + 20, this.guiTop() + 10, 0xFFFFFF, false);
            rules = this.getTradeRules();
            for (int i = 0; i < this.getTradeRules().size(); ++i) {
                TradeRule rule = rules.get(i);
                class_5250 name = rule.getName().method_27692(rule.isActive() ? class_124.field_1060 : class_124.field_1061).method_27692(class_124.field_1067);
                gui.method_51439(this.field_22793, (class_2561)name, this.guiLeft() + 32, this.guiTop() + 26 + 12 * i, 0xFFFFFF, false);
            }
        }
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        if (this.managerTab.method_25405((double)mouseX, (double)mouseY)) {
            gui.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.manager"), mouseX, mouseY);
        } else {
            rules = this.getTradeRules();
            this.tabButtons.forEach((ruleIndex, thisTab) -> {
                if (thisTab.method_25405((double)mouseX, (double)mouseY) && ruleIndex >= 0 && ruleIndex < rules.size()) {
                    gui.method_51438(this.field_22793, (class_2561)((TradeRule)rules.get((int)ruleIndex)).getName(), mouseX, mouseY);
                }
            });
        }
    }

    public void method_25393() {
        if (this.field_22787 == null) {
            return;
        }
        if (!this.stillValid()) {
            this.field_22787.method_1507(null);
            return;
        }
        if (this.currentGUIHandler != null) {
            this.currentGUIHandler.onScreenTick();
        }
        this.validateTabs();
    }

    void PressBackButton(class_4185 button) {
        new CMessageOpenStorage(this.traderID).sendToServer();
    }

    void PressTabButton(int ruleIndex) {
        if (ruleIndex >= 0) {
            if (this.openTab == ruleIndex) {
                return;
            }
            if (this.currentGUIHandler != null) {
                this.currentGUIHandler.onTabClose();
                this.currentGUIHandler = null;
            } else {
                this.closeManagerTab();
            }
            this.openTab = ruleIndex;
            if (this.currentRule() != null) {
                this.currentGUIHandler = this.currentRule().createHandler(this, (Supplier<TradeRule>)((Supplier)this::currentRule));
                this.currentGUIHandler.initTab();
            }
        } else {
            if (this.openTab < 0) {
                return;
            }
            if (this.currentGUIHandler != null) {
                this.currentGUIHandler.onTabClose();
                this.currentGUIHandler = null;
            }
            this.openTab = -1;
            this.initManagerTab();
        }
    }

    void PressManagerActiveButton(class_4185 button) {
        int ruleIndex = this.toggleRuleButtons.indexOf(button);
        if (ruleIndex >= 0) {
            List<TradeRule> rules = this.getTradeRules();
            if (ruleIndex < rules.size()) {
                TradeRule rule = rules.get(ruleIndex);
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("SetActive", !rule.isActive());
                this.sendUpdateMessage(rule, updateInfo);
            }
            this.refreshTabs();
        }
    }

    public void sendUpdateMessage(TradeRule rule, class_2487 updateInfo) {
        if (rule != null) {
            this.getTrader().sendTradeRuleMessage(this.tradeIndex, rule.type, updateInfo);
        }
    }

    private void validateTabs() {
        List<TradeRule> rules = this.getTradeRules();
        int activeCount = 0;
        for (int i = 0; i < rules.size(); ++i) {
            TradeRule thisRule = rules.get(i);
            if (!thisRule.isActive()) continue;
            ++activeCount;
            if (this.tabButtons.containsKey(i)) continue;
            this.refreshTabs();
            return;
        }
        if (activeCount != this.tabButtons.values().size()) {
            this.refreshTabs();
        }
    }

    public void refreshTabs() {
        this.tabButtons.values().forEach(x$0 -> this.method_37066((class_364)x$0));
        this.tabButtons.clear();
        List<TradeRule> rules = this.getTradeRules();
        int buttonPos = 0;
        for (int i = 0; i < rules.size(); ++i) {
            int ruleIndex = i;
            TradeRule thisRule = rules.get(ruleIndex);
            if (!thisRule.isActive()) continue;
            this.tabButtons.put(ruleIndex, (class_4185)this.method_37063((class_364)new IconButton(this.guiLeft() + 20 + 20 * buttonPos, this.guiTop() - 20, b -> this.PressTabButton(ruleIndex), thisRule.getButtonIcon())));
            ++buttonPos;
        }
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public <T extends class_364 & class_4068> T addCustomRenderable(T widget) {
        if (widget != null) {
            this.method_37063(widget);
        }
        return widget;
    }

    public <T extends class_364 & class_6379> T addCustomWidget(T widget) {
        if (widget != null) {
            this.method_25429(widget);
        }
        return widget;
    }

    public <T extends class_364> void removeCustomWidget(T widget) {
        this.method_37066(widget);
    }
}

