/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleOption
extends ConfigOption<Double> {
    private final double lowerLimit;
    private final double upperLimit;
    private final ConfigParser<Double> parser;

    public static ConfigParser<Double> makeParser(double lowerLimit, double upperLimit) {
        return new Parser(lowerLimit, upperLimit);
    }

    protected DoubleOption(@NotNull Supplier<Double> defaultValue, double lowerLimit, double upperLimit) {
        super(defaultValue);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.parser = DoubleOption.makeParser(lowerLimit, upperLimit);
    }

    @Override
    @NotNull
    protected ConfigParser<Double> getParser() {
        return this.parser;
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Range: " + this.lowerLimit + " -> " + this.upperLimit;
    }

    public static DoubleOption create(double defaultValue) {
        return new DoubleOption(() -> defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public static DoubleOption create(double defaultValue, double lowerLimit) {
        return new DoubleOption(() -> defaultValue, lowerLimit, Double.MAX_VALUE);
    }

    public static DoubleOption create(double defaultValue, double lowerLimit, double upperLimit) {
        return new DoubleOption(() -> defaultValue, lowerLimit, upperLimit);
    }

    public static DoubleOption create(@NotNull Supplier<Double> defaultValue) {
        return new DoubleOption(defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public static DoubleOption create(@NotNull Supplier<Double> defaultValue, double lowerLimit) {
        return new DoubleOption(defaultValue, lowerLimit, Double.MAX_VALUE);
    }

    public static DoubleOption create(@NotNull Supplier<Double> defaultValue, double lowerLimit, double upperLimit) {
        return new DoubleOption(defaultValue, lowerLimit, upperLimit);
    }

    private static class Parser
    implements ConfigParser<Double> {
        private final double lowerLimit;
        private final double upperLimit;

        private Parser(double lowerLimit, double upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        @NotNull
        public Double tryParse(@NotNull String cleanLine) throws ConfigParsingException {
            try {
                return MathUtil.clamp(Double.parseDouble(cleanLine), this.lowerLimit, this.upperLimit);
            }
            catch (NumberFormatException e) {
                throw new ConfigParsingException("Error parsing double!", e);
            }
        }

        @Override
        @NotNull
        public String write(@NotNull Double value) {
            return value.toString();
        }
    }
}

