/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.stats;

import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.class_5819;

public enum Skill {
    HEALTH(1, "HealthLevel"),
    STRENGTH(2, "StrengthLevel"),
    AGILITY(3, "AgilityLevel"),
    DEFENSE(4, "DefenseLevel"),
    STAMINA(5, "StaminaLevel"),
    LUCK(6, "LuckLevel"),
    ARCHERY(7, "ArcheryLevel"),
    TRADE(8, "TradeLevel"),
    SMITHING(9, "SmithingLevel"),
    MINING(10, "MiningLevel"),
    FARMING(11, "FarmingLevel"),
    ALCHEMY(12, "AlchemyLevel");

    final int id;
    final String nbt;

    private Skill(int id, String nbt) {
        this.id = id;
        this.nbt = nbt;
    }

    public static Skill fromNbt(String nbt) {
        return Arrays.stream(Skill.values()).filter(it -> it.nbt.equals(nbt)).findFirst().orElse(null);
    }

    public static Iterable<Skill> listInRandomOrder(class_5819 random) {
        if (random == null) {
            random = class_5819.method_43047();
        }
        class_5819 finalRandom = random;
        return Arrays.stream(Skill.values()).sorted(Comparator.comparing(it -> finalRandom.method_43054())).collect(Collectors.toList());
    }

    public int getId() {
        return this.id;
    }

    public String getNbt() {
        return this.nbt;
    }
}

