/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.init.ConfigInit;
import net.levelz.network.PlayerStatsServerPacket;
import net.levelz.stats.Skill;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class PlayerStatsManager {
    private final class_1657 playerEntity;
    public int overallLevel;
    private int totalLevelExperience;
    public float levelProgress;
    private int skillPoints;
    private final Map<Skill, Integer> skillLevel = new HashMap<Skill, Integer>();
    public List<Integer> lockedBlockIds = new ArrayList<Integer>();
    public List<Integer> lockedbrewingItemIds = new ArrayList<Integer>();
    public List<Integer> lockedSmithingItemIds = new ArrayList<Integer>();
    public List<Integer> lockedCraftingItemIds = new ArrayList<Integer>();
    private int lastExperienceLevel = -1;
    private float lastExperienceProgress = -1.0f;
    private long lastExperience = -1L;

    public PlayerStatsManager(class_1657 playerEntity) {
        this.playerEntity = playerEntity;
    }

    public class_1657 getPlayerEntity() {
        return this.playerEntity;
    }

    public void readNbt(class_2487 tag) {
        if (tag.method_10573("SkillPoints", 99)) {
            this.overallLevel = tag.method_10550("Level");
            this.levelProgress = tag.method_10583("LevelProgress");
            this.totalLevelExperience = tag.method_10550("TotalLevelExperience");
            this.skillPoints = tag.method_10550("SkillPoints");
            for (Skill stats : Skill.values()) {
                this.skillLevel.put(stats, tag.method_10550(stats.getNbt()));
            }
        }
    }

    public void writeNbt(class_2487 tag) {
        tag.method_10569("Level", this.overallLevel);
        tag.method_10548("LevelProgress", this.levelProgress);
        tag.method_10569("TotalLevelExperience", this.totalLevelExperience);
        tag.method_10569("SkillPoints", this.skillPoints);
        this.skillLevel.forEach((k, v) -> tag.method_10569(k.getNbt(), v.intValue()));
    }

    public void setOverallLevel(int overallLevel) {
        this.overallLevel = overallLevel;
    }

    public int getOverallLevel() {
        return this.overallLevel;
    }

    public void setTotalLevelExperience(int totalLevelExperience) {
        this.totalLevelExperience = totalLevelExperience;
    }

    public int getTotalLevelExperience() {
        return this.totalLevelExperience;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void setLevelProgress(float levelProgress) {
        this.levelProgress = ConfigInit.CONFIG.useIndependentExp ? levelProgress : 0.0f;
    }

    public float getLevelProgress() {
        if (!ConfigInit.CONFIG.useIndependentExp) {
            return Math.min((float)this.getNonIndependentExperience() / (float)this.getNextLevelExperience(), 1.0f);
        }
        return this.levelProgress;
    }

    public void setSkillLevel(Skill skill, int level) {
        this.skillLevel.put(skill, level);
    }

    public int getSkillLevel(Skill skill) {
        if (this.skillLevel.containsKey((Object)skill)) {
            return this.skillLevel.get((Object)skill);
        }
        return 0;
    }

    @Deprecated
    public void setLevel(String string, int level) {
        switch (string) {
            case "level": {
                this.overallLevel = level;
                break;
            }
            case "points": {
                this.skillPoints = level;
                break;
            }
            default: {
                this.setSkillLevel(Skill.valueOf(string.toUpperCase()), level);
            }
        }
    }

    @Deprecated
    public int getLevel(String string) {
        return switch (string) {
            case "level" -> this.overallLevel;
            case "points" -> this.skillPoints;
            default -> this.getSkillLevel(Skill.valueOf(string.toUpperCase()));
        };
    }

    public void addExperienceLevels(int levels) {
        this.overallLevel += levels;
        this.skillPoints += ConfigInit.CONFIG.pointsPerLevel;
        if (this.overallLevel < 0) {
            this.overallLevel = 0;
            this.levelProgress = 0.0f;
            this.totalLevelExperience = 0;
        }
    }

    public boolean isMaxLevel() {
        if (ConfigInit.CONFIG.overallMaxLevel != 0) {
            return this.overallLevel >= ConfigInit.CONFIG.overallMaxLevel;
        }
        return this.overallLevel >= ConfigInit.CONFIG.maxLevel * 12;
    }

    public boolean hasAvailableLevel() {
        return this.skillPoints > 0;
    }

    public int getNextLevelExperience() {
        if (this.isMaxLevel()) {
            return 0;
        }
        int experienceCost = (int)((double)ConfigInit.CONFIG.xpBaseCost + (double)ConfigInit.CONFIG.xpCostMultiplicator * Math.pow(this.overallLevel, ConfigInit.CONFIG.xpExponent));
        if (ConfigInit.CONFIG.xpMaxCost != 0) {
            return experienceCost >= ConfigInit.CONFIG.xpMaxCost ? ConfigInit.CONFIG.xpMaxCost : experienceCost;
        }
        return experienceCost;
    }

    public long getNonIndependentExperience() {
        int level = this.playerEntity.field_7520;
        float experienceProgress = this.playerEntity.field_7510;
        if (level == this.lastExperienceLevel && experienceProgress == this.lastExperienceProgress) {
            return this.lastExperience;
        }
        long exp = 0L;
        for (int i = 0; i < level; ++i) {
            if (i >= 30) {
                exp += (long)(112 + (i - 30) * 9);
                continue;
            }
            exp += i >= 15 ? (long)(37 + (i - 15) * 5) : (long)(7 + i * 2);
        }
        exp = (long)((float)exp + (float)this.playerEntity.method_7349() * experienceProgress);
        this.lastExperienceLevel = level;
        this.lastExperienceProgress = experienceProgress;
        this.lastExperience = exp;
        return exp;
    }

    public static boolean playerLevelisHighEnough(class_1657 playerEntity, List<Object> list, String string, boolean creativeRequired) {
        if (!playerEntity.method_7337() || !creativeRequired) {
            PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager();
            int playerLevel = 0;
            int maxLevel = ConfigInit.CONFIG.maxLevel;
            if (string != null ? !list.isEmpty() && list.contains(string) && (playerLevel = playerStatsManager.getLevel(list.get(list.indexOf(string) + 1).toString())) < maxLevel && playerLevel < (Integer)list.get(list.indexOf(string) + 2) : !list.isEmpty() && (playerLevel = playerStatsManager.getLevel(list.get(0).toString())) < maxLevel && playerLevel < (Integer)list.get(1)) {
                return false;
            }
        }
        return true;
    }

    public static boolean listContainsItemOrBlock(class_1657 playerEntity, int id, int reference) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager();
        return reference == 1 ? playerStatsManager.getSkillLevel(Skill.MINING) < ConfigInit.CONFIG.maxLevel && playerStatsManager.lockedBlockIds.contains(id) : (reference == 2 ? playerStatsManager.getSkillLevel(Skill.ALCHEMY) < ConfigInit.CONFIG.maxLevel && playerStatsManager.lockedbrewingItemIds.contains(id) : (reference == 3 ? playerStatsManager.getSkillLevel(Skill.SMITHING) < ConfigInit.CONFIG.maxLevel && playerStatsManager.lockedSmithingItemIds.contains(id) : reference == 4 && playerStatsManager.lockedCraftingItemIds.contains(id)));
    }

    public static int getUnlockLevel(int id, int reference) {
        if (reference == 1) {
            for (int i = 0; i < LevelLists.miningBlockList.size(); ++i) {
                if (!LevelLists.miningBlockList.get(i).contains(id)) continue;
                return LevelLists.miningLevelList.get(i);
            }
            return 0;
        }
        if (reference == 2) {
            for (int i = 0; i < LevelLists.brewingItemList.size(); ++i) {
                if (!LevelLists.brewingItemList.get(i).contains(id)) continue;
                return LevelLists.brewingLevelList.get(i);
            }
            return 0;
        }
        if (reference == 3) {
            for (int i = 0; i < LevelLists.smithingItemList.size(); ++i) {
                if (!LevelLists.smithingItemList.get(i).contains(id)) continue;
                return LevelLists.smithingLevelList.get(i);
            }
            return 0;
        }
        if (reference == 4) {
            for (int i = 0; i < LevelLists.craftingItemList.size(); ++i) {
                if (!LevelLists.craftingItemList.get(i).contains(id)) continue;
                return LevelLists.craftingLevelList.get(i);
            }
            return 0;
        }
        return 0;
    }

    public boolean resetSkill(Skill skill) {
        int sLevel = this.getSkillLevel(skill);
        if (sLevel > 0) {
            this.setSkillPoints(this.getSkillPoints() + sLevel);
            this.setSkillLevel(skill, 0);
            PlayerStatsServerPacket.writeS2CResetSkillPacket((class_3222)this.playerEntity, skill);
            return true;
        }
        return false;
    }

    public static boolean resetSkill(class_1657 playerEntity, Skill skill) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager();
        return playerStatsManager.resetSkill(skill);
    }

    public static void onLevelUp(class_1657 playerEntity, int playerLevel) {
    }
}

