/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.screen.widget;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.data.LevelLists;
import net.levelz.screen.SkillInfoScreen;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class SkillListScrollableWidget
extends class_7528 {
    private final String title;
    private final boolean mining;
    private final List<Integer> levelList;
    private final List<List<Integer>> objectList;
    private final List<String> skillList;
    private final class_327 textRenderer;
    private int totalYSpace = 0;
    private int ySpace = 0;
    private boolean scrollbarDragged;

    public SkillListScrollableWidget(int x, int y, int width, int height, List<Integer> levelList, List<List<Integer>> objectList, List<String> skillList, String title, class_327 textRenderer) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.title = title;
        this.textRenderer = textRenderer;
        this.levelList = levelList;
        this.objectList = objectList;
        this.skillList = skillList;
        this.mining = this.title.equals("mining");
    }

    protected void method_37021(class_6382 builder) {
    }

    protected void method_47399(class_6382 var1) {
    }

    protected int method_44391() {
        return this.totalYSpace;
    }

    protected boolean method_44392() {
        return this.totalYSpace > 185;
    }

    protected double method_44393() {
        return 27.0;
    }

    protected void method_44389(class_332 context, int mouseX, int mouseY, float delta) {
        this.ySpace = this.method_46427();
        for (int u = 0; u < this.levelList.size(); ++u) {
            if (this.objectList.get(u).isEmpty()) continue;
            if (!this.skillList.isEmpty()) {
                context.method_51439(this.textRenderer, (class_2561)class_2561.method_43469((String)("item.levelz." + this.skillList.get(u) + ".tooltip"), (Object[])new Object[]{this.levelList.get(u)}), this.method_46426(), this.ySpace, 0x3F3F3F, false);
            } else {
                context.method_51439(this.textRenderer, (class_2561)class_2561.method_43469((String)"text.levelz.level", (Object[])new Object[]{this.levelList.get(u)}), this.method_46426(), this.ySpace, 0x3F3F3F, false);
            }
            int listSplitter = 0;
            int gridXSpace = this.method_46426();
            this.ySpace += 16;
            for (int k = 0; k < this.objectList.get(u).size(); ++k) {
                class_1799 stack = null;
                ArrayList<Object> tooltip = new ArrayList<Object>();
                if (this.mining) {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10200(this.objectList.get(u).get(k).intValue());
                    stack = new class_1799((class_1935)block);
                    tooltip.add(block.method_9518());
                } else {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10200(this.objectList.get(u).get(k).intValue());
                    tooltip.add(item.method_7848());
                    stack = item.method_7854();
                    if (class_1845.method_8077((class_1799)item.method_7854()) && LevelLists.potionList.contains(item)) {
                        int index = LevelLists.potionList.indexOf(item);
                        class_1842 potion = (class_1842)LevelLists.potionList.get(index + 1);
                        class_1799 potionStack = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)potion);
                        tooltip.add(class_2561.method_30163((String)("Ingredient for " + class_2561.method_43471((String)((class_1812)class_1844.method_8061((class_1799)potionStack, (class_1842)potion).method_7909()).method_7866(potionStack)).getString())));
                    }
                }
                if (stack != null) {
                    context.method_51427(stack, gridXSpace, this.ySpace);
                    if (!tooltip.isEmpty() && this.isPointWithinBounds(gridXSpace - this.method_46426(), this.ySpace - this.method_46427() - (int)this.method_44387(), 16, 16, mouseX, mouseY)) {
                        context.method_44380();
                        context.method_51448().method_22903();
                        context.method_51448().method_22904(0.0, this.method_44387(), 0.0);
                        context.method_51434(this.textRenderer, tooltip, mouseX, mouseY);
                        context.method_51433(this.textRenderer, "", 0, 0, 0, false);
                        context.method_51448().method_22909();
                        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
                    }
                }
                gridXSpace += 18;
                if (++listSplitter % 9 != 0 && k != this.objectList.get(u).size() - 1) continue;
                this.ySpace += 18;
                gridXSpace = this.method_46426();
            }
            this.ySpace += 8;
        }
        if (this.totalYSpace == 0) {
            this.totalYSpace = this.ySpace - this.method_46427();
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        context.method_51448().method_22903();
        context.method_51448().method_22904(0.0, -this.method_44387(), 0.0);
        this.method_44389(context, mouseX, mouseY, delta);
        context.method_51448().method_22909();
        context.method_44380();
        this.method_44384(context);
    }

    protected void method_44384(class_332 context) {
        if (this.method_44392()) {
            int l = Math.max(this.method_46427() + 1, (int)this.method_44387() * (this.field_22759 - 27) / this.method_44390() + this.method_46427() - 1);
            context.method_25302(SkillInfoScreen.BACKGROUND_TEXTURE, this.method_46426() + 177, this.method_46427(), 200, 0, 8, 185);
            context.method_25302(SkillInfoScreen.BACKGROUND_TEXTURE, this.method_46426() + 178, l, 208, 0, 6, 27);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.field_22764) {
            return false;
        }
        this.method_44382(this.method_44387() - amount * this.method_44393());
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrollbarDragged = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22764) {
            return false;
        }
        boolean bl = this.method_44388(mouseX, mouseY);
        boolean bl2 = this.method_44392() && mouseX >= (double)(this.method_46426() + this.field_22758 - 5) && mouseX <= (double)(this.method_46426() + this.field_22758 + 1) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        this.method_25365(bl || bl2);
        if (bl2 && button == 0) {
            this.scrollbarDragged = true;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!(this.field_22764 && this.method_25370() && this.scrollbarDragged)) {
            return false;
        }
        if (mouseY < (double)this.method_46427()) {
            this.method_44382(0.0);
        } else if (mouseY > (double)(this.method_46427() + this.field_22759)) {
            this.method_44382(this.method_44390());
        } else {
            int i = this.getScrollbarThumbHeight();
            double d = Math.max(1, this.method_44390() / (this.field_22759 - i));
            this.method_44382(this.method_44387() + deltaY * d);
        }
        return true;
    }

    protected boolean method_44388(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46427() + this.field_22758 + 1) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    private int getContentsHeightWithPadding() {
        return this.method_44391() + 4;
    }

    private int getScrollbarThumbHeight() {
        return class_3532.method_15340((int)((int)((float)(this.field_22759 * this.field_22759) / (float)this.getContentsHeightWithPadding())), (int)32, (int)this.field_22759);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        double d;
        double d2;
        int i = this.method_46426();
        int j = this.method_46427();
        pointX -= (double)i;
        if (!(d2 >= (double)(x - 1))) return false;
        if (!(pointX < (double)(x + width + 1))) return false;
        pointY -= (double)j;
        if (!(d >= (double)(y - 1))) return false;
        if (!(pointY < (double)(y + height + 1))) return false;
        return true;
    }
}

