/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.data.LevelLoader;
import net.levelz.entity.LevelExperienceOrbEntity;
import net.levelz.init.ConfigInit;
import net.levelz.network.PlayerStatsServerPacket;
import net.levelz.stats.PlayerStatsManager;
import net.levelz.stats.Skill;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_746;

public class PlayerStatsClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.STATS_SYNC_PACKET, (client, handler, buf, sender) -> {
            String skillString = buf.method_19772().toUpperCase();
            int level = buf.readInt();
            int points = buf.readInt();
            client.execute(() -> {
                PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)client.field_1724).getPlayerStatsManager();
                Skill skill = Skill.valueOf(skillString);
                playerStatsManager.setSkillLevel(skill, level);
                playerStatsManager.setSkillPoints(points);
                if (skill == Skill.STRENGTH) {
                    playerStatsManager.getPlayerEntity().method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase + (double)playerStatsManager.getSkillLevel(Skill.STRENGTH) * ConfigInit.CONFIG.attackBonus);
                }
                PlayerStatsServerPacket.syncLockedCraftingItemList(playerStatsManager);
                switch (skill) {
                    case SMITHING: {
                        PlayerStatsServerPacket.syncLockedSmithingItemList(playerStatsManager);
                        break;
                    }
                    case MINING: {
                        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
                        break;
                    }
                    case ALCHEMY: {
                        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
                        break;
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.XP_PACKET, (client, handler, buf, sender) -> {
            class_2540 newBuffer = new class_2540(Unpooled.buffer());
            newBuffer.writeFloat(buf.readFloat());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            client.execute(() -> PlayerStatsClientPacket.executeXPPacket((class_1657)client.field_1724, newBuffer));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.LEVEL_PACKET, (client, handler, buf, sender) -> {
            class_2540 newBuffer = new class_2540(Unpooled.buffer());
            newBuffer.writeFloat(buf.readFloat());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            newBuffer.writeInt(buf.readInt());
            client.execute(() -> PlayerStatsClientPacket.executeLevelPacket((class_1657)client.field_1724, newBuffer));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.LIST_PACKET, (client, handler, buf, sender) -> {
            class_2540 newBuffer = new class_2540(Unpooled.buffer());
            while (buf.isReadable()) {
                newBuffer.method_10814(buf.method_19772());
            }
            client.execute(() -> PlayerStatsClientPacket.executeListPacket(newBuffer, client.field_1724));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.STRENGTH_PACKET, (client, handler, buf, sender) -> {
            double damageAttribute = buf.readDouble();
            client.execute(() -> client.field_1724.method_5996(class_5134.field_23721).method_6192(damageAttribute));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.RESET_PACKET, (client, handler, buf, sender) -> {
            if (client.field_1724 != null) {
                String skillString = buf.method_19772();
                client.execute(() -> {
                    Skill skill = Skill.valueOf(skillString.toUpperCase());
                    PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)client.field_1724).getPlayerStatsManager();
                    int skillLevel = playerStatsManager.getSkillLevel(skill);
                    playerStatsManager.setSkillPoints(playerStatsManager.getSkillPoints() + skillLevel);
                    playerStatsManager.setSkillLevel(skill, 0);
                    switch (skill) {
                        case HEALTH: {
                            client.field_1724.method_5996(class_5134.field_23716).method_6192(ConfigInit.CONFIG.healthBase);
                            client.field_1724.method_6033(client.field_1724.method_6063());
                            break;
                        }
                        case STRENGTH: {
                            client.field_1724.method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase);
                            break;
                        }
                        case AGILITY: {
                            client.field_1724.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase);
                            break;
                        }
                        case DEFENSE: {
                            client.field_1724.method_5996(class_5134.field_23724).method_6192(ConfigInit.CONFIG.defenseBase);
                            break;
                        }
                        case LUCK: {
                            client.field_1724.method_5996(class_5134.field_23726).method_6192(ConfigInit.CONFIG.luckBase);
                            break;
                        }
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PlayerStatsServerPacket.LEVEL_EXPERIENCE_ORB_PACKET, (client, handler, buf, sender) -> {
            int id = buf.method_10816();
            double d = buf.readDouble();
            double e = buf.readDouble();
            double f = buf.readDouble();
            short experienceAmount = buf.readShort();
            client.execute(() -> {
                LevelExperienceOrbEntity levelExperienceOrbEntity = new LevelExperienceOrbEntity((class_1937)client.field_1687, d, e, f, experienceAmount);
                if (levelExperienceOrbEntity != null) {
                    levelExperienceOrbEntity.method_43391(d, e, f);
                    levelExperienceOrbEntity.method_36456(0.0f);
                    levelExperienceOrbEntity.method_36457(0.0f);
                    levelExperienceOrbEntity.method_5838(id);
                    client.field_1687.method_2942(id, (class_1297)levelExperienceOrbEntity);
                }
            });
        });
    }

    public static void writeC2SIncreaseLevelPacket(PlayerStatsManager playerStatsManager, Skill skill, int level) {
        int skillLevel = playerStatsManager.getSkillLevel(skill);
        level = Math.min(playerStatsManager.getSkillPoints(), level);
        level = Math.min(ConfigInit.CONFIG.maxLevel - skillLevel, level);
        if (ConfigInit.CONFIG.allowHigherSkillLevel) {
            level = Math.min(Math.abs(ConfigInit.CONFIG.maxLevel - skillLevel), level);
        }
        if (level < 1) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(skill.name());
        buf.writeInt(level);
        class_2817 packet = new class_2817(PlayerStatsServerPacket.STATS_INCREASE_PACKET, buf);
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }

    private static void executeXPPacket(class_1657 player, class_2540 buf) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager();
        playerStatsManager.setLevelProgress(buf.readFloat());
        playerStatsManager.setTotalLevelExperience(buf.readInt());
        playerStatsManager.setOverallLevel(buf.readInt());
    }

    private static void executeLevelPacket(class_1657 player, class_2540 buf) {
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager();
        playerStatsManager.setLevelProgress(buf.readFloat());
        playerStatsManager.setTotalLevelExperience(buf.readInt());
        playerStatsManager.setOverallLevel(buf.readInt());
        playerStatsManager.setSkillPoints(buf.readInt());
        for (Skill skill : Skill.values()) {
            playerStatsManager.setSkillLevel(skill, buf.readInt());
        }
        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedSmithingItemList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedCraftingItemList(playerStatsManager);
    }

    private static void executeListPacket(class_2540 buf, class_746 player) {
        LevelLoader.clearEveryList();
        ArrayList<String> list = new ArrayList<String>();
        while (buf.isReadable()) {
            list.add(buf.method_19772());
        }
        for (int i = 0; i < list.size(); ++i) {
            int u;
            String listName = ((String)list.get(i)).toString();
            if (LevelLists.getListNames().contains(listName)) {
                int count = 2;
                int negativeCount = -2;
                if (listName.equals("minecraft:armor") || listName.equals("minecraft:tool") || listName.equals("minecraft:hoe") || listName.equals("minecraft:sword") || listName.equals("minecraft:axe") || listName.equals("minecraft:custom_block") || listName.equals("minecraft:custom_item") || listName.equals("minecraft:custom_entity")) {
                    --negativeCount;
                }
                if (listName.equals("minecraft:enchanting_table")) {
                    count = 5;
                }
                for (int u2 = negativeCount; u2 < count; ++u2) {
                    PlayerStatsClientPacket.addToList(listName, (String)list.get(i + u2));
                }
                continue;
            }
            if (listName.equals("mining:level")) {
                ArrayList<Integer> blockList = new ArrayList<Integer>();
                LevelLists.miningLevelList.add(Integer.parseInt((String)list.get(i + 1)));
                for (u = i + 2; u < list.size() && !((String)list.get(u)).equals("mining:level") && !((String)list.get(u)).equals("brewing:level"); ++u) {
                    blockList.add(Integer.parseInt((String)list.get(u)));
                }
                LevelLists.miningBlockList.add(blockList);
                continue;
            }
            if (listName.equals("brewing:level")) {
                ArrayList<Integer> brewingItemList = new ArrayList<Integer>();
                LevelLists.brewingLevelList.add(Integer.parseInt((String)list.get(i + 1)));
                for (u = i + 2; u < list.size() && !((String)list.get(u)).equals("brewing:level") && !((String)list.get(u)).equals("smithing:level"); ++u) {
                    brewingItemList.add(Integer.parseInt((String)list.get(u)));
                }
                LevelLists.brewingItemList.add(brewingItemList);
                continue;
            }
            if (listName.equals("smithing:level")) {
                ArrayList<Integer> smithingItemList = new ArrayList<Integer>();
                LevelLists.smithingLevelList.add(Integer.parseInt((String)list.get(i + 1)));
                for (u = i + 2; u < list.size() && !((String)list.get(u)).equals("smithing:level") && !((String)list.get(u)).equals("crafting:level"); ++u) {
                    smithingItemList.add(Integer.parseInt((String)list.get(u)));
                }
                LevelLists.smithingItemList.add(smithingItemList);
                continue;
            }
            if (!listName.equals("crafting:level")) continue;
            ArrayList<Integer> craftingItemList = new ArrayList<Integer>();
            LevelLists.craftingLevelList.add(Integer.parseInt((String)list.get(i + 1)));
            LevelLists.craftingSkillList.add(String.valueOf(list.get(i + 2)));
            for (u = i + 3; u < list.size() && !((String)list.get(u)).equals("crafting:level"); ++u) {
                craftingItemList.add(Integer.parseInt((String)list.get(u)));
            }
            LevelLists.craftingItemList.add(craftingItemList);
        }
        LevelLists.listOfAllLists.clear();
        LevelLoader.addAllInOneList();
        PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)player).getPlayerStatsManager();
        player.method_5996(class_5134.field_23716).method_6192(ConfigInit.CONFIG.healthBase + (double)playerStatsManager.getSkillLevel(Skill.HEALTH) * ConfigInit.CONFIG.healthBonus);
        player.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase + (double)playerStatsManager.getSkillLevel(Skill.AGILITY) * ConfigInit.CONFIG.movementBonus);
        player.method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase + (double)playerStatsManager.getSkillLevel(Skill.STRENGTH) * ConfigInit.CONFIG.attackBonus);
        player.method_5996(class_5134.field_23724).method_6192(ConfigInit.CONFIG.defenseBase + (double)playerStatsManager.getSkillLevel(Skill.DEFENSE) * ConfigInit.CONFIG.defenseBonus);
        player.method_5996(class_5134.field_23726).method_6192(ConfigInit.CONFIG.luckBase + (double)playerStatsManager.getSkillLevel(Skill.LUCK) * ConfigInit.CONFIG.luckBonus);
        PlayerStatsServerPacket.syncLockedBlockList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedBrewingItemList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedSmithingItemList(playerStatsManager);
        PlayerStatsServerPacket.syncLockedCraftingItemList(playerStatsManager);
    }

    private static void addToList(String listName, String object) {
        if (object.matches("-?(0|[1-9]\\d*)")) {
            LevelLists.getList(listName).add(Integer.parseInt(object));
        } else if (object.equals("false") || object.equals("true")) {
            LevelLists.getList(listName).add(Boolean.parseBoolean(object));
        } else {
            LevelLists.getList(listName).add(object);
        }
    }

    public static void writeC2SLevelUpPacket(int levels) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(levels);
        class_2817 packet = new class_2817(PlayerStatsServerPacket.LEVEL_UP_BUTTON_PACKET, buf);
        Objects.requireNonNull(class_310.method_1551().method_1562()).method_2883((class_2596)packet);
    }
}

