/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.levelz.init.ConfigInit;
import net.libz.api.ConfigSync;

@Config(name="levelz")
@Config.Gui.Background(value="minecraft:textures/block/stone.png")
public class LevelzConfig
implements ConfigData,
ConfigSync {
    @ConfigEntry.Category(value="level_settings")
    @ConfigEntry.Gui.RequiresRestart
    @Comment(value="Maximum level per skills")
    public int maxLevel = 20;
    @ConfigEntry.Category(value="level_settings")
    @ConfigEntry.Gui.RequiresRestart
    @Comment(value="Maximum level: 0 = disabled")
    public int overallMaxLevel = 0;
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="In combination with overallMaxLevel, only when all skills maxed")
    public boolean allowHigherSkillLevel = false;
    @ConfigEntry.Category(value="level_settings")
    @ConfigEntry.Gui.RequiresRestart
    @Comment(value="Applies if bonus chest world setting is enabled")
    public int startPoints = 5;
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="Enables starter points for SERVER only")
    public boolean enableStartPoints = false;
    @ConfigEntry.Category(value="level_settings")
    public int pointsPerLevel = 1;
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="If true will reset stats on death")
    public boolean hardMode = false;
    @ConfigEntry.Category(value="level_settings")
    public boolean disableMobFarms = true;
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="Amount of allowed mob kills in a chunk")
    public int mobKillCount = 5;
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="Strange potion resets all stats instead of one")
    public boolean opStrangePotion = false;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="restrict hand usage when item not unlocked")
    public boolean lockedHandUsage = false;
    @ConfigEntry.Category(value="level_settings")
    @Comment(value="Only for Devs")
    public boolean devMode = false;
    @ConfigEntry.Gui.RequiresRestart
    @Comment(value="Attribute values - Bonus for each lvl")
    public double healthBase = ConfigInit.isOriginsLoaded ? 20.0 : 6.0;
    @ConfigEntry.Gui.RequiresRestart
    public double healthBonus = 1.0;
    @Comment(value="Absorption Bonus at max lvl")
    public float healthAbsorptionBonus = 6.0f;
    @ConfigEntry.Gui.RequiresRestart
    @Comment(value="Levelz Screen Multiplies it by 10")
    public double movementBase = 0.09;
    @ConfigEntry.Gui.RequiresRestart
    public double movementBonus = 0.001;
    @Comment(value="Chance of damage misses player at max lvl")
    public float movementMissChance = 0.05f;
    @Comment(value="Reduces fall damage")
    public float movementFallBonus = 0.25f;
    @ConfigEntry.Gui.RequiresRestart
    public double attackBase = 1.0;
    @ConfigEntry.Gui.RequiresRestart
    public double attackBonus = 0.2;
    @Comment(value="Chance of double meele damage at max lvl")
    public float attackDoubleDamageChance = 0.03f;
    public float attackCritDmgBonus = 0.2f;
    @ConfigEntry.Gui.RequiresRestart
    public double defenseBase = 0.0;
    @ConfigEntry.Gui.RequiresRestart
    public double defenseBonus = 0.2;
    @Comment(value="Chance of damage reflection at max lvl")
    public float defenseReflectChance = 0.05f;
    @ConfigEntry.Gui.RequiresRestart
    public double luckBase = 0.0;
    @ConfigEntry.Gui.RequiresRestart
    public double luckBonus = 0.05;
    public float luckCritBonus = 0.01f;
    @Comment(value="Chance of not dying at max lvl")
    public float luckSurviveChance = 0.5f;
    public float staminaBase = 1.1f;
    public float staminaBonus = 0.02f;
    public float staminaHealthBonus = 0.05f;
    @Comment(value="Food is more nutritious at max lvl")
    public float staminaFoodBonus = 0.3f;
    @Comment(value="Price reduction in %")
    public double tradeBonus = 1.0;
    public float tradeXPBonus = 0.5f;
    @Comment(value="Disables bad reputation possibility at max lvl")
    public boolean tradeReputation = true;
    public float smithingCostBonus = 0.015f;
    @Comment(value="Chance of no tool damage")
    public float smithingToolChance = 0.01f;
    @Comment(value="Chance of no xp usage on anvil at max lvl")
    public float smithingAnvilChance = 0.1f;
    @Comment(value="Min level to get chance of more crops drop")
    public int farmingBase = 10;
    @Comment(value="Chance of more crops drop")
    public float farmingChanceBonus = 0.01f;
    @Comment(value="Breeding twin chance at max lvl")
    public float farmingTwinChance = 0.2f;
    @Comment(value="Chance of increased enchantment strength")
    public float alchemyEnchantmentChance = 0.005f;
    @Comment(value="Chance of drinking potion with double value at max lvl")
    public float alchemyPotionChance = 0.05f;
    public float archeryInaccuracyBonus = 0.015f;
    public float archeryBowExtraDamage = 0.2f;
    public float archeryCrossbowExtraDamage = 0.2f;
    @Comment(value="Chance of double range damage at max lvl")
    public float archeryDoubleDamageChance = 0.05f;
    @Comment(value="Chance of more ore drop")
    public float miningOreChance = 0.01f;
    @Comment(value="Tnt power increase at max lvl")
    public float miningTntBonus = 0.5f;
    @Comment(value="Locked blocks break slower factor")
    public float miningLockedMultiplicator = 2.0f;
    public boolean bindAxeDamageToSwordRestriction = true;
    @ConfigEntry.Category(value="experience_settings")
    @ConfigEntry.Gui.RequiresRestart
    @Comment(value="Caution! Level up use independent levelz xp system")
    public boolean useIndependentExp = true;
    @ConfigEntry.Category(value="experience_settings")
    @Comment(value="XP equation: lvl^exponent * multiplicator + base")
    public float xpCostMultiplicator = 0.1f;
    @ConfigEntry.Category(value="experience_settings")
    public int xpExponent = 2;
    @ConfigEntry.Category(value="experience_settings")
    public int xpBaseCost = 50;
    @ConfigEntry.Category(value="experience_settings")
    @Comment(value="0 = no experience cap")
    public int xpMaxCost = 0;
    @ConfigEntry.Category(value="experience_settings")
    public boolean resetCurrentXP = true;
    @ConfigEntry.Category(value="experience_settings")
    public boolean dropPlayerXP = true;
    @ConfigEntry.Category(value="experience_settings")
    public boolean dropXPbasedOnLvl = false;
    @ConfigEntry.Category(value="experience_settings")
    @Comment(value="0.01 = 1% more xp per lvl")
    public float basedOnMultiplier = 0.01f;
    @ConfigEntry.Category(value="experience_settings")
    public float breedingXPMultiplier = 1.0f;
    @ConfigEntry.Category(value="experience_settings")
    public float bottleXPMultiplier = 1.0f;
    @ConfigEntry.Category(value="experience_settings")
    public float dragonXPMultiplier = 0.5f;
    @ConfigEntry.Category(value="experience_settings")
    public float fishingXPMultiplier = 0.8f;
    @ConfigEntry.Category(value="experience_settings")
    public float furnaceXPMultiplier = 0.1f;
    @ConfigEntry.Category(value="experience_settings")
    public float oreXPMultiplier = 1.0f;
    @ConfigEntry.Category(value="experience_settings")
    public float tradingXPMultiplier = 0.3f;
    @ConfigEntry.Category(value="experience_settings")
    public float mobXPMultiplier = 1.0f;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    @Comment(value="Highlight locked blocks in red.")
    public boolean highlightLocked = false;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public boolean sortCraftingRecipesBySkill = false;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public boolean inventorySkillLevel = true;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public int inventorySkillLevelPosX = 0;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public int inventorySkillLevelPosY = 0;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean showLevelList = true;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public boolean showLevel = true;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    @Comment(value="Switch levelz screen instead of closing with inventory key")
    public boolean switch_screen = false;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public boolean showLockedBlockInfo = false;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public int lockedBlockInfoPosX = 0;
    @ConfigSync.ClientOnly
    @ConfigEntry.Category(value="gui_settings")
    public int lockedBlockInfoPosY = 0;
    @ConfigEntry.Category(value="progression_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean miningProgression = true;
    @ConfigEntry.Category(value="progression_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean itemProgression = true;
    @ConfigEntry.Category(value="progression_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean blockProgression = true;
    @ConfigEntry.Category(value="progression_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean entityProgression = true;
    @ConfigEntry.Category(value="progression_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean brewingProgression = true;
    @ConfigEntry.Category(value="progression_settings")
    @ConfigEntry.Gui.RequiresRestart
    public boolean smithingProgression = true;

    public void updateConfig(ConfigData data) {
        ConfigInit.CONFIG = (LevelzConfig)data;
    }
}

