/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.entity.RayTraceResultJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.player.PlayerEventJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

@Info(value="Invoked when a player right clicks with an item **without targeting anything**.\n\nNot to be confused with `BlockEvents.rightClick` or `ItemEvents.entityInteracted`.\n")
public class ItemClickedEventJS
extends PlayerEventJS {
    private final class_1657 player;
    private final class_1268 hand;
    private final class_1799 item;
    private RayTraceResultJS target;

    public ItemClickedEventJS(class_1657 player, class_1268 hand, class_1799 item) {
        this.player = player;
        this.hand = hand;
        this.item = item;
    }

    @Override
    @Info(value="The player that clicked with the item.")
    public class_1657 getEntity() {
        return this.player;
    }

    @Info(value="The hand that the item was clicked with.")
    public class_1268 getHand() {
        return this.hand;
    }

    @Info(value="The item that was clicked with.")
    public class_1799 getItem() {
        return this.item;
    }

    @Info(value="The ray trace result of the click.")
    public RayTraceResultJS getTarget() {
        if (this.target == null) {
            this.target = this.player.kjs$rayTrace();
        }
        return this.target;
    }

    @Override
    @Nullable
    protected Object defaultExitValue() {
        return this.item;
    }

    @Override
    @Nullable
    protected Object mapExitValue(@Nullable Object value) {
        return ItemStackJS.of(value);
    }
}

