/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.knightlib.api.IGreatChaliceInteractable;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.common.entity.BaseProjectile;
import dev.xylonity.knightlib.common.entity.projectile.GreatChaliceStartsetRing;
import dev.xylonity.knightlib.common.recipe.ChaliceFillingRecipe;
import dev.xylonity.knightlib.registry.KnightLibBlocks;
import dev.xylonity.knightlib.registry.KnightLibEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ChaliceFillingRecipeCategory
implements IRecipeCategory<ChaliceFillingRecipe> {
    public static final class_2960 UID = new class_2960("knightlib", "block_filling");
    public static final RecipeType<ChaliceFillingRecipe> TYPE = new RecipeType(UID, ChaliceFillingRecipe.class);
    public static final class_2960 SHADOW = new class_2960("knightlib", "textures/gui/shadow.png");
    private GreatChaliceBlockEntity cachedBlockEntity;
    private GreatChaliceStartsetRing cachedEntity;
    private long lastUpdateTime = 0L;
    private final IDrawable icon;
    private long lastEntityAppearTime = 0L;
    private static final long ENTITY_VISIBLE_DURATION = 500L;
    private static final long ENTITY_INTERVAL = 2000L;
    private long lastEntityTickAdvanceTime = 0L;
    private ChaliceFillingRecipe currentRecipe;

    public ChaliceFillingRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)KnightLibBlocks.GREAT_CHALICE.get()));
    }

    @NotNull
    public RecipeType<ChaliceFillingRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.knightlib.great_chalice_fill_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 80;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ChaliceFillingRecipe rec, @NotNull IFocusGroup focuses) {
        this.currentRecipe = rec;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input());
    }

    private GreatChaliceBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new GreatChaliceBlockEntity(class_2338.field_10980, KnightLibBlocks.GREAT_CHALICE.get().method_9564());
            this.cachedBlockEntity.setCharges(12);
        }
        return this.cachedBlockEntity;
    }

    private GreatChaliceStartsetRing getOrCreateEntity() {
        long currentTime;
        if (this.cachedEntity == null) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 != null) {
                this.cachedEntity = new GreatChaliceStartsetRing((class_1299<? extends BaseProjectile>)KnightLibEntities.GREAT_CHALICE_STARSET_RING, (class_1937)mc.field_1687);
                this.cachedEntity.method_5875(true);
            }
        }
        if (this.cachedEntity != null && (currentTime = System.currentTimeMillis()) - this.lastEntityTickAdvanceTime >= 50L) {
            ++this.cachedEntity.field_6012;
            this.lastEntityTickAdvanceTime = currentTime;
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastEntityAppearTime >= 2000L) {
            GreatChaliceBlockEntity blockEntity;
            int current;
            int next;
            this.lastEntityAppearTime = currentTime;
            GreatChaliceStartsetRing entity = this.getOrCreateEntity();
            if (entity != null) {
                entity.field_6012 = 0;
            }
            int amountToAdd = 1;
            class_1792 class_17922 = this.currentRecipe.input().method_7909();
            if (class_17922 instanceof IGreatChaliceInteractable) {
                IGreatChaliceInteractable stack = (IGreatChaliceInteractable)class_17922;
                amountToAdd = stack.getChargesToApply();
            }
            if ((next = (current = (blockEntity = this.getOrCreateBlockEntity()).getCharges()) + amountToAdd) > 12) {
                next = 0;
            }
            blockEntity.setCharges(next);
        }
        this.lastUpdateTime = currentTime;
    }

    public void draw(@NotNull ChaliceFillingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        GeoEntityRenderer entityRenderer;
        RenderSystem.setShaderTexture((int)0, (class_2960)SHADOW);
        guiGraphics.method_25302(SHADOW, 21, 55, 0, 0, 39, 17);
        guiGraphics.method_25302(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.method_25302(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        GreatChaliceBlockEntity blockEntity = this.getOrCreateBlockEntity();
        GreatChaliceStartsetRing entity = this.getOrCreateEntity();
        GeoBlockRenderer blockRenderer = (GeoBlockRenderer)class_310.method_1551().method_31975().method_3550((class_2586)blockEntity);
        GeoEntityRenderer geoEntityRenderer = entityRenderer = entity != null ? (GeoEntityRenderer)class_310.method_1551().method_1561().method_3953((class_1297)entity) : null;
        if (blockRenderer == null) {
            return;
        }
        class_4587 pose = guiGraphics.method_51448();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        pose.method_22903();
        pose.method_46416(60.0f, 55.0f, 20.0f);
        pose.method_22905(24.0f, 24.0f, 24.0f);
        pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.method_23760().method_23762();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            blockRenderer.method_3569((class_2586)blockEntity, partialTicks, pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15), class_4608.field_21444);
        }
        catch (Exception e) {
            blockRenderer.method_3569((class_2586)blockEntity, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15), class_4608.field_21444);
        }
        pose.method_22909();
        if (entity != null && System.currentTimeMillis() - this.lastEntityAppearTime < 500L) {
            pose.method_22903();
            pose.method_22904(60.0, 66.0, 27.5);
            pose.method_22905(24.0f, 24.0f, 24.0f);
            pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
            pose.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
            pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            entityRenderer.method_3936((class_1297)entity, 0.0f, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
            pose.method_22909();
        }
        buffer.method_22993();
    }
}

