/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api;

import dev.xylonity.knightlib.mixin.CameraAccessor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_4184;

public final class CameraShakeManager {
    private static final Map<UUID, Shake> SHAKES = new ConcurrentHashMap<UUID, Shake>();

    private CameraShakeManager() {
    }

    public static void shake(class_1657 player, int durationTicks, float intensityX, float intensityY, float intensityZ, int fadeStartTick) {
        SHAKES.put(player.method_5667(), new Shake(class_156.method_658(), player.method_37908(), durationTicks, intensityX, intensityY, intensityZ, fadeStartTick));
    }

    public static void applyShakeIfPresent(class_1657 player, class_4184 camera) {
        Shake shake = SHAKES.get(player.method_5667());
        if (shake == null) {
            return;
        }
        if (shake.isExpired()) {
            SHAKES.remove(player.method_5667());
            return;
        }
        shake.apply(camera);
    }

    public static void clear() {
        SHAKES.values().removeIf(Shake::isExpired);
    }

    private record Shake(long startMillis, class_1937 lvl, int durationTicks, float ix, float iy, float iz, int fadeStart) {
        void apply(class_4184 camera) {
            int elapsed = (int)((class_156.method_658() - this.startMillis) / 50L);
            float fade = 1.0f;
            if (this.fadeStart >= 0 && elapsed >= this.fadeStart) {
                fade = 1.0f - Math.min(1.0f, (float)(elapsed - this.fadeStart) / (float)(this.durationTicks - this.fadeStart));
            }
            double x = (this.lvl.field_9229.method_43058() - 0.5) * (double)this.ix * (double)fade;
            double y = (this.lvl.field_9229.method_43058() - 0.5) * (double)this.iy * (double)fade;
            double z = (this.lvl.field_9229.method_43058() - 0.5) * (double)this.iz * (double)fade;
            ((CameraAccessor)camera).moveAccessor(x, y, z);
        }

        boolean isExpired() {
            return (class_156.method_658() - this.startMillis) / 50L >= (long)this.durationTicks;
        }
    }
}

