/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.jumpanimation.networking;

import com.saltywater.jumpanimation.client.JumpAnimationClient;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_742;

public class JumpAnimationNetworking {
    public static final class_2960 ANIMATION_PACKET_ID = new class_2960("jumpanimation", "animation_packet");

    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ANIMATION_PACKET_ID, (client, handler, buf, responseSender) -> {
            UUID playerUUID = buf.method_10790();
            String animationName = buf.method_19772();
            client.execute(() -> {
                class_742 player;
                if (client.field_1687 != null && (player = (class_742)client.field_1687.method_18470(playerUUID)) != null) {
                    if (animationName.equals("stop_animation")) {
                        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                        animationStack.removeLayer(0);
                        if (player.method_5667().equals(class_310.method_1551().field_1724.method_5667())) {
                            JumpAnimationClient.isFallingAnimationActive = false;
                            JumpAnimationClient.isCannonballAnimationActive = false;
                            JumpAnimationClient.isLandingAnimationActive = false;
                            JumpAnimationClient.isDivingAnimationActive = false;
                            JumpAnimationClient.landingAnimationPlayer = null;
                            JumpAnimationClient.divingAnimationPlayer = null;
                        }
                    } else {
                        class_2960 animationId = new class_2960("jumpanimation", animationName);
                        JumpAnimationNetworking.playReceivedAnimation(player, animationId);
                    }
                }
            });
        });
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ANIMATION_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            UUID playerUUID = buf.method_10790();
            String animationName = buf.method_19772();
            server.execute(() -> JumpAnimationNetworking.broadcastAnimationToNearbyPlayers(player, animationName));
        });
    }

    private static void playReceivedAnimation(class_742 player, class_2960 animationId) {
        KeyframeAnimation animation = PlayerAnimationRegistry.getAnimation((class_2960)animationId);
        if (animation != null) {
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            animationStack.removeLayer(0);
            KeyframeAnimationPlayer animationPlayer = new KeyframeAnimationPlayer(animation);
            animationStack.addAnimLayer(0, (IAnimation)animationPlayer);
            if (player.method_5667().equals(class_310.method_1551().field_1724.method_5667())) {
                switch (animationId.method_12832()) {
                    case "falling": {
                        JumpAnimationClient.isFallingAnimationActive = true;
                        JumpAnimationClient.isCannonballAnimationActive = false;
                        JumpAnimationClient.isDivingAnimationActive = false;
                        JumpAnimationClient.isLandingAnimationActive = false;
                        JumpAnimationClient.landingAnimationPlayer = null;
                        JumpAnimationClient.divingAnimationPlayer = null;
                        break;
                    }
                    case "cannonball": {
                        JumpAnimationClient.isCannonballAnimationActive = true;
                        JumpAnimationClient.isFallingAnimationActive = false;
                        JumpAnimationClient.isDivingAnimationActive = false;
                        JumpAnimationClient.isLandingAnimationActive = false;
                        JumpAnimationClient.landingAnimationPlayer = null;
                        JumpAnimationClient.divingAnimationPlayer = null;
                        break;
                    }
                    case "diving": {
                        JumpAnimationClient.isDivingAnimationActive = true;
                        JumpAnimationClient.isFallingAnimationActive = false;
                        JumpAnimationClient.isCannonballAnimationActive = false;
                        JumpAnimationClient.isLandingAnimationActive = false;
                        JumpAnimationClient.landingAnimationPlayer = null;
                        JumpAnimationClient.divingAnimationPlayer = animationPlayer;
                        break;
                    }
                    case "fall": 
                    case "highfall": 
                    case "roll": {
                        JumpAnimationClient.isLandingAnimationActive = true;
                        JumpAnimationClient.isFallingAnimationActive = false;
                        JumpAnimationClient.isCannonballAnimationActive = false;
                        JumpAnimationClient.isDivingAnimationActive = false;
                        JumpAnimationClient.landingAnimationPlayer = animationPlayer;
                        JumpAnimationClient.divingAnimationPlayer = null;
                        break;
                    }
                    default: {
                        JumpAnimationClient.isFallingAnimationActive = false;
                        JumpAnimationClient.isCannonballAnimationActive = false;
                        JumpAnimationClient.isLandingAnimationActive = false;
                        JumpAnimationClient.isDivingAnimationActive = false;
                        JumpAnimationClient.landingAnimationPlayer = null;
                        JumpAnimationClient.divingAnimationPlayer = null;
                    }
                }
            }
        }
    }

    private static void broadcastAnimationToNearbyPlayers(class_3222 sender, String animationName) {
        double radius = 64.0;
        class_1937 world = sender.method_37908();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(sender.method_5667());
        buf.method_10814(animationName);
        for (class_1657 playerEntity : world.method_18456()) {
            class_3222 serverPlayer;
            if (!(playerEntity instanceof class_3222) || (serverPlayer = (class_3222)playerEntity) == sender || !(serverPlayer.method_5858((class_1297)sender) <= radius * radius)) continue;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ANIMATION_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendAnimationPacket(String animationName) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(client.field_1724.method_5667());
            buf.method_10814(animationName);
            ClientPlayNetworking.send((class_2960)ANIMATION_PACKET_ID, (class_2540)buf);
        }
    }
}

