/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.jumpanimation.mixin;

import com.saltywater.jumpanimation.client.JumpAnimationClient;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class JumpAnimationMixin {
    @Unique
    private double peakY = 0.0;
    @Unique
    private boolean fallingAnimationTriggered = false;
    @Unique
    private boolean cannonballTriggered = false;
    @Unique
    private boolean divingAnimationTriggered = false;
    @Unique
    private boolean hasStartedFalling = false;

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    private void onJump(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.method_37908().method_8608() && entity instanceof class_742) {
            class_742 player = (class_742)entity;
            JumpAnimationClient.playJumpAnimation(player);
            this.peakY = player.method_23318();
            this.fallingAnimationTriggered = false;
            this.cannonballTriggered = false;
            this.divingAnimationTriggered = false;
            this.hasStartedFalling = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        double currentY;
        double fallDistance;
        class_1309 entity = (class_1309)this;
        if (!entity.method_37908().method_8608()) return;
        if (!(entity instanceof class_742)) return;
        class_742 player = (class_742)entity;
        if (player.method_5799()) {
            JumpAnimationClient.stopFallingAnimation(player);
            this.fallingAnimationTriggered = false;
            this.hasStartedFalling = false;
            this.peakY = player.method_23318();
            return;
        }
        if (player.method_24828()) {
            this.peakY = player.method_23318();
            this.fallingAnimationTriggered = false;
            this.cannonballTriggered = false;
            this.divingAnimationTriggered = false;
            this.hasStartedFalling = false;
            return;
        }
        if (!(player.method_18798().field_1351 < -0.1)) {
            this.peakY = player.method_23318();
            return;
        }
        if (!this.hasStartedFalling) {
            this.peakY = player.method_23318();
            this.hasStartedFalling = true;
        }
        if (JumpAnimationClient.isLandingAnimationActive && JumpAnimationClient.landingAnimationPlayer == null) {
            JumpAnimationClient.isLandingAnimationActive = false;
        }
        if (!((fallDistance = this.peakY - (currentY = player.method_23318())) >= 1.5)) return;
        if (!this.cannonballTriggered && !this.divingAnimationTriggered && player instanceof class_746) {
            class_746 clientPlayer = (class_746)player;
            if (clientPlayer.field_3913.field_3904) {
                if (fallDistance >= 6.0) {
                    JumpAnimationClient.playCannonballAnimation(player);
                    this.cannonballTriggered = true;
                    this.fallingAnimationTriggered = false;
                    JumpAnimationClient.stopFallingAnimation(player);
                    return;
                }
                JumpAnimationClient.playDivingAnimation(player);
                this.divingAnimationTriggered = true;
                this.fallingAnimationTriggered = false;
                JumpAnimationClient.stopFallingAnimation(player);
                return;
            }
        }
        if (this.fallingAnimationTriggered) return;
        if (this.cannonballTriggered) return;
        if (this.divingAnimationTriggered) return;
        if (!(fallDistance >= 6.0)) return;
        JumpAnimationClient.playFallingAnimation(player);
        this.fallingAnimationTriggered = true;
    }

    @Inject(method={"fall"}, at={@At(value="HEAD")})
    private void onFall(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.method_37908().method_8608() && entity instanceof class_742) {
            class_742 player = (class_742)entity;
            if (player.method_5799()) {
                if (this.cannonballTriggered) {
                    JumpAnimationClient.playDivingCannonballAnimation(player);
                    this.cannonballTriggered = false;
                    this.fallingAnimationTriggered = false;
                    this.hasStartedFalling = false;
                } else if (this.divingAnimationTriggered) {
                    JumpAnimationClient.playSwimUpAnimation(player);
                    this.divingAnimationTriggered = false;
                    this.fallingAnimationTriggered = false;
                    this.hasStartedFalling = false;
                }
            } else if (player.method_24828()) {
                if (this.divingAnimationTriggered) {
                    JumpAnimationClient.playRollAnimation(player);
                    this.divingAnimationTriggered = false;
                    this.fallingAnimationTriggered = false;
                    this.hasStartedFalling = false;
                    JumpAnimationClient.fallSlowTicks = 0;
                } else {
                    double fallDistance = this.peakY - player.method_23318();
                    if (fallDistance >= 6.0) {
                        JumpAnimationClient.playFallAnimation(player, true);
                    } else if (fallDistance >= 3.5) {
                        JumpAnimationClient.playFallAnimation(player, false);
                    }
                }
                this.peakY = player.method_23318();
                this.fallingAnimationTriggered = false;
                this.cannonballTriggered = false;
                this.hasStartedFalling = false;
            }
        }
    }
}

