/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.jumpanimation.client;

import com.saltywater.jumpanimation.networking.JumpAnimationNetworking;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2960;
import net.minecraft.class_742;

public class JumpAnimationClient
implements ClientModInitializer {
    private static boolean lastJumpWasFlip = false;
    private static final class_2960 JUMP_ANIMATION = new class_2960("jumpanimation", "jump");
    private static final class_2960 JUMP_FLIP_ANIMATION = new class_2960("jumpanimation", "jumpflip");
    private static final class_2960 STOPPED_JUMP_ANIMATION = new class_2960("jumpanimation", "stoppedjump");
    private static final class_2960 STOPPED_JUMP_FLIP_ANIMATION = new class_2960("jumpanimation", "stoppedjumpflip");
    private static final class_2960 RUNNING_JUMP_ANIMATION = new class_2960("jumpanimation", "runningjump");
    private static final class_2960 RUNNING_JUMP_FLIP_ANIMATION = new class_2960("jumpanimation", "runningjumpflip");
    private static final class_2960 FALL_ANIMATION = new class_2960("jumpanimation", "fall");
    private static final class_2960 FALLING_ANIMATION = new class_2960("jumpanimation", "falling");
    private static final class_2960 HIGHFALL_ANIMATION = new class_2960("jumpanimation", "highfall");
    private static final class_2960 CANNONBALL_ANIMATION = new class_2960("jumpanimation", "cannonball");
    private static final class_2960 DIVING_CANNONBALL_ANIMATION = new class_2960("jumpanimation", "divingcannonball");
    private static final class_2960 DIVING_ANIMATION = new class_2960("jumpanimation", "diving");
    private static final class_2960 ROLL_ANIMATION = new class_2960("jumpanimation", "roll");
    private static final class_2960 SWIMUP_ANIMATION = new class_2960("jumpanimation", "swimup");
    public static int fallSlowTicks = 0;
    public static boolean isFallingAnimationActive = false;
    public static boolean isCannonballAnimationActive = false;
    public static boolean isLandingAnimationActive = false;
    public static boolean isDivingAnimationActive = false;
    public static KeyframeAnimationPlayer landingAnimationPlayer = null;
    public static KeyframeAnimationPlayer divingAnimationPlayer = null;

    public void onInitializeClient() {
        JumpAnimationNetworking.registerClientReceiver();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (fallSlowTicks > 0 && client.field_1724 != null) {
                JumpAnimationClient.applyFallSpeedReduction((class_742)client.field_1724);
                --fallSlowTicks;
            }
            if (isLandingAnimationActive && landingAnimationPlayer != null && !landingAnimationPlayer.isActive()) {
                isLandingAnimationActive = false;
                landingAnimationPlayer = null;
            }
            if (isDivingAnimationActive && divingAnimationPlayer != null && !divingAnimationPlayer.isActive()) {
                isDivingAnimationActive = false;
                divingAnimationPlayer = null;
            }
        });
    }

    public static void playJumpAnimation(class_742 player) {
        class_2960 animationId = player.field_6250 == 0.0f && player.field_6212 == 0.0f ? (lastJumpWasFlip ? STOPPED_JUMP_FLIP_ANIMATION : STOPPED_JUMP_ANIMATION) : (player.method_5624() ? (lastJumpWasFlip ? RUNNING_JUMP_FLIP_ANIMATION : RUNNING_JUMP_ANIMATION) : (lastJumpWasFlip ? JUMP_FLIP_ANIMATION : JUMP_ANIMATION));
        lastJumpWasFlip = !lastJumpWasFlip;
        JumpAnimationClient.playAnimation(player, animationId);
    }

    public static void playFallAnimation(class_742 player, boolean isHighFall) {
        class_2960 animationId = isHighFall ? HIGHFALL_ANIMATION : FALL_ANIMATION;
        isLandingAnimationActive = true;
        landingAnimationPlayer = JumpAnimationClient.playAnimation(player, animationId);
        fallSlowTicks = isHighFall ? 30 : 10;
    }

    public static void playFallingAnimation(class_742 player) {
        if (isCannonballAnimationActive || isLandingAnimationActive || isDivingAnimationActive) {
            return;
        }
        isFallingAnimationActive = true;
        JumpAnimationClient.playAnimation(player, FALLING_ANIMATION);
        JumpAnimationNetworking.sendAnimationPacket(FALLING_ANIMATION.method_12832());
    }

    public static void stopFallingAnimation(class_742 player) {
        if (isFallingAnimationActive) {
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            animationStack.removeLayer(0);
            isFallingAnimationActive = false;
            JumpAnimationNetworking.sendAnimationPacket("stop_animation");
        }
    }

    public static void playCannonballAnimation(class_742 player) {
        isCannonballAnimationActive = true;
        isFallingAnimationActive = false;
        JumpAnimationClient.playAnimation(player, CANNONBALL_ANIMATION);
        JumpAnimationNetworking.sendAnimationPacket(CANNONBALL_ANIMATION.method_12832());
    }

    public static void playDivingCannonballAnimation(class_742 player) {
        isCannonballAnimationActive = false;
        JumpAnimationClient.playAnimation(player, DIVING_CANNONBALL_ANIMATION);
        JumpAnimationNetworking.sendAnimationPacket(DIVING_CANNONBALL_ANIMATION.method_12832());
    }

    public static void playDivingAnimation(class_742 player) {
        isDivingAnimationActive = true;
        isFallingAnimationActive = false;
        divingAnimationPlayer = JumpAnimationClient.playAnimation(player, DIVING_ANIMATION);
        JumpAnimationNetworking.sendAnimationPacket(DIVING_ANIMATION.method_12832());
    }

    public static void playRollAnimation(class_742 player) {
        isDivingAnimationActive = false;
        isLandingAnimationActive = true;
        landingAnimationPlayer = JumpAnimationClient.playAnimation(player, ROLL_ANIMATION);
        JumpAnimationNetworking.sendAnimationPacket(ROLL_ANIMATION.method_12832());
    }

    public static void playSwimUpAnimation(class_742 player) {
        isDivingAnimationActive = false;
        JumpAnimationClient.playAnimation(player, SWIMUP_ANIMATION);
        JumpAnimationNetworking.sendAnimationPacket(SWIMUP_ANIMATION.method_12832());
    }

    public static void stopAnimation(class_742 player) {
        if (isFallingAnimationActive || isCannonballAnimationActive || isLandingAnimationActive || isDivingAnimationActive) {
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            animationStack.removeLayer(0);
            isFallingAnimationActive = false;
            isCannonballAnimationActive = false;
            isLandingAnimationActive = false;
            isDivingAnimationActive = false;
            landingAnimationPlayer = null;
            divingAnimationPlayer = null;
            JumpAnimationNetworking.sendAnimationPacket("stop_animation");
        }
    }

    private static void applyFallSpeedReduction(class_742 player) {
        player.method_18799(player.method_18798().method_18805(0.5, 1.0, 0.5));
        player.field_6037 = true;
    }

    private static KeyframeAnimationPlayer playAnimation(class_742 player, class_2960 animationId) {
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
        animationStack.removeLayer(0);
        KeyframeAnimation animation = PlayerAnimationRegistry.getAnimation((class_2960)animationId);
        if (animation != null) {
            KeyframeAnimationPlayer animationPlayer = new KeyframeAnimationPlayer(animation);
            animationStack.addAnimLayer(0, (IAnimation)animationPlayer);
            JumpAnimationNetworking.sendAnimationPacket(animationId.method_12832());
            return animationPlayer;
        }
        return null;
    }
}

