/*
 * Decompiled with CFR 0.152.
 */
package julescraft.blocksandstuff.battledome;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import julescraft.blocksandstuff.battledome.BattleDome;
import net.minecraft.class_2338;

public class BattleDomeManager {
    private static final BattleDomeManager INSTANCE = new BattleDomeManager();
    private final Map<class_2338, BattleDome> activeDomes = new ConcurrentHashMap<class_2338, BattleDome>();
    private final Set<class_2338> protectedBlocks = Collections.synchronizedSet(new HashSet());

    private BattleDomeManager() {
    }

    public static BattleDomeManager getInstance() {
        return INSTANCE;
    }

    public void addDome(BattleDome dome) {
        this.activeDomes.put(dome.getPos(), dome);
    }

    public void removeDome(class_2338 pos) {
        this.activeDomes.remove(pos);
    }

    public void addProtectedBlocks(Collection<class_2338> positions) {
        this.protectedBlocks.addAll(positions);
    }

    public void addProtectedBlock(class_2338 pos) {
        this.protectedBlocks.add(pos);
    }

    public void removeProtectedBlocks(Collection<class_2338> positions) {
        this.protectedBlocks.removeAll(positions);
    }

    public void removeProtectedBlock(class_2338 pos) {
        this.protectedBlocks.remove(pos);
    }

    public boolean isBlockProtected(class_2338 pos) {
        return this.protectedBlocks.contains(pos);
    }

    public BattleDome getDome(class_2338 pos) {
        return this.activeDomes.get(pos);
    }

    public Map<class_2338, BattleDome> getActiveDomes() {
        return this.activeDomes;
    }
}

