/*
 * Decompiled with CFR 0.152.
 */
package julescraft.blocksandstuff.battledome;

import java.util.ArrayList;
import java.util.List;
import julescraft.blocksandstuff.Julesblocksandstuff;
import julescraft.blocksandstuff.battledome.BattleDome;
import julescraft.blocksandstuff.battledome.BattleDomeManager;
import julescraft.blocksandstuff.battledome.BattleDomeScreenHandler;
import julescraft.blocksandstuff.util.ImplementedInventory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_7923;

public class BattleDomeBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private final List<class_2338> domeBlocks = new ArrayList<class_2338>();
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int domeRadius = 10;
    private boolean domeActive = false;
    private int mobCount = 1;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return BattleDomeBlockEntity.this.domeRadius;
                }
                case 1: {
                    return BattleDomeBlockEntity.this.domeActive ? 1 : 0;
                }
                case 2: {
                    return BattleDomeBlockEntity.this.mobCount;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            Julesblocksandstuff.LOGGER.info("PropertyDelegate set on server: index=" + index + ", value=" + value);
            switch (index) {
                case 0: {
                    BattleDomeBlockEntity.this.domeRadius = value;
                    BattleDomeBlockEntity.this.method_5431();
                    break;
                }
                case 1: {
                    boolean bl = BattleDomeBlockEntity.this.domeActive = value != 0;
                    if (BattleDomeBlockEntity.this.field_11863 == null || ((BattleDomeBlockEntity)BattleDomeBlockEntity.this).field_11863.field_9236) break;
                    BattleDomeBlockEntity.this.updateDome(BattleDomeBlockEntity.this.domeActive, BattleDomeBlockEntity.this.domeRadius);
                    break;
                }
                case 2: {
                    BattleDomeBlockEntity.this.mobCount = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public BattleDomeBlockEntity(class_2338 pos, class_2680 state) {
        super(Julesblocksandstuff.BATTLE_DOME_BLOCK_ENTITY, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.julesblocksandstuff.battledome");
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BattleDomeScreenHandler(syncId, playerInventory, this, this.propertyDelegate, this.field_11867);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public void updateDome(boolean active, int radius) {
        Julesblocksandstuff.LOGGER.info("Updating dome on server: active=" + active + ", radius=" + radius);
        this.domeActive = active;
        this.domeRadius = radius;
        if (active) {
            this.generateDome(radius);
            this.spawnMonsters();
            BattleDomeManager.getInstance().addDome(new BattleDome(this.field_11867, radius));
        } else {
            this.removeDome();
            BattleDomeManager.getInstance().removeDome(this.field_11867);
        }
        this.method_5431();
    }

    private void spawnMonsters() {
        if (this.field_11863 == null || this.field_11863.field_9236 || this.mobCount == 0) {
            return;
        }
        if (Julesblocksandstuff.getConfig().playMobSpawnSound) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14792, class_3419.field_15245, 1.0f, 1.0f);
        }
        class_1657 closestPlayer = this.field_11863.method_18459((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.domeRadius + 5), false);
        class_2338 baseSpawnPos = this.field_11867.method_10084();
        if (closestPlayer != null) {
            class_243 playerLook = closestPlayer.method_5720();
            baseSpawnPos = closestPlayer.method_24515().method_10069((int)(playerLook.field_1352 * 6.0), 0, (int)(playerLook.field_1350 * 6.0));
        }
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (!(stack.method_7909() instanceof class_1826)) continue;
            class_1826 eggItem = (class_1826)stack.method_7909();
            class_1299 entityType = eggItem.method_8015(stack.method_7969());
            for (int j = 0; j < this.mobCount; ++j) {
                class_1308 entity = (class_1308)entityType.method_5883(this.field_11863);
                if (entity == null) continue;
                class_2338 spawnPos = baseSpawnPos;
                spawnPos = spawnPos.method_10069(this.field_11863.field_9229.method_43048(3) - 1, 0, this.field_11863.field_9229.method_43048(3) - 1);
                entity.method_23327((double)spawnPos.method_10263() + 0.5, (double)(spawnPos.method_10264() + 1), (double)spawnPos.method_10260() + 0.5);
                ((class_3218)this.field_11863).method_30771((class_1297)entity);
            }
            if (!Julesblocksandstuff.getConfig().consumeSpawnEggs) continue;
            stack.method_7934(1);
        }
    }

    private void generateDome(int radius) {
        this.removeDome();
        class_2248 domeBlock = (class_2248)class_7923.field_41175.method_10223(new class_2960(Julesblocksandstuff.getConfig().domeBlock));
        if (domeBlock == class_2246.field_10124) {
            domeBlock = class_2246.field_10033;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 blockPos;
                    if (!(Math.sqrt(x * x + y * y + z * z) >= (double)radius - 0.5) || !(Math.sqrt(x * x + y * y + z * z) <= (double)radius + 0.5) || !this.field_11863.method_8320(blockPos = this.field_11867.method_10069(x, y, z)).method_26215()) continue;
                    this.field_11863.method_8501(blockPos, domeBlock.method_9564());
                    this.domeBlocks.add(blockPos);
                }
            }
        }
        if (Julesblocksandstuff.getConfig().playActivationSound) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14703, class_3419.field_15245, 1.0f, 1.0f);
        }
        BattleDomeManager manager = BattleDomeManager.getInstance();
        manager.addProtectedBlocks(this.domeBlocks);
        manager.addProtectedBlock(this.field_11867);
    }

    private void removeDome() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            if (Julesblocksandstuff.getConfig().playDeactivationSound) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_19344, class_3419.field_15245, 1.0f, 1.0f);
            }
            class_238 domeBox = new class_238(this.field_11867).method_1014((double)this.domeRadius);
            List entities = this.field_11863.method_8390(class_1297.class, domeBox, entity -> entity instanceof class_1308 && !(entity instanceof class_1657));
            for (class_1297 entity2 : entities) {
                entity2.method_31472();
            }
            BattleDome dome = BattleDomeManager.getInstance().getDome(this.field_11867);
            if (dome != null) {
                if (Julesblocksandstuff.getConfig().enableHealing) {
                    for (class_1657 player : dome.getPlayers()) {
                        player.method_6033(player.method_6063());
                    }
                }
                if (Julesblocksandstuff.getConfig().enableRepair) {
                    for (class_1657 player : dome.getPlayers()) {
                        for (class_1799 itemStack : player.method_31548().field_7547) {
                            if (!itemStack.method_7963()) continue;
                            itemStack.method_7974(0);
                        }
                        for (class_1799 itemStack : player.method_31548().field_7548) {
                            if (!itemStack.method_7963()) continue;
                            itemStack.method_7974(0);
                        }
                        for (class_1799 itemStack : player.method_31548().field_7544) {
                            if (!itemStack.method_7963()) continue;
                            itemStack.method_7974(0);
                        }
                    }
                }
            }
        }
        BattleDomeManager manager = BattleDomeManager.getInstance();
        manager.removeProtectedBlocks(this.domeBlocks);
        manager.removeProtectedBlock(this.field_11867);
        for (class_2338 blockPos : this.domeBlocks) {
            if (!this.field_11863.method_8320(blockPos).method_27852((class_2248)class_7923.field_41175.method_10223(new class_2960(Julesblocksandstuff.getConfig().domeBlock)))) continue;
            this.field_11863.method_8501(blockPos, class_2246.field_10124.method_9564());
        }
        this.domeBlocks.clear();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.domeRadius = nbt.method_10550("DomeRadius");
        this.domeActive = nbt.method_10577("DomeActive");
        this.mobCount = nbt.method_10550("MobCount");
        if (this.domeActive && this.field_11863 != null) {
            this.generateDome(this.domeRadius);
            BattleDomeManager.getInstance().addDome(new BattleDome(this.field_11867, this.domeRadius));
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("DomeRadius", this.domeRadius);
        nbt.method_10556("DomeActive", this.domeActive);
        nbt.method_10569("MobCount", this.mobCount);
    }
}

