/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplustools.item.mode;

import com.daqem.jobsplustools.JobsPlusTools;
import com.daqem.jobsplustools.item.mode.IMode;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public interface ModeItem
extends class_1935 {
    @NotNull
    default public IMode getActiveMode(class_1799 stack) {
        return ModeItemSerializer.deserialize(stack.method_7948(), this);
    }

    default public void setActiveMode(@NotNull class_1799 stack, @NotNull IMode mode) {
        ModeItemSerializer.serialize(stack.method_7948(), mode, this);
    }

    public List<IMode> getAvailableModes();

    default public IMode getDefaultMode() {
        return this.getAvailableModes().get(0);
    }

    default public IMode getNextMode(class_1799 stack) {
        List<IMode> availableModes = this.getAvailableModes();
        int index = availableModes.indexOf(this.getActiveMode(stack));
        if (index == availableModes.size() - 1) {
            return this.getDefaultMode();
        }
        return availableModes.get(index + 1);
    }

    default public void switchMode(class_3222 player, class_1799 stack) {
        IMode nextMode = this.getNextMode(stack);
        this.setActiveMode(stack, nextMode);
        player.method_43502((class_2561)nextMode.getName().method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), true);
    }

    default public List<class_2561> getModesTooltip(class_1799 stack) {
        List<IMode> availableModes = this.getAvailableModes();
        if (availableModes.isEmpty()) {
            return List.of(JobsPlusTools.translatable("tooltip.no_modes").method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        class_5250 modes = JobsPlusTools.literal("").method_27661();
        for (IMode mode : availableModes) {
            class_5250 component = mode.getName().method_27661();
            if (mode.equals(this.getActiveMode(stack))) {
                component.method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
            } else {
                component.method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
            }
            if (availableModes.indexOf(mode) != availableModes.size() - 1) {
                component.method_10852((class_2561)JobsPlusTools.literal(", ").method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
            }
            modes.method_10852((class_2561)component);
        }
        return List.of(JobsPlusTools.translatable("tooltip.modes", modes).method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), JobsPlusTools.translatable("tooltip.switch_mode").method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    public static class ModeItemSerializer {
        public static final String MODE_TAG = "Mode";

        public static void serialize(class_2487 tag, IMode mode, ModeItem item) {
            tag.method_10569(MODE_TAG, item.getAvailableModes().indexOf(mode));
        }

        public static IMode deserialize(class_2487 tag, ModeItem item) {
            return item.getAvailableModes().get(tag.method_10550(MODE_TAG));
        }
    }
}

